/*
 * Decompiled with CFR 0.152.
 */
package cascading.nested.json;

import cascading.CascadingTestCase;
import cascading.nested.json.JSONCoercibleType;
import cascading.nested.json.JSONRegexFilter;
import cascading.operation.Filter;
import cascading.operation.OperationException;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import java.lang.reflect.Type;
import java.util.regex.Pattern;
import org.junit.Test;

public class JSONFilterTest
extends CascadingTestCase {
    @Test
    public void testRegexFilter() {
        TupleEntry entry = new TupleEntry(new Fields((Comparable)((Object)"json"), (Type)JSONCoercibleType.TYPE), Tuple.size((int)1));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"{\"person\":{\"name\":\"John Doe\",\"firstName\":\"John\",\"lastName\":\"Doe\",\"age\":50,\"human\":true,\"city\":\"Houston\",\"ssn\":\"123-45-6789\",\"measure\": { \"value\":100 },\"measures\":[ { \"value\":1000 }, { \"value\":2000 } ],\"measured\":[ 1000, 2000 ],\"children\":[\"Jane\",\"June\",\"Josh\"],\"arrays\":[[\"Jane1\",\"June1\",\"Josh1\"],[\"Jane2\",\"June2\",\"Josh2\"]],\"zero\": { \"zeroValue\":0 }}}");
        JSONFilterTest.assertTrue((boolean)JSONFilterTest.invokeFilter((Filter)new JSONRegexFilter("/person/name", Pattern.compile("John D Doe")), (TupleEntry)entry));
        JSONFilterTest.assertTrue((boolean)JSONFilterTest.invokeFilter((Filter)new JSONRegexFilter("/person/name", Pattern.compile("^John$")), (TupleEntry)entry));
        JSONFilterTest.assertFalse((boolean)JSONFilterTest.invokeFilter((Filter)new JSONRegexFilter("/person/name", Pattern.compile("^John Doe$")), (TupleEntry)entry));
        JSONFilterTest.assertFalse((boolean)JSONFilterTest.invokeFilter((Filter)new JSONRegexFilter("/person/name", Pattern.compile("John Doe")), (TupleEntry)entry));
        JSONFilterTest.assertFalse((boolean)JSONFilterTest.invokeFilter((Filter)new JSONRegexFilter("/person/name", Pattern.compile("John[ ]Doe$")), (TupleEntry)entry));
    }

    @Test
    public void testRegexFilterArray() {
        TupleEntry entry = new TupleEntry(new Fields((Comparable)((Object)"json"), (Type)JSONCoercibleType.TYPE), Tuple.size((int)1));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"{\n\"annotations\": [\n{\n\"name\": \"begin\",\n\"value\": 1570476797161000\n},\n{\n\"name\": \"end\",\n\"value\": 1570476797161001\n}\n]\n}\n");
        JSONFilterTest.assertFalse((boolean)JSONFilterTest.invokeFilter((Filter)new JSONRegexFilter("/annotations/*/name", Pattern.compile("begin")), (TupleEntry)entry));
        JSONFilterTest.assertFalse((boolean)JSONFilterTest.invokeFilter((Filter)new JSONRegexFilter("/annotations/*/name", Pattern.compile("end")), (TupleEntry)entry));
    }

    @Test(expected=OperationException.class)
    public void testRegexFilterArrayException() {
        TupleEntry entry = new TupleEntry(new Fields((Comparable)((Object)"json"), (Type)JSONCoercibleType.TYPE), Tuple.size((int)1));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"{\n\"annotations\": [\n{\n\"name\": \"begin\",\n\"value\": 1570476797161000\n},\n{\n\"name\": \"end\",\n\"value\": 1570476797161001\n}\n]\n}\n");
        JSONFilterTest.assertFalse((boolean)JSONFilterTest.invokeFilter((Filter)new JSONRegexFilter("/annotations/name", Pattern.compile("begin")), (TupleEntry)entry));
    }

    @Test
    public void testRegexFilterArrayNoException() {
        TupleEntry entry = new TupleEntry(new Fields((Comparable)((Object)"json"), (Type)JSONCoercibleType.TYPE), Tuple.size((int)1));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"{\n\"annotations\": [\n{\n\"name\": \"begin\",\n\"value\": 1570476797161000\n},\n{\n\"name\": \"end\",\n\"value\": 1570476797161001\n}\n]\n}\n");
        JSONFilterTest.assertFalse((boolean)JSONFilterTest.invokeFilter((Filter)new JSONRegexFilter("/annotations/name", Pattern.compile("^$"), false), (TupleEntry)entry));
    }
}

