/*
 * Decompiled with CFR 0.152.
 */
package cascading.nested.json;

import cascading.CascadingTestCase;
import cascading.nested.json.JSONCoercibleType;
import cascading.nested.json.JSONCreateFunction;
import cascading.nested.json.JSONSetFunction;
import cascading.operation.Function;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.TupleListCollector;
import com.fasterxml.jackson.databind.JsonNode;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Objects;
import org.junit.Test;

public class JSONSetCreateFunctionTest
extends CascadingTestCase {
    @Test
    public void testSet() throws Exception {
        TupleEntry entry = new TupleEntry(new Fields((Comparable)((Object)"json"), (Type)JSONCoercibleType.TYPE).append(new Fields((Comparable)((Object)"name"), String.class)), Tuple.size((int)2));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"{\"person\":{\"name\":\"John Doe\",\"firstName\":\"John\",\"lastName\":\"Doe\",\"age\":50,\"human\":true,\"city\":\"Houston\",\"ssn\":\"123-45-6789\",\"measure\": { \"value\":100 },\"measures\":[ { \"value\":1000 }, { \"value\":2000 } ],\"measured\":[ 1000, 2000 ],\"children\":[\"Jane\",\"June\",\"Josh\"],\"arrays\":[[\"Jane1\",\"June1\",\"Josh1\"],[\"Jane2\",\"June2\",\"Josh2\"]],\"zero\": { \"zeroValue\":0 }}}");
        entry.setObject((Comparable)Integer.valueOf(1), (Object)"Jane Doe");
        JSONSetFunction function = new JSONSetFunction(new Fields(new Comparable[]{"result"}), new Fields((Comparable)((Object)"name"), String.class), "/person/otherName");
        TupleListCollector result = JSONSetCreateFunctionTest.invokeFunction((Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
        JsonNode value = (JsonNode)((Tuple)result.iterator().next()).getObject(0);
        JSONSetCreateFunctionTest.assertNotNull((Object)value);
        JSONSetCreateFunctionTest.assertEquals((String)"Jane Doe", (String)value.at("/person/otherName").textValue());
    }

    @Test
    public void testSetReplace() throws Exception {
        TupleEntry entry = new TupleEntry(new Fields((Comparable)((Object)"json"), (Type)JSONCoercibleType.TYPE).append(new Fields((Comparable)((Object)"name"), String.class)), Tuple.size((int)2));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"{\"person\":{\"name\":\"John Doe\",\"firstName\":\"John\",\"lastName\":\"Doe\",\"age\":50,\"human\":true,\"city\":\"Houston\",\"ssn\":\"123-45-6789\",\"measure\": { \"value\":100 },\"measures\":[ { \"value\":1000 }, { \"value\":2000 } ],\"measured\":[ 1000, 2000 ],\"children\":[\"Jane\",\"June\",\"Josh\"],\"arrays\":[[\"Jane1\",\"June1\",\"Josh1\"],[\"Jane2\",\"June2\",\"Josh2\"]],\"zero\": { \"zeroValue\":0 }}}");
        entry.setObject((Comparable)Integer.valueOf(1), (Object)"Jane Doe");
        JSONSetFunction function = new JSONSetFunction(new Fields(new Comparable[]{"result"}), new Fields((Comparable)((Object)"name"), String.class), "/person/name");
        TupleListCollector result = JSONSetCreateFunctionTest.invokeFunction((Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
        JsonNode value = (JsonNode)((Tuple)result.iterator().next()).getObject(0);
        JSONSetCreateFunctionTest.assertNotNull((Object)value);
        JSONSetCreateFunctionTest.assertEquals((String)"Jane Doe", (String)value.at("/person/name").textValue());
    }

    @Test
    public void testSetDeep() throws Exception {
        TupleEntry entry = new TupleEntry(new Fields((Comparable)((Object)"json"), (Type)JSONCoercibleType.TYPE).append(new Fields((Comparable)((Object)"name"), String.class)), Tuple.size((int)2));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"{\"person\":{\"name\":\"John Doe\",\"firstName\":\"John\",\"lastName\":\"Doe\",\"age\":50,\"human\":true,\"city\":\"Houston\",\"ssn\":\"123-45-6789\",\"measure\": { \"value\":100 },\"measures\":[ { \"value\":1000 }, { \"value\":2000 } ],\"measured\":[ 1000, 2000 ],\"children\":[\"Jane\",\"June\",\"Josh\"],\"arrays\":[[\"Jane1\",\"June1\",\"Josh1\"],[\"Jane2\",\"June2\",\"Josh2\"]],\"zero\": { \"zeroValue\":0 }}}");
        entry.setObject((Comparable)Integer.valueOf(1), (Object)"Jane Doe");
        JSONSetFunction function = new JSONSetFunction(new Fields(new Comparable[]{"result"}), new Fields((Comparable)((Object)"name"), String.class), "/person/foo/name");
        TupleListCollector result = JSONSetCreateFunctionTest.invokeFunction((Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
        JsonNode value = (JsonNode)((Tuple)result.iterator().next()).getObject(0);
        JSONSetCreateFunctionTest.assertNotNull((Object)value);
        JSONSetCreateFunctionTest.assertEquals((String)"Jane Doe", (String)value.at("/person/foo/name").textValue());
    }

    @Test
    public void testSetMap() throws Exception {
        TupleEntry entry = new TupleEntry(new Fields((Comparable)((Object)"json"), (Type)JSONCoercibleType.TYPE).append(new Fields((Comparable)((Object)"name"), String.class)), Tuple.size((int)2));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"{\"person\":{\"name\":\"John Doe\",\"firstName\":\"John\",\"lastName\":\"Doe\",\"age\":50,\"human\":true,\"city\":\"Houston\",\"ssn\":\"123-45-6789\",\"measure\": { \"value\":100 },\"measures\":[ { \"value\":1000 }, { \"value\":2000 } ],\"measured\":[ 1000, 2000 ],\"children\":[\"Jane\",\"June\",\"Josh\"],\"arrays\":[[\"Jane1\",\"June1\",\"Josh1\"],[\"Jane2\",\"June2\",\"Josh2\"]],\"zero\": { \"zeroValue\":0 }}}");
        entry.setObject((Comparable)Integer.valueOf(1), (Object)"Jane Doe");
        JSONSetFunction function = new JSONSetFunction(new Fields(new Comparable[]{"result"}), Collections.singletonMap(new Fields((Comparable)((Object)"name"), String.class), "/person/name"));
        TupleListCollector result = JSONSetCreateFunctionTest.invokeFunction((Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
        JsonNode value = (JsonNode)((Tuple)result.iterator().next()).getObject(0);
        JSONSetCreateFunctionTest.assertNotNull((Object)value);
        JSONSetCreateFunctionTest.assertEquals((String)"Jane Doe", (String)value.at("/person/name").textValue());
    }

    @Test
    public void testSetMapResolved() throws Exception {
        TupleEntry entry = new TupleEntry(new Fields((Comparable)((Object)"json"), (Type)JSONCoercibleType.TYPE).append(new Fields((Comparable)((Object)"name"), String.class)), Tuple.size((int)2));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"{\"person\":{\"name\":\"John Doe\",\"firstName\":\"John\",\"lastName\":\"Doe\",\"age\":50,\"human\":true,\"city\":\"Houston\",\"ssn\":\"123-45-6789\",\"measure\": { \"value\":100 },\"measures\":[ { \"value\":1000 }, { \"value\":2000 } ],\"measured\":[ 1000, 2000 ],\"children\":[\"Jane\",\"June\",\"Josh\"],\"arrays\":[[\"Jane1\",\"June1\",\"Josh1\"],[\"Jane2\",\"June2\",\"Josh2\"]],\"zero\": { \"zeroValue\":0 }}}");
        entry.setObject((Comparable)Integer.valueOf(1), (Object)"Jane Doe");
        JSONSetFunction function = new JSONSetFunction(new Fields(new Comparable[]{"result"}), Collections.singletonMap(new Fields((Comparable)Integer.valueOf(1), String.class), "/person/name"));
        TupleListCollector result = JSONSetCreateFunctionTest.invokeFunction((Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
        JsonNode value = (JsonNode)((Tuple)result.iterator().next()).getObject(0);
        JSONSetCreateFunctionTest.assertNotNull((Object)value);
        JSONSetCreateFunctionTest.assertEquals((String)"Jane Doe", (String)value.at("/person/name").textValue());
    }

    @Test
    public void testSetResolvedArguments() throws Exception {
        TupleEntry entry = new TupleEntry(new Fields((Comparable)((Object)"json"), (Type)JSONCoercibleType.TYPE).append(new Fields((Comparable)((Object)"name"), String.class)), Tuple.size((int)2));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"{\"person\":{\"name\":\"John Doe\",\"firstName\":\"John\",\"lastName\":\"Doe\",\"age\":50,\"human\":true,\"city\":\"Houston\",\"ssn\":\"123-45-6789\",\"measure\": { \"value\":100 },\"measures\":[ { \"value\":1000 }, { \"value\":2000 } ],\"measured\":[ 1000, 2000 ],\"children\":[\"Jane\",\"June\",\"Josh\"],\"arrays\":[[\"Jane1\",\"June1\",\"Josh1\"],[\"Jane2\",\"June2\",\"Josh2\"]],\"zero\": { \"zeroValue\":0 }}}");
        entry.setObject((Comparable)Integer.valueOf(1), (Object)"Jane Doe");
        Fields fieldDeclaration = new Fields(new Comparable[]{"result"});
        JSONSetFunction function = new JSONSetFunction(fieldDeclaration);
        TupleListCollector result = JSONSetCreateFunctionTest.invokeFunction((Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
        JsonNode value = (JsonNode)((Tuple)result.iterator().next()).getObject(0);
        JSONSetCreateFunctionTest.assertNotNull((Object)value);
        JSONSetCreateFunctionTest.assertEquals((String)"Jane Doe", (String)value.at("/name").textValue());
    }

    @Test
    public void testSetResolvedArgumentsWithRoot() throws Exception {
        TupleEntry entry = new TupleEntry(new Fields((Comparable)((Object)"json"), (Type)JSONCoercibleType.TYPE).append(new Fields((Comparable)((Object)"name"), String.class)), Tuple.size((int)2));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"{\"person\":{\"name\":\"John Doe\",\"firstName\":\"John\",\"lastName\":\"Doe\",\"age\":50,\"human\":true,\"city\":\"Houston\",\"ssn\":\"123-45-6789\",\"measure\": { \"value\":100 },\"measures\":[ { \"value\":1000 }, { \"value\":2000 } ],\"measured\":[ 1000, 2000 ],\"children\":[\"Jane\",\"June\",\"Josh\"],\"arrays\":[[\"Jane1\",\"June1\",\"Josh1\"],[\"Jane2\",\"June2\",\"Josh2\"]],\"zero\": { \"zeroValue\":0 }}}");
        entry.setObject((Comparable)Integer.valueOf(1), (Object)"Jane Doe");
        Fields fieldDeclaration = new Fields(new Comparable[]{"result"});
        JSONSetFunction function = new JSONSetFunction(fieldDeclaration, "/person2");
        TupleListCollector result = JSONSetCreateFunctionTest.invokeFunction((Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
        JsonNode value = (JsonNode)((Tuple)result.iterator().next()).getObject(0);
        JSONSetCreateFunctionTest.assertNotNull((Object)value);
        JSONSetCreateFunctionTest.assertEquals((String)"Jane Doe", (String)value.at("/person2/name").textValue());
    }

    @Test
    public void testCreate() throws Exception {
        TupleEntry entry = new TupleEntry(new Fields((Comparable)((Object)"name"), String.class), Tuple.size((int)1));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"Jane Doe");
        JSONCreateFunction function = new JSONCreateFunction(new Fields(new Comparable[]{"result"}), new Fields((Comparable)((Object)"name"), String.class), "/person/otherName");
        TupleListCollector result = JSONSetCreateFunctionTest.invokeFunction((Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
        JsonNode value = (JsonNode)((Tuple)result.iterator().next()).getObject(0);
        JSONSetCreateFunctionTest.assertNotNull((Object)value);
        JSONSetCreateFunctionTest.assertEquals((String)"Jane Doe", (String)value.at("/person/otherName").textValue());
    }

    @Test
    public void testCreateDeep() throws Exception {
        TupleEntry entry = new TupleEntry(new Fields((Comparable)((Object)"name"), String.class), Tuple.size((int)1));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"Jane Doe");
        JSONCreateFunction function = new JSONCreateFunction(new Fields(new Comparable[]{"result"}), new Fields((Comparable)((Object)"name"), String.class), "/person/foo/name");
        TupleListCollector result = JSONSetCreateFunctionTest.invokeFunction((Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
        JsonNode value = (JsonNode)((Tuple)result.iterator().next()).getObject(0);
        JSONSetCreateFunctionTest.assertNotNull((Object)value);
        JSONSetCreateFunctionTest.assertEquals((String)"Jane Doe", (String)value.at("/person/foo/name").textValue());
    }

    @Test
    public void testCreateMap() throws Exception {
        TupleEntry entry = new TupleEntry(new Fields((Comparable)((Object)"name"), String.class), Tuple.size((int)1));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"Jane Doe");
        JSONCreateFunction function = new JSONCreateFunction(new Fields(new Comparable[]{"result"}), Collections.singletonMap(new Fields((Comparable)((Object)"name"), String.class), "/person/name"));
        TupleListCollector result = JSONSetCreateFunctionTest.invokeFunction((Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
        JsonNode value = (JsonNode)((Tuple)result.iterator().next()).getObject(0);
        JSONSetCreateFunctionTest.assertNotNull((Object)value);
        JSONSetCreateFunctionTest.assertEquals((String)"Jane Doe", (String)value.at("/person/name").textValue());
    }

    @Test
    public void testCreateMapResolved() throws Exception {
        TupleEntry entry = new TupleEntry(new Fields((Comparable)((Object)"name"), String.class), Tuple.size((int)1));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"Jane Doe");
        JSONCreateFunction function = new JSONCreateFunction(new Fields(new Comparable[]{"result"}), Collections.singletonMap(new Fields((Comparable)Integer.valueOf(0), String.class), "/person/name"));
        TupleListCollector result = JSONSetCreateFunctionTest.invokeFunction((Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
        JsonNode value = (JsonNode)((Tuple)result.iterator().next()).getObject(0);
        JSONSetCreateFunctionTest.assertNotNull((Object)value);
        JSONSetCreateFunctionTest.assertEquals((String)"Jane Doe", (String)value.at("/person/name").textValue());
    }

    @Test
    public void testCreateResolvedArguments() throws Exception {
        TupleEntry entry = new TupleEntry(new Fields((Comparable)((Object)"name"), String.class), Tuple.size((int)1));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"Jane Doe");
        Fields fieldDeclaration = new Fields(new Comparable[]{"result"});
        JSONCreateFunction function = new JSONCreateFunction(fieldDeclaration);
        TupleListCollector result = JSONSetCreateFunctionTest.invokeFunction((Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
        JsonNode value = (JsonNode)((Tuple)result.iterator().next()).getObject(0);
        JSONSetCreateFunctionTest.assertNotNull((Object)value);
        JSONSetCreateFunctionTest.assertEquals((String)"Jane Doe", (String)value.at("/name").textValue());
    }

    @Test
    public void testCreateResolvedArgumentsWithRoot() throws Exception {
        TupleEntry entry = new TupleEntry(new Fields((Comparable)((Object)"name"), String.class), Tuple.size((int)1));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"Jane Doe");
        Fields fieldDeclaration = new Fields(new Comparable[]{"result"});
        JSONCreateFunction function = new JSONCreateFunction(fieldDeclaration, "/person");
        TupleListCollector result = JSONSetCreateFunctionTest.invokeFunction((Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
        JsonNode value = (JsonNode)((Tuple)result.iterator().next()).getObject(0);
        JSONSetCreateFunctionTest.assertNotNull((Object)value);
        JSONSetCreateFunctionTest.assertEquals((String)"Jane Doe", (String)value.at("/person/name").textValue());
    }

    @Test
    public void testCreatePredicate() throws Exception {
        TupleEntry entry = new TupleEntry(new Fields((Comparable)((Object)"first"), String.class).append(new Fields((Comparable)((Object)"last"), String.class)), Tuple.size((int)2));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"John");
        entry.setObject((Comparable)Integer.valueOf(1), null);
        JSONCreateFunction function = new JSONCreateFunction(new Fields(new Comparable[]{"result"}), Objects::nonNull);
        TupleListCollector result = JSONSetCreateFunctionTest.invokeFunction((Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
        JsonNode node = (JsonNode)((Tuple)result.iterator().next()).getObject(0);
        JSONSetCreateFunctionTest.assertNotNull((Object)node);
        JSONSetCreateFunctionTest.assertEquals((String)"John", (String)node.at("/first").textValue());
        JSONSetCreateFunctionTest.assertFalse((boolean)node.has("/last"));
    }
}

