/*
 * Decompiled with CFR 0.152.
 */
package cascading.nested.json.hadoop3;

import cascading.flow.FlowProcess;
import cascading.nested.json.JSONCoercibleType;
import cascading.scheme.SinkCall;
import cascading.scheme.SourceCall;
import cascading.scheme.hadoop.TextLine;
import cascading.tuple.Fields;
import cascading.tuple.TupleEntry;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;

public class JSONTextLine
extends TextLine {
    public static final Fields DEFAULT_FIELDS = new Fields(new Comparable[]{"json"}).applyTypes(new Type[]{JSONCoercibleType.TYPE});
    private ObjectMapper mapper = new ObjectMapper();

    public JSONTextLine() {
        this(DEFAULT_FIELDS);
    }

    public JSONTextLine(Fields fields) {
        this(fields, null, "UTF-8");
    }

    public JSONTextLine(Fields fields, String charsetName) {
        this(fields, null, charsetName);
    }

    public JSONTextLine(Fields fields, TextLine.Compress sinkCompression) {
        this(fields, sinkCompression, "UTF-8");
    }

    public JSONTextLine(Fields fields, TextLine.Compress sinkCompression, String charsetName) {
        this(null, fields, sinkCompression, charsetName);
    }

    public JSONTextLine(ObjectMapper mapper, Fields fields) {
        this(mapper, fields, null, "UTF-8");
    }

    public JSONTextLine(ObjectMapper mapper, Fields fields, String charsetName) {
        this(mapper, fields, null, charsetName);
    }

    public JSONTextLine(ObjectMapper mapper, Fields fields, TextLine.Compress sinkCompression) {
        this(mapper, fields, sinkCompression, "UTF-8");
    }

    public JSONTextLine(ObjectMapper mapper, Fields fields, TextLine.Compress sinkCompression, String charsetName) {
        super(sinkCompression);
        this.mapper.setConfig(this.mapper.getDeserializationConfig().with(DeserializationFeature.FAIL_ON_READING_DUP_TREE_KEY));
        if (mapper != null) {
            this.mapper = mapper;
        }
        if (fields == null) {
            throw new IllegalArgumentException("fields may not be null");
        }
        if (!fields.isDefined()) {
            throw new IllegalArgumentException("fields argument must declare a single field");
        }
        if (fields.size() != 1) {
            throw new IllegalArgumentException("may only declare a single source/sink field in the fields argument");
        }
        fields = fields.hasTypes() ? fields : fields.applyTypes(new Type[]{new JSONCoercibleType(this.mapper)});
        this.setSinkFields(fields);
        this.setSourceFields(fields);
        this.setCharsetName(charsetName);
    }

    protected void sourceHandleInput(SourceCall<Object[], RecordReader> sourceCall) throws IOException {
        TupleEntry result = sourceCall.getIncomingEntry();
        Object[] context = (Object[])sourceCall.getContext();
        Text text = (Text)context[1];
        JsonNode jsonNode = null;
        if (text.getLength() != 0) {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(text.getBytes(), 0, text.getLength());
            InputStreamReader reader = new InputStreamReader((InputStream)inputStream, (Charset)context[2]);
            jsonNode = this.mapper.readTree((Reader)reader);
        }
        result.setObject((Comparable)Integer.valueOf(0), jsonNode);
    }

    public void sink(FlowProcess<? extends Configuration> flowProcess, SinkCall<Object[], OutputCollector> sinkCall) throws IOException {
        Text text = (Text)((Object[])sinkCall.getContext())[0];
        Charset charset = (Charset)((Object[])sinkCall.getContext())[1];
        JsonNode jsonNode = (JsonNode)sinkCall.getOutgoingEntry().getTuple().getObject(0);
        if (jsonNode == null) {
            text.set("");
        } else {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream(1024);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)outputStream, charset);
            this.mapper.writeValue((Writer)writer, (Object)jsonNode);
            writer.close();
            text.set(outputStream.toByteArray());
        }
        ((OutputCollector)sinkCall.getOutput()).collect(null, (Object)text);
    }

    public String getExtension() {
        return "json";
    }
}

