/*
 * Decompiled with CFR 0.152.
 */
package cascading.nested.json;

import cascading.nested.json.JSONCoercibleType;
import cascading.nested.json.JSONData;
import cascading.tuple.coerce.Coercions;
import cascading.tuple.type.CoercibleType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.lang.reflect.Type;
import java.time.Instant;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class JSONTypeTest {
    @Test
    public void stringLiteralCoercions() {
        this.testCoercion("\"Foo\"", JsonNodeType.STRING, "Foo", String.class);
        this.testCoercion("Foo", JsonNodeType.STRING, "Foo", String.class);
        this.testCoercion("100", JsonNodeType.NUMBER, 100, Integer.class);
        this.testCoercion(100, JsonNodeType.NUMBER, 100, Integer.class);
        this.testCoercion("Foo", JsonNodeType.STRING, JSONCoercibleType.TYPE.canonical((Object)"Foo"), JsonNode.class);
    }

    private void testCoercion(Object value, JsonNodeType nodeType, Object resultValue, Class resultType) {
        JsonNode canonical = JSONCoercibleType.TYPE.canonical(value);
        Assert.assertEquals((Object)nodeType, (Object)canonical.getNodeType());
        Assert.assertEquals((Object)resultValue, (Object)JSONCoercibleType.TYPE.coerce((Object)canonical, (Type)resultType));
    }

    @Test
    public void objectCoercions() {
        for (String value : JSONData.objects) {
            this.testContainerCoercion(value, JsonNodeType.OBJECT, String.class);
        }
    }

    @Test
    public void arrayCoercions() {
        for (String value : JSONData.arrays) {
            this.testContainerCoercion(value, JsonNodeType.ARRAY, String.class);
        }
    }

    @Test
    public void mapCoercions() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("name", "John Doe");
        map.put("list", Arrays.asList("John", "Jane"));
        JsonNode canonical = JSONCoercibleType.TYPE.canonical(map);
        Assert.assertEquals((Object)JsonNodeType.OBJECT, (Object)canonical.getNodeType());
        Assert.assertEquals(map, (Object)JSONCoercibleType.TYPE.coerce((Object)canonical, Map.class));
    }

    @Test
    public void listCoercions() {
        LinkedList<Object> list = new LinkedList<Object>();
        list.add("John Doe");
        list.add(Arrays.asList("John", "Jane"));
        JsonNode canonical = JSONCoercibleType.TYPE.canonical(list);
        Assert.assertEquals((Object)JsonNodeType.ARRAY, (Object)canonical.getNodeType());
        Assert.assertEquals(list, (Object)JSONCoercibleType.TYPE.coerce((Object)canonical, List.class));
    }

    @Test
    public void pojoCoercions() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new JavaTimeModule());
        JSONCoercibleType type = new JSONCoercibleType(mapper);
        Instant instant = Instant.ofEpochSecond(1525456424L, 337000000L);
        JsonNode canonical = type.canonical((Object)instant);
        String coerce = (String)type.coerce((Object)canonical, String.class);
        Assert.assertEquals((Object)"1525456424.337000000", (Object)coerce);
    }

    @Test
    public void pojoCoercionsReversed() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new JavaTimeModule());
        JSONCoercibleType type = new JSONCoercibleType(mapper);
        Instant instant = Instant.ofEpochSecond(1525456424L, 337000000L);
        JsonNode canonical = type.canonical((Object)instant);
        Instant coerce = (Instant)type.coerce((Object)canonical, Instant.class);
        Assert.assertEquals((Object)instant, (Object)coerce);
    }

    private void testContainerCoercion(String value, JsonNodeType nodeType, Class resultType) {
        JsonNode canonical = JSONCoercibleType.TYPE.canonical((Object)value);
        Assert.assertEquals((Object)nodeType, (Object)canonical.getNodeType());
        Assert.assertEquals((Object)value.replaceAll("\\s", ""), (Object)JSONCoercibleType.TYPE.coerce((Object)canonical, (Type)resultType));
    }

    @Test
    public void stringCoercions() {
        for (String value : JSONData.objects) {
            this.testContainerStringCoercion(value, JsonNodeType.OBJECT, String.class);
        }
    }

    private void testContainerStringCoercion(String value, JsonNodeType nodeType, Class resultType) {
        JsonNode canonical = (JsonNode)Coercions.coerce((CoercibleType)Coercions.STRING, (Object)value, (Type)JSONCoercibleType.TYPE);
        Assert.assertEquals((Object)nodeType, (Object)canonical.getNodeType());
        Assert.assertEquals((Object)value.replaceAll("\\s", ""), (Object)JSONCoercibleType.TYPE.coerce((Object)canonical, (Type)resultType));
    }
}

