/*
 * Decompiled with CFR 0.152.
 */
package cascading.nested.json;

import cascading.CascadingTestCase;
import cascading.nested.core.CopySpec;
import cascading.nested.json.JSONCoercibleType;
import cascading.nested.json.JSONCopyAsFunction;
import cascading.nested.json.JSONCopyIntoFunction;
import cascading.nested.json.filter.JSONBooleanPointerFilter;
import cascading.nested.json.filter.JSONStringPointerFilter;
import cascading.nested.json.transform.JSONPrimitiveTransforms;
import cascading.nested.json.transform.JSONSetTextTransform;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.TupleListCollector;
import com.fasterxml.jackson.databind.node.FloatNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.lang.reflect.Type;
import java.util.function.Function;
import java.util.function.Predicate;
import org.junit.Test;

public class JSONCopyAsFunctionTest
extends CascadingTestCase {
    @Test
    public void testCopyAs() throws Exception {
        TupleEntry entry = new TupleEntry(new Fields((Comparable)((Object)"json"), (Type)JSONCoercibleType.TYPE), Tuple.size((int)1));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"{\"person\":{\"name\":\"John Doe\",\"firstName\":\"John\",\"lastName\":\"Doe\",\"age\":50,\"human\":true,\"city\":\"Houston\",\"ssn\":\"123-45-6789\",\"measure\": { \"value\":100 },\"measures\":[ { \"value\":1000 }, { \"value\":2000 } ],\"measured\":[ 1000, 2000 ],\"children\":[\"Jane\",\"June\",\"Josh\"],\"arrays\":[[\"Jane1\",\"June1\",\"Josh1\"],[\"Jane2\",\"June2\",\"Josh2\"]],\"zero\": { \"zeroValue\":0 }}}");
        CopySpec copySpec = (CopySpec)new CopySpec().from("/person");
        JSONCopyAsFunction function = new JSONCopyAsFunction(new Fields(new Comparable[]{"result"}), new CopySpec[]{copySpec});
        TupleListCollector result = JSONCopyAsFunctionTest.invokeFunction((cascading.operation.Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
        Object value = ((Tuple)result.iterator().next()).getObject(0);
        JSONCopyAsFunctionTest.assertNotNull((Object)value);
        JSONCopyAsFunctionTest.assertEquals((String)"John Doe", (String)((ObjectNode)value).get("name").textValue());
        JSONCopyAsFunctionTest.assertEquals((int)50, (int)((ObjectNode)value).get("age").intValue());
        JSONCopyAsFunctionTest.assertEquals((String)"123-45-6789", (String)((ObjectNode)value).get("ssn").textValue());
    }

    @Test
    public void testCopyAsPredicate() throws Exception {
        TupleEntry entry = new TupleEntry(new Fields((Comparable)((Object)"json"), (Type)JSONCoercibleType.TYPE), Tuple.size((int)1));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"{\"person\":{\"name\":\"John Doe\",\"firstName\":\"John\",\"lastName\":\"Doe\",\"age\":50,\"human\":true,\"city\":\"Houston\",\"ssn\":\"123-45-6789\",\"measure\": { \"value\":100 },\"measures\":[ { \"value\":1000 }, { \"value\":2000 } ],\"measured\":[ 1000, 2000 ],\"children\":[\"Jane\",\"June\",\"Josh\"],\"arrays\":[[\"Jane1\",\"June1\",\"Josh1\"],[\"Jane2\",\"June2\",\"Josh2\"]],\"zero\": { \"zeroValue\":0 }}}");
        CopySpec copySpec = (CopySpec)new CopySpec().from("/person", (Predicate)new JSONStringPointerFilter("/name", "John Doe"));
        JSONCopyAsFunction function = new JSONCopyAsFunction(new Fields(new Comparable[]{"result"}), new CopySpec[]{copySpec});
        TupleListCollector result = JSONCopyAsFunctionTest.invokeFunction((cascading.operation.Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
        Object value = ((Tuple)result.iterator().next()).getObject(0);
        JSONCopyAsFunctionTest.assertNotNull((Object)value);
        JSONCopyAsFunctionTest.assertEquals((String)"John Doe", (String)((ObjectNode)value).get("name").textValue());
        JSONCopyAsFunctionTest.assertEquals((int)50, (int)((ObjectNode)value).get("age").intValue());
        JSONCopyAsFunctionTest.assertEquals((String)"123-45-6789", (String)((ObjectNode)value).get("ssn").textValue());
    }

    @Test
    public void testCopyAsPredicateNegate() throws Exception {
        TupleEntry entry = new TupleEntry(new Fields((Comparable)((Object)"json"), (Type)JSONCoercibleType.TYPE), Tuple.size((int)1));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"{\"person\":{\"name\":\"John Doe\",\"firstName\":\"John\",\"lastName\":\"Doe\",\"age\":50,\"human\":true,\"city\":\"Houston\",\"ssn\":\"123-45-6789\",\"measure\": { \"value\":100 },\"measures\":[ { \"value\":1000 }, { \"value\":2000 } ],\"measured\":[ 1000, 2000 ],\"children\":[\"Jane\",\"June\",\"Josh\"],\"arrays\":[[\"Jane1\",\"June1\",\"Josh1\"],[\"Jane2\",\"June2\",\"Josh2\"]],\"zero\": { \"zeroValue\":0 }}}");
        CopySpec copySpec = (CopySpec)new CopySpec().from("/person", new JSONStringPointerFilter("/name", "John Doe").negate());
        JSONCopyAsFunction function = new JSONCopyAsFunction(new Fields(new Comparable[]{"result"}), new CopySpec[]{copySpec});
        TupleListCollector result = JSONCopyAsFunctionTest.invokeFunction((cascading.operation.Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
        Object value = ((Tuple)result.iterator().next()).getObject(0);
        JSONCopyAsFunctionTest.assertNotNull((Object)value);
        JSONCopyAsFunctionTest.assertNull((Object)((ObjectNode)value).get("name"));
        JSONCopyAsFunctionTest.assertNull((Object)((ObjectNode)value).get("age"));
        JSONCopyAsFunctionTest.assertNull((Object)((ObjectNode)value).get("ssn"));
    }

    @Test
    public void testCopyAsPredicateBoolean() throws Exception {
        Fields fields = new Fields((Comparable)((Object)"json"), (Type)JSONCoercibleType.TYPE).append(new Fields((Comparable)((Object)"result"), (Type)JSONCoercibleType.TYPE));
        TupleEntry entry = new TupleEntry(fields, Tuple.size((int)2));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"{\"person\":{\"name\":\"John Doe\",\"firstName\":\"John\",\"lastName\":\"Doe\",\"age\":50,\"human\":true,\"city\":\"Houston\",\"ssn\":\"123-45-6789\",\"measure\": { \"value\":100 },\"measures\":[ { \"value\":1000 }, { \"value\":2000 } ],\"measured\":[ 1000, 2000 ],\"children\":[\"Jane\",\"June\",\"Josh\"],\"arrays\":[[\"Jane1\",\"June1\",\"Josh1\"],[\"Jane2\",\"June2\",\"Josh2\"]],\"zero\": { \"zeroValue\":0 }}}");
        entry.setObject((Comparable)Integer.valueOf(1), (Object)"{ \"existing\":\"value\" }");
        CopySpec copySpec = (CopySpec)new CopySpec().from("/person", (Predicate)new JSONBooleanPointerFilter("/human", true));
        JSONCopyIntoFunction function = new JSONCopyIntoFunction(new Fields(new Comparable[]{"result"}), new CopySpec[]{copySpec});
        TupleListCollector result = JSONCopyAsFunctionTest.invokeFunction((cascading.operation.Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
        Object value = ((Tuple)result.iterator().next()).getObject(0);
        JSONCopyAsFunctionTest.assertNotNull((Object)value);
        JSONCopyAsFunctionTest.assertEquals((String)"value", (String)((ObjectNode)value).get("existing").textValue());
        JSONCopyAsFunctionTest.assertEquals((String)"John Doe", (String)((ObjectNode)value).get("name").textValue());
        JSONCopyAsFunctionTest.assertEquals((boolean)true, (boolean)((ObjectNode)value).get("human").booleanValue());
        JSONCopyAsFunctionTest.assertEquals((int)50, (int)((ObjectNode)value).get("age").intValue());
        JSONCopyAsFunctionTest.assertEquals((String)"123-45-6789", (String)((ObjectNode)value).get("ssn").textValue());
    }

    @Test
    public void testCopyAsPredicateBooleanNegate() throws Exception {
        Fields fields = new Fields((Comparable)((Object)"json"), (Type)JSONCoercibleType.TYPE).append(new Fields((Comparable)((Object)"result"), (Type)JSONCoercibleType.TYPE));
        TupleEntry entry = new TupleEntry(fields, Tuple.size((int)2));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"{\"person\":{\"name\":\"John Doe\",\"firstName\":\"John\",\"lastName\":\"Doe\",\"age\":50,\"human\":true,\"city\":\"Houston\",\"ssn\":\"123-45-6789\",\"measure\": { \"value\":100 },\"measures\":[ { \"value\":1000 }, { \"value\":2000 } ],\"measured\":[ 1000, 2000 ],\"children\":[\"Jane\",\"June\",\"Josh\"],\"arrays\":[[\"Jane1\",\"June1\",\"Josh1\"],[\"Jane2\",\"June2\",\"Josh2\"]],\"zero\": { \"zeroValue\":0 }}}");
        entry.setObject((Comparable)Integer.valueOf(1), (Object)"{ \"existing\":\"value\" }");
        CopySpec copySpec = (CopySpec)new CopySpec().from("/person", new JSONBooleanPointerFilter("/human", true).negate());
        JSONCopyIntoFunction function = new JSONCopyIntoFunction(new Fields(new Comparable[]{"result"}), new CopySpec[]{copySpec});
        TupleListCollector result = JSONCopyAsFunctionTest.invokeFunction((cascading.operation.Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
        Object value = ((Tuple)result.iterator().next()).getObject(0);
        JSONCopyAsFunctionTest.assertNotNull((Object)value);
        JSONCopyAsFunctionTest.assertEquals((String)"value", (String)((ObjectNode)value).get("existing").textValue());
        JSONCopyAsFunctionTest.assertNull((Object)((ObjectNode)value).get("name"));
        JSONCopyAsFunctionTest.assertNull((Object)((ObjectNode)value).get("human"));
        JSONCopyAsFunctionTest.assertNull((Object)((ObjectNode)value).get("age"));
        JSONCopyAsFunctionTest.assertNull((Object)((ObjectNode)value).get("ssn"));
    }

    @Test
    public void testCopyAsArrayPredicate() throws Exception {
        TupleEntry entry = new TupleEntry(new Fields((Comparable)((Object)"json"), (Type)JSONCoercibleType.TYPE), Tuple.size((int)1));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"{\"people\":[ {\"person\":{\"name\":\"John Doe\",\"firstName\":\"John\",\"lastName\":\"Doe\",\"age\":50,\"female\":false,\"city\":\"Houston\",\"ssn\":\"123-45-6789\"}},{\"person\":{\"name\":\"Jane Doe\",\"firstName\":\"Jane\",\"lastName\":\"Doe\",\"age\":49,\"female\":true,\"city\":\"Houston\",\"ssn\":\"123-45-6789\"}}]}");
        CopySpec copySpec = (CopySpec)new CopySpec().from("/people/*", (Predicate)new JSONStringPointerFilter("/person/name", "John Doe"));
        JSONCopyAsFunction function = new JSONCopyAsFunction(new Fields(new Comparable[]{"result"}), new CopySpec[]{copySpec});
        TupleListCollector result = JSONCopyAsFunctionTest.invokeFunction((cascading.operation.Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
        Object value = ((Tuple)result.iterator().next()).getObject(0);
        JSONCopyAsFunctionTest.assertNotNull((Object)value);
        JSONCopyAsFunctionTest.assertEquals((String)"John Doe", (String)((ObjectNode)value).get("person").get("name").textValue());
        JSONCopyAsFunctionTest.assertEquals((int)50, (int)((ObjectNode)value).get("person").get("age").intValue());
        JSONCopyAsFunctionTest.assertEquals((String)"123-45-6789", (String)((ObjectNode)value).get("person").get("ssn").textValue());
    }

    @Test
    public void testCopyAsArrayPredicateNegate() throws Exception {
        TupleEntry entry = new TupleEntry(new Fields((Comparable)((Object)"json"), (Type)JSONCoercibleType.TYPE), Tuple.size((int)1));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"{\"people\":[ {\"person\":{\"name\":\"John Doe\",\"firstName\":\"John\",\"lastName\":\"Doe\",\"age\":50,\"female\":false,\"city\":\"Houston\",\"ssn\":\"123-45-6789\"}},{\"person\":{\"name\":\"Jane Doe\",\"firstName\":\"Jane\",\"lastName\":\"Doe\",\"age\":49,\"female\":true,\"city\":\"Houston\",\"ssn\":\"123-45-6789\"}}]}");
        CopySpec copySpec = (CopySpec)new CopySpec().from("/people/*", new JSONStringPointerFilter("/person/name", "John Doe").negate());
        JSONCopyAsFunction function = new JSONCopyAsFunction(new Fields(new Comparable[]{"result"}), new CopySpec[]{copySpec});
        TupleListCollector result = JSONCopyAsFunctionTest.invokeFunction((cascading.operation.Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
        Object value = ((Tuple)result.iterator().next()).getObject(0);
        JSONCopyAsFunctionTest.assertNotNull((Object)value);
        JSONCopyAsFunctionTest.assertEquals((String)"Jane Doe", (String)((ObjectNode)value).get("person").get("name").textValue());
        JSONCopyAsFunctionTest.assertEquals((int)49, (int)((ObjectNode)value).get("person").get("age").intValue());
        JSONCopyAsFunctionTest.assertEquals((String)"123-45-6789", (String)((ObjectNode)value).get("person").get("ssn").textValue());
    }

    @Test
    public void testCopyAsInto() throws Exception {
        TupleEntry entry = new TupleEntry(new Fields((Comparable)((Object)"json"), (Type)JSONCoercibleType.TYPE), Tuple.size((int)1));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"{\"people\":[ {\"person\":{\"name\":\"John Doe\",\"firstName\":\"John\",\"lastName\":\"Doe\",\"age\":50,\"female\":false,\"city\":\"Houston\",\"ssn\":\"123-45-6789\"}},{\"person\":{\"name\":\"Jane Doe\",\"firstName\":\"Jane\",\"lastName\":\"Doe\",\"age\":49,\"female\":true,\"city\":\"Houston\",\"ssn\":\"123-45-6789\"}}]}");
        CopySpec copySpec = (CopySpec)new CopySpec("/people").from("/people/0");
        JSONCopyAsFunction function = new JSONCopyAsFunction(new Fields(new Comparable[]{"result"}), new CopySpec[]{copySpec});
        TupleListCollector result = JSONCopyAsFunctionTest.invokeFunction((cascading.operation.Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
        Object value = ((Tuple)result.iterator().next()).getObject(0);
        JSONCopyAsFunctionTest.assertNotNull((Object)value);
        value = ((ObjectNode)value).get("people").get("person");
        JSONCopyAsFunctionTest.assertEquals((String)"John Doe", (String)((ObjectNode)value).get("name").textValue());
        JSONCopyAsFunctionTest.assertEquals((int)50, (int)((ObjectNode)value).get("age").intValue());
        JSONCopyAsFunctionTest.assertEquals((String)"123-45-6789", (String)((ObjectNode)value).get("ssn").textValue());
    }

    @Test
    public void testCopyIncludeFrom() throws Exception {
        TupleEntry entry = new TupleEntry(new Fields((Comparable)((Object)"json"), (Type)JSONCoercibleType.TYPE), Tuple.size((int)1));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"{\"person\":{\"name\":\"John Doe\",\"firstName\":\"John\",\"lastName\":\"Doe\",\"age\":50,\"human\":true,\"city\":\"Houston\",\"ssn\":\"123-45-6789\",\"measure\": { \"value\":100 },\"measures\":[ { \"value\":1000 }, { \"value\":2000 } ],\"measured\":[ 1000, 2000 ],\"children\":[\"Jane\",\"June\",\"Josh\"],\"arrays\":[[\"Jane1\",\"June1\",\"Josh1\"],[\"Jane2\",\"June2\",\"Josh2\"]],\"zero\": { \"zeroValue\":0 }}}");
        CopySpec copySpec = (CopySpec)((CopySpec)new CopySpec().fromInclude("/person", new String[]{"/firstName"})).fromInclude("/person", new String[]{"/age"});
        JSONCopyAsFunction function = new JSONCopyAsFunction(new Fields(new Comparable[]{"result"}), new CopySpec[]{copySpec});
        TupleListCollector result = JSONCopyAsFunctionTest.invokeFunction((cascading.operation.Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
        Object value = ((Tuple)result.iterator().next()).getObject(0);
        JSONCopyAsFunctionTest.assertNotNull((Object)value);
        JSONCopyAsFunctionTest.assertEquals((String)"John", (String)((ObjectNode)value).get("firstName").textValue());
        JSONCopyAsFunctionTest.assertEquals((int)50, (int)((ObjectNode)value).get("age").intValue());
        JSONCopyAsFunctionTest.assertEquals(null, (Object)((ObjectNode)value).get("ssn"));
    }

    @Test
    public void testCopyIncludeFromPredicate() throws Exception {
        TupleEntry entry = new TupleEntry(new Fields((Comparable)((Object)"json"), (Type)JSONCoercibleType.TYPE), Tuple.size((int)1));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"{\"person\":{\"name\":\"John Doe\",\"firstName\":\"John\",\"lastName\":\"Doe\",\"age\":50,\"human\":true,\"city\":\"Houston\",\"ssn\":\"123-45-6789\",\"measure\": { \"value\":100 },\"measures\":[ { \"value\":1000 }, { \"value\":2000 } ],\"measured\":[ 1000, 2000 ],\"children\":[\"Jane\",\"June\",\"Josh\"],\"arrays\":[[\"Jane1\",\"June1\",\"Josh1\"],[\"Jane2\",\"June2\",\"Josh2\"]],\"zero\": { \"zeroValue\":0 }}}");
        CopySpec copySpec = (CopySpec)((CopySpec)new CopySpec().fromInclude("/person", "/firstName", new JSONStringPointerFilter("John").negate())).fromInclude("/person", new String[]{"/age"});
        JSONCopyAsFunction function = new JSONCopyAsFunction(new Fields(new Comparable[]{"result"}), new CopySpec[]{copySpec});
        TupleListCollector result = JSONCopyAsFunctionTest.invokeFunction((cascading.operation.Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
        Object value = ((Tuple)result.iterator().next()).getObject(0);
        JSONCopyAsFunctionTest.assertNotNull((Object)value);
        JSONCopyAsFunctionTest.assertNull((Object)((ObjectNode)value).get("firstName"));
        JSONCopyAsFunctionTest.assertEquals((int)50, (int)((ObjectNode)value).get("age").intValue());
        JSONCopyAsFunctionTest.assertEquals(null, (Object)((ObjectNode)value).get("ssn"));
    }

    @Test
    public void testCopyInclude() throws Exception {
        TupleEntry entry = new TupleEntry(new Fields((Comparable)((Object)"json"), (Type)JSONCoercibleType.TYPE), Tuple.size((int)1));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"{\"person\":{\"name\":\"John Doe\",\"firstName\":\"John\",\"lastName\":\"Doe\",\"age\":50,\"human\":true,\"city\":\"Houston\",\"ssn\":\"123-45-6789\",\"measure\": { \"value\":100 },\"measures\":[ { \"value\":1000 }, { \"value\":2000 } ],\"measured\":[ 1000, 2000 ],\"children\":[\"Jane\",\"June\",\"Josh\"],\"arrays\":[[\"Jane1\",\"June1\",\"Josh1\"],[\"Jane2\",\"June2\",\"Josh2\"]],\"zero\": { \"zeroValue\":0 }}}");
        CopySpec copySpec = (CopySpec)((CopySpec)new CopySpec().include(new String[]{"/person/firstName"})).include(new String[]{"/person/age"});
        JSONCopyAsFunction function = new JSONCopyAsFunction(new Fields(new Comparable[]{"result"}), new CopySpec[]{copySpec});
        TupleListCollector result = JSONCopyAsFunctionTest.invokeFunction((cascading.operation.Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
        Object value = ((Tuple)result.iterator().next()).getObject(0);
        JSONCopyAsFunctionTest.assertNotNull((Object)value);
        JSONCopyAsFunctionTest.assertEquals((String)"John", (String)((ObjectNode)value).findPath("firstName").textValue());
        JSONCopyAsFunctionTest.assertEquals((int)50, (int)((ObjectNode)value).findPath("age").intValue());
        JSONCopyAsFunctionTest.assertEquals(null, (Object)((ObjectNode)value).findValue("ssn"));
    }

    @Test
    public void testCopyIncludeWild() throws Exception {
        TupleEntry entry = new TupleEntry(new Fields((Comparable)((Object)"json"), (Type)JSONCoercibleType.TYPE), Tuple.size((int)1));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"{\"person\":{\"name\":\"John Doe\",\"firstName\":\"John\",\"lastName\":\"Doe\",\"age\":50,\"human\":true,\"city\":\"Houston\",\"ssn\":\"123-45-6789\",\"measure\": { \"value\":100 },\"measures\":[ { \"value\":1000 }, { \"value\":2000 } ],\"measured\":[ 1000, 2000 ],\"children\":[\"Jane\",\"June\",\"Josh\"],\"arrays\":[[\"Jane1\",\"June1\",\"Josh1\"],[\"Jane2\",\"June2\",\"Josh2\"]],\"zero\": { \"zeroValue\":0 }}}");
        CopySpec copySpec = (CopySpec)((CopySpec)new CopySpec().include(new String[]{"/person/firstName"})).include(new String[]{"/*/age"});
        JSONCopyAsFunction function = new JSONCopyAsFunction(new Fields(new Comparable[]{"result"}), new CopySpec[]{copySpec});
        TupleListCollector result = JSONCopyAsFunctionTest.invokeFunction((cascading.operation.Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
        Object value = ((Tuple)result.iterator().next()).getObject(0);
        JSONCopyAsFunctionTest.assertNotNull((Object)value);
        JSONCopyAsFunctionTest.assertEquals((String)"John", (String)((ObjectNode)value).findPath("firstName").textValue());
        JSONCopyAsFunctionTest.assertEquals((int)50, (int)((ObjectNode)value).findPath("age").intValue());
        JSONCopyAsFunctionTest.assertEquals(null, (Object)((ObjectNode)value).findValue("ssn"));
    }

    @Test
    public void testCopyIncludeDescent() throws Exception {
        TupleEntry entry = new TupleEntry(new Fields((Comparable)((Object)"json"), (Type)JSONCoercibleType.TYPE), Tuple.size((int)1));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"{\"person\":{\"name\":\"John Doe\",\"firstName\":\"John\",\"lastName\":\"Doe\",\"age\":50,\"human\":true,\"city\":\"Houston\",\"ssn\":\"123-45-6789\",\"measure\": { \"value\":100 },\"measures\":[ { \"value\":1000 }, { \"value\":2000 } ],\"measured\":[ 1000, 2000 ],\"children\":[\"Jane\",\"June\",\"Josh\"],\"arrays\":[[\"Jane1\",\"June1\",\"Josh1\"],[\"Jane2\",\"June2\",\"Josh2\"]],\"zero\": { \"zeroValue\":0 }}}");
        CopySpec copySpec = (CopySpec)((CopySpec)new CopySpec().include(new String[]{"/person/firstName"})).include(new String[]{"/**/age"});
        JSONCopyAsFunction function = new JSONCopyAsFunction(new Fields(new Comparable[]{"result"}), new CopySpec[]{copySpec});
        TupleListCollector result = JSONCopyAsFunctionTest.invokeFunction((cascading.operation.Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
        Object value = ((Tuple)result.iterator().next()).getObject(0);
        JSONCopyAsFunctionTest.assertNotNull((Object)value);
        JSONCopyAsFunctionTest.assertEquals((String)"John", (String)((ObjectNode)value).findPath("firstName").textValue());
        JSONCopyAsFunctionTest.assertEquals((int)50, (int)((ObjectNode)value).findPath("age").intValue());
        JSONCopyAsFunctionTest.assertEquals(null, (Object)((ObjectNode)value).findValue("ssn"));
    }

    @Test
    public void testCopyIncludeFrom2() throws Exception {
        TupleEntry entry = new TupleEntry(new Fields((Comparable)((Object)"json"), (Type)JSONCoercibleType.TYPE), Tuple.size((int)1));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"{\"person\":{\"name\":\"John Doe\",\"firstName\":\"John\",\"lastName\":\"Doe\",\"age\":50,\"human\":true,\"city\":\"Houston\",\"ssn\":\"123-45-6789\",\"measure\": { \"value\":100 },\"measures\":[ { \"value\":1000 }, { \"value\":2000 } ],\"measured\":[ 1000, 2000 ],\"children\":[\"Jane\",\"June\",\"Josh\"],\"arrays\":[[\"Jane1\",\"June1\",\"Josh1\"],[\"Jane2\",\"June2\",\"Josh2\"]],\"zero\": { \"zeroValue\":0 }}}");
        CopySpec copySpec = (CopySpec)new CopySpec().fromInclude("/person", new String[]{"/firstName", "/age"});
        JSONCopyAsFunction function = new JSONCopyAsFunction(new Fields(new Comparable[]{"result"}), new CopySpec[]{copySpec});
        TupleListCollector result = JSONCopyAsFunctionTest.invokeFunction((cascading.operation.Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
        Object value = ((Tuple)result.iterator().next()).getObject(0);
        JSONCopyAsFunctionTest.assertNotNull((Object)value);
        JSONCopyAsFunctionTest.assertEquals((String)"John", (String)((ObjectNode)value).get("firstName").textValue());
        JSONCopyAsFunctionTest.assertEquals((int)50, (int)((ObjectNode)value).get("age").intValue());
        JSONCopyAsFunctionTest.assertEquals(null, (Object)((ObjectNode)value).get("ssn"));
    }

    @Test
    public void testCopyExcludeFrom() throws Exception {
        TupleEntry entry = new TupleEntry(new Fields((Comparable)((Object)"json"), (Type)JSONCoercibleType.TYPE), Tuple.size((int)1));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"{\"person\":{\"name\":\"John Doe\",\"firstName\":\"John\",\"lastName\":\"Doe\",\"age\":50,\"human\":true,\"city\":\"Houston\",\"ssn\":\"123-45-6789\",\"measure\": { \"value\":100 },\"measures\":[ { \"value\":1000 }, { \"value\":2000 } ],\"measured\":[ 1000, 2000 ],\"children\":[\"Jane\",\"June\",\"Josh\"],\"arrays\":[[\"Jane1\",\"June1\",\"Josh1\"],[\"Jane2\",\"June2\",\"Josh2\"]],\"zero\": { \"zeroValue\":0 }}}");
        CopySpec copySpec = (CopySpec)new CopySpec().fromExclude("/person", new String[]{"/ssn", "/children"});
        JSONCopyAsFunction function = new JSONCopyAsFunction(new Fields(new Comparable[]{"result"}), new CopySpec[]{copySpec});
        TupleListCollector result = JSONCopyAsFunctionTest.invokeFunction((cascading.operation.Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
        Object value = ((Tuple)result.iterator().next()).getObject(0);
        JSONCopyAsFunctionTest.assertNotNull((Object)value);
        JSONCopyAsFunctionTest.assertEquals((String)"John Doe", (String)((ObjectNode)value).get("name").textValue());
        JSONCopyAsFunctionTest.assertEquals((int)50, (int)((ObjectNode)value).get("age").intValue());
        JSONCopyAsFunctionTest.assertEquals(null, (Object)((ObjectNode)value).get("ssn"));
        JSONCopyAsFunctionTest.assertEquals(null, (Object)((ObjectNode)value).get("children"));
    }

    @Test
    public void testCopyExclude() throws Exception {
        TupleEntry entry = new TupleEntry(new Fields((Comparable)((Object)"json"), (Type)JSONCoercibleType.TYPE), Tuple.size((int)1));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"{\"person\":{\"name\":\"John Doe\",\"firstName\":\"John\",\"lastName\":\"Doe\",\"age\":50,\"human\":true,\"city\":\"Houston\",\"ssn\":\"123-45-6789\",\"measure\": { \"value\":100 },\"measures\":[ { \"value\":1000 }, { \"value\":2000 } ],\"measured\":[ 1000, 2000 ],\"children\":[\"Jane\",\"June\",\"Josh\"],\"arrays\":[[\"Jane1\",\"June1\",\"Josh1\"],[\"Jane2\",\"June2\",\"Josh2\"]],\"zero\": { \"zeroValue\":0 }}}");
        CopySpec copySpec = (CopySpec)new CopySpec().exclude(new String[]{"/person/ssn", "/person/children"});
        JSONCopyAsFunction function = new JSONCopyAsFunction(new Fields(new Comparable[]{"result"}), new CopySpec[]{copySpec});
        TupleListCollector result = JSONCopyAsFunctionTest.invokeFunction((cascading.operation.Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
        Object value = ((Tuple)result.iterator().next()).getObject(0);
        JSONCopyAsFunctionTest.assertNotNull((Object)value);
        JSONCopyAsFunctionTest.assertEquals((String)"John Doe", (String)((ObjectNode)value).findPath("name").textValue());
        JSONCopyAsFunctionTest.assertEquals((int)50, (int)((ObjectNode)value).findPath("age").intValue());
        JSONCopyAsFunctionTest.assertEquals(null, (Object)((ObjectNode)value).findValue("ssn"));
        JSONCopyAsFunctionTest.assertEquals(null, (Object)((ObjectNode)value).findValue("children"));
    }

    @Test
    public void testCopyExcludeDescent() throws Exception {
        TupleEntry entry = new TupleEntry(new Fields((Comparable)((Object)"json"), (Type)JSONCoercibleType.TYPE), Tuple.size((int)1));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"{\"person\":{\"name\":\"John Doe\",\"firstName\":\"John\",\"lastName\":\"Doe\",\"age\":50,\"human\":true,\"city\":\"Houston\",\"ssn\":\"123-45-6789\",\"measure\": { \"value\":100 },\"measures\":[ { \"value\":1000 }, { \"value\":2000 } ],\"measured\":[ 1000, 2000 ],\"children\":[\"Jane\",\"June\",\"Josh\"],\"arrays\":[[\"Jane1\",\"June1\",\"Josh1\"],[\"Jane2\",\"June2\",\"Josh2\"]],\"zero\": { \"zeroValue\":0 }}}");
        CopySpec copySpec = (CopySpec)new CopySpec().exclude(new String[]{"/**/value"});
        JSONCopyAsFunction function = new JSONCopyAsFunction(new Fields(new Comparable[]{"result"}), new CopySpec[]{copySpec});
        TupleListCollector result = JSONCopyAsFunctionTest.invokeFunction((cascading.operation.Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
        Object value = ((Tuple)result.iterator().next()).getObject(0);
        JSONCopyAsFunctionTest.assertNotNull((Object)value);
        JSONCopyAsFunctionTest.assertNotNull((Object)((ObjectNode)value).get("person"));
        value = ((ObjectNode)value).get("person");
        JSONCopyAsFunctionTest.assertNull((Object)((ObjectNode)value).get("measure").get("value"));
    }

    @Test
    public void testCoerce() throws Exception {
        TupleEntry entry = new TupleEntry(new Fields((Comparable)((Object)"json"), (Type)JSONCoercibleType.TYPE), Tuple.size((int)1));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"{\"person\":{\"name\":\"John Doe\",\"firstName\":\"John\",\"lastName\":\"Doe\",\"age\":50,\"human\":true,\"city\":\"Houston\",\"ssn\":\"123-45-6789\",\"measure\": { \"value\":100 },\"measures\":[ { \"value\":1000 }, { \"value\":2000 } ],\"measured\":[ 1000, 2000 ],\"children\":[\"Jane\",\"June\",\"Josh\"],\"arrays\":[[\"Jane1\",\"June1\",\"Josh1\"],[\"Jane2\",\"June2\",\"Josh2\"]],\"zero\": { \"zeroValue\":0 }}}");
        CopySpec copySpec = (CopySpec)new CopySpec().fromTransform("/person/measure", "/value", (Function)JSONPrimitiveTransforms.TO_FLOAT);
        JSONCopyAsFunction function = new JSONCopyAsFunction(new Fields(new Comparable[]{"result"}), new CopySpec[]{copySpec});
        TupleListCollector result = JSONCopyAsFunctionTest.invokeFunction((cascading.operation.Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
        Object value = ((Tuple)result.iterator().next()).getObject(0);
        JSONCopyAsFunctionTest.assertNotNull((Object)value);
        JSONCopyAsFunctionTest.assertEquals((Object)JsonNodeType.NUMBER, (Object)((ObjectNode)value).get("value").getNodeType());
        JSONCopyAsFunctionTest.assertEquals(FloatNode.class, ((ObjectNode)value).get("value").getClass());
        JSONCopyAsFunctionTest.assertEquals((Object)Float.valueOf(100.0f), (Object)Float.valueOf(((ObjectNode)value).get("value").floatValue()));
    }

    @Test
    public void testCoerceZero() throws Exception {
        TupleEntry entry = new TupleEntry(new Fields((Comparable)((Object)"json"), (Type)JSONCoercibleType.TYPE), Tuple.size((int)1));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"{\"person\":{\"name\":\"John Doe\",\"firstName\":\"John\",\"lastName\":\"Doe\",\"age\":50,\"human\":true,\"city\":\"Houston\",\"ssn\":\"123-45-6789\",\"measure\": { \"value\":100 },\"measures\":[ { \"value\":1000 }, { \"value\":2000 } ],\"measured\":[ 1000, 2000 ],\"children\":[\"Jane\",\"June\",\"Josh\"],\"arrays\":[[\"Jane1\",\"June1\",\"Josh1\"],[\"Jane2\",\"June2\",\"Josh2\"]],\"zero\": { \"zeroValue\":0 }}}");
        CopySpec copySpec = (CopySpec)new CopySpec().fromTransform("/person/zero", "/zeroValue", (Function)JSONPrimitiveTransforms.TO_FLOAT);
        JSONCopyAsFunction function = new JSONCopyAsFunction(new Fields(new Comparable[]{"result"}), new CopySpec[]{copySpec});
        TupleListCollector result = JSONCopyAsFunctionTest.invokeFunction((cascading.operation.Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
        Object value = ((Tuple)result.iterator().next()).getObject(0);
        JSONCopyAsFunctionTest.assertNotNull((Object)value);
        JSONCopyAsFunctionTest.assertEquals((Object)JsonNodeType.NUMBER, (Object)((ObjectNode)value).get("zeroValue").getNodeType());
        JSONCopyAsFunctionTest.assertEquals(FloatNode.class, ((ObjectNode)value).get("zeroValue").getClass());
        JSONCopyAsFunctionTest.assertEquals((Object)Float.valueOf(0.0f), (Object)Float.valueOf(((ObjectNode)value).get("zeroValue").floatValue()));
        JSONCopyAsFunctionTest.assertEquals((String)"0.0", (String)((ObjectNode)value).get("zeroValue").asText());
    }

    @Test
    public void testCoerceArray() throws Exception {
        TupleEntry entry = new TupleEntry(new Fields((Comparable)((Object)"json"), (Type)JSONCoercibleType.TYPE), Tuple.size((int)1));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"{\"person\":{\"name\":\"John Doe\",\"firstName\":\"John\",\"lastName\":\"Doe\",\"age\":50,\"human\":true,\"city\":\"Houston\",\"ssn\":\"123-45-6789\",\"measure\": { \"value\":100 },\"measures\":[ { \"value\":1000 }, { \"value\":2000 } ],\"measured\":[ 1000, 2000 ],\"children\":[\"Jane\",\"June\",\"Josh\"],\"arrays\":[[\"Jane1\",\"June1\",\"Josh1\"],[\"Jane2\",\"June2\",\"Josh2\"]],\"zero\": { \"zeroValue\":0 }}}");
        CopySpec copySpec = (CopySpec)new CopySpec().fromTransform("/person", "/measures/*/value", (Function)JSONPrimitiveTransforms.TO_FLOAT);
        JSONCopyAsFunction function = new JSONCopyAsFunction(new Fields(new Comparable[]{"result"}), new CopySpec[]{copySpec});
        TupleListCollector result = JSONCopyAsFunctionTest.invokeFunction((cascading.operation.Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
        Object value = ((Tuple)result.iterator().next()).getObject(0);
        JSONCopyAsFunctionTest.assertNotNull((Object)value);
        JSONCopyAsFunctionTest.assertEquals((Object)JsonNodeType.ARRAY, (Object)((ObjectNode)value).get("measures").getNodeType());
        JSONCopyAsFunctionTest.assertEquals(FloatNode.class, ((ObjectNode)value).get("measures").get(0).get("value").getClass());
        JSONCopyAsFunctionTest.assertEquals((Object)Float.valueOf(1000.0f), (Object)Float.valueOf(((ObjectNode)value).get("measures").get(0).get("value").floatValue()));
        JSONCopyAsFunctionTest.assertEquals(FloatNode.class, ((ObjectNode)value).get("measures").get(1).get("value").getClass());
        JSONCopyAsFunctionTest.assertEquals((Object)Float.valueOf(2000.0f), (Object)Float.valueOf(((ObjectNode)value).get("measures").get(1).get("value").floatValue()));
    }

    @Test
    public void testResettableTransform() throws Exception {
        TupleEntry entry = new TupleEntry(new Fields(new Comparable[]{"json", "set-text"}).applyTypes(new Type[]{JSONCoercibleType.TYPE, String.class}), Tuple.size((int)2));
        CopySpec copySpec = (CopySpec)new CopySpec().fromTransform("/person", "/name", (Function)new JSONSetTextTransform("set-text", "value1"));
        JSONCopyAsFunction function = new JSONCopyAsFunction(new Fields(new Comparable[]{"result"}), new CopySpec[]{copySpec});
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"{\"person\":{\"name\":\"John Doe\",\"firstName\":\"John\",\"lastName\":\"Doe\",\"age\":50,\"human\":true,\"city\":\"Houston\",\"ssn\":\"123-45-6789\",\"measure\": { \"value\":100 },\"measures\":[ { \"value\":1000 }, { \"value\":2000 } ],\"measured\":[ 1000, 2000 ],\"children\":[\"Jane\",\"June\",\"Josh\"],\"arrays\":[[\"Jane1\",\"June1\",\"Josh1\"],[\"Jane2\",\"June2\",\"Josh2\"]],\"zero\": { \"zeroValue\":0 }}}");
        entry.setObject((Comparable)Integer.valueOf(1), (Object)"value2");
        TupleListCollector result = JSONCopyAsFunctionTest.invokeFunction((cascading.operation.Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
        JSONCopyAsFunctionTest.assertNotNull((Object)((Tuple)result.iterator().next()).getObject(0));
        JSONCopyAsFunctionTest.assertEquals((String)"value2", (String)((ObjectNode)((Tuple)result.iterator().next()).getObject(0)).get("name").textValue());
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"{\"person\":{\"name\":\"John Doe\",\"firstName\":\"John\",\"lastName\":\"Doe\",\"age\":50,\"human\":true,\"city\":\"Houston\",\"ssn\":\"123-45-6789\",\"measure\": { \"value\":100 },\"measures\":[ { \"value\":1000 }, { \"value\":2000 } ],\"measured\":[ 1000, 2000 ],\"children\":[\"Jane\",\"June\",\"Josh\"],\"arrays\":[[\"Jane1\",\"June1\",\"Josh1\"],[\"Jane2\",\"June2\",\"Josh2\"]],\"zero\": { \"zeroValue\":0 }}}");
        entry.setObject((Comparable)Integer.valueOf(1), (Object)"value3");
        result = JSONCopyAsFunctionTest.invokeFunction((cascading.operation.Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
        JSONCopyAsFunctionTest.assertNotNull((Object)((Tuple)result.iterator().next()).getObject(0));
        JSONCopyAsFunctionTest.assertEquals((String)"value3", (String)((ObjectNode)((Tuple)result.iterator().next()).getObject(0)).get("name").textValue());
    }
}

