/*
 * Decompiled with CFR 0.152.
 */
package cascading.nested.json.hadoop2;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.ion.IonObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.Serialization;
import org.apache.hadoop.io.serializer.Serializer;

public class JSONHadoopSerialization
extends Configured
implements Serialization {
    ObjectMapper mapper = new IonObjectMapper();

    public boolean accept(Class type) {
        return JsonNode.class.isAssignableFrom(type);
    }

    public Serializer getSerializer(Class type) {
        return new Serializer(){
            private OutputStream out;

            public void open(OutputStream out) {
                this.out = out;
            }

            public void serialize(Object object) throws IOException {
                JSONHadoopSerialization.this.mapper.writeValue(this.out, object);
            }

            public void close() throws IOException {
                this.out.close();
                this.out = null;
            }
        };
    }

    public Deserializer getDeserializer(Class type) {
        return new Deserializer(){
            private InputStream in;

            public void open(InputStream in) {
                this.in = in;
            }

            public Object deserialize(Object object) throws IOException {
                return JSONHadoopSerialization.this.mapper.readTree(this.in);
            }

            public void close() throws IOException {
                this.in.close();
                this.in = null;
            }
        };
    }
}

