/*
 * Decompiled with CFR 0.152.
 */
package cascading.nested.json;

import cascading.CascadingException;
import cascading.nested.core.NestedCoercibleType;
import cascading.nested.json.hadoop2.JSONHadoopSerialization;
import cascading.tuple.coerce.Coercions;
import cascading.tuple.type.CoercibleType;
import cascading.tuple.type.CoercionFrom;
import cascading.tuple.type.SerializableType;
import cascading.tuple.type.ToCanonical;
import cascading.util.Util;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import heretical.pointer.path.NestedPointerCompiler;
import heretical.pointer.path.json.JSONNestedPointerCompiler;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.hadoop.io.serializer.Serialization;

public class JSONCoercibleType
implements NestedCoercibleType<JsonNode, ArrayNode>,
SerializableType {
    public static final JSONCoercibleType TYPE = new JSONCoercibleType();
    private ObjectMapper mapper = new ObjectMapper();

    private JSONCoercibleType() {
        this.mapper.setConfig(this.mapper.getDeserializationConfig().with(DeserializationFeature.FAIL_ON_READING_DUP_TREE_KEY));
    }

    public JSONCoercibleType(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public Class<JsonNode> getCanonicalType() {
        return JsonNode.class;
    }

    public <T> ToCanonical<T, JsonNode> from(Type from) {
        if (from.getClass() == JSONCoercibleType.class) {
            return (ToCanonical & Serializable)v -> (JsonNode)v;
        }
        if (from instanceof Class && JsonNode.class.isAssignableFrom((Class)from)) {
            return (ToCanonical & Serializable)v -> (JsonNode)v;
        }
        if (from == String.class) {
            return (ToCanonical & Serializable)v -> v == null ? null : this.nodeOrParse((String)v);
        }
        if (from == Short.class || from == Short.TYPE) {
            return (ToCanonical & Serializable)v -> v == null ? null : JsonNodeFactory.instance.numberNode((Short)v);
        }
        if (from == Integer.class || from == Integer.TYPE) {
            return (ToCanonical & Serializable)v -> v == null ? null : JsonNodeFactory.instance.numberNode((Integer)v);
        }
        if (from == Long.class || from == Long.TYPE) {
            return (ToCanonical & Serializable)v -> v == null ? null : JsonNodeFactory.instance.numberNode((Long)v);
        }
        if (from == Float.class || from == Float.TYPE) {
            return (ToCanonical & Serializable)v -> v == null ? null : JsonNodeFactory.instance.numberNode((Float)v);
        }
        if (from == Double.class || from == Double.TYPE) {
            return (ToCanonical & Serializable)v -> v == null ? null : JsonNodeFactory.instance.numberNode((Double)v);
        }
        if (from == Boolean.class || from == Boolean.TYPE) {
            return (ToCanonical & Serializable)v -> v == null ? null : JsonNodeFactory.instance.booleanNode(((Boolean)v).booleanValue());
        }
        if (from instanceof Class && (Collection.class.isAssignableFrom((Class)from) || Map.class.isAssignableFrom((Class)from))) {
            return (ToCanonical & Serializable)v -> v == null ? null : this.mapper.valueToTree(v);
        }
        return (ToCanonical & Serializable)v -> v == null ? null : JsonNodeFactory.instance.pojoNode(v);
    }

    public JsonNode canonical(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> from = value.getClass();
        if (JsonNode.class.isAssignableFrom(from)) {
            return (JsonNode)value;
        }
        if (from == String.class) {
            return this.nodeOrParse((String)value);
        }
        if (from == Short.class || from == Short.TYPE) {
            return JsonNodeFactory.instance.numberNode((Short)value);
        }
        if (from == Integer.class || from == Integer.TYPE) {
            return JsonNodeFactory.instance.numberNode((Integer)value);
        }
        if (from == Long.class || from == Long.TYPE) {
            return JsonNodeFactory.instance.numberNode((Long)value);
        }
        if (from == Float.class || from == Float.TYPE) {
            return JsonNodeFactory.instance.numberNode((Float)value);
        }
        if (from == Double.class || from == Double.TYPE) {
            return JsonNodeFactory.instance.numberNode((Double)value);
        }
        if (from == Boolean.class || from == Boolean.TYPE) {
            return JsonNodeFactory.instance.booleanNode(((Boolean)value).booleanValue());
        }
        if (Collection.class.isAssignableFrom(from) || Map.class.isAssignableFrom(from)) {
            return this.mapper.valueToTree(value);
        }
        return JsonNodeFactory.instance.pojoNode(value);
    }

    protected <T> T ifNull(JsonNode node, Function<JsonNode, T> function) {
        if (node == null || node.getNodeType() == JsonNodeType.NULL || node.getNodeType() == JsonNodeType.MISSING) {
            return null;
        }
        return function.apply(node);
    }

    public <T> CoercionFrom<JsonNode, T> to(Type to) {
        if (to == null || to.getClass() == JSONCoercibleType.class) {
            return (CoercionFrom & Serializable)t -> t;
        }
        Class actualTo = to instanceof CoercibleType ? ((CoercibleType)to).getCanonicalType() : (Class)to;
        if (JsonNode.class.isAssignableFrom(actualTo)) {
            return (CoercionFrom & Serializable)t -> t;
        }
        if (actualTo == String.class) {
            return (CoercionFrom & Serializable)node -> this.ifNull((JsonNode)node, n -> n.getNodeType() == JsonNodeType.STRING ? n.textValue() : this.textOrWrite((JsonNode)n));
        }
        if (actualTo == Short.class || actualTo == Short.TYPE) {
            return (CoercionFrom & Serializable)node -> this.ifNull((JsonNode)node, n -> n.getNodeType() == JsonNodeType.NUMBER ? Short.valueOf(n.shortValue()) : Coercions.coerce((Object)this.textOrWrite((JsonNode)n), (Type)to));
        }
        if (actualTo == Integer.class || actualTo == Integer.TYPE) {
            return (CoercionFrom & Serializable)node -> this.ifNull((JsonNode)node, n -> n.getNodeType() == JsonNodeType.NUMBER ? Integer.valueOf(n.intValue()) : Coercions.coerce((Object)this.textOrWrite((JsonNode)n), (Type)to));
        }
        if (actualTo == Long.class || actualTo == Long.TYPE) {
            return (CoercionFrom & Serializable)node -> this.ifNull((JsonNode)node, n -> n.getNodeType() == JsonNodeType.NUMBER ? Long.valueOf(n.longValue()) : Coercions.coerce((Object)this.textOrWrite((JsonNode)n), (Type)to));
        }
        if (actualTo == Float.class || actualTo == Float.TYPE) {
            return (CoercionFrom & Serializable)node -> this.ifNull((JsonNode)node, n -> n.getNodeType() == JsonNodeType.NUMBER ? Float.valueOf(n.floatValue()) : Coercions.coerce((Object)this.textOrWrite((JsonNode)n), (Type)to));
        }
        if (actualTo == Double.class || actualTo == Double.TYPE) {
            return (CoercionFrom & Serializable)node -> this.ifNull((JsonNode)node, n -> n.getNodeType() == JsonNodeType.NUMBER ? Double.valueOf(n.doubleValue()) : Coercions.coerce((Object)this.textOrWrite((JsonNode)n), (Type)to));
        }
        if (actualTo == Boolean.class || actualTo == Boolean.TYPE) {
            return (CoercionFrom & Serializable)node -> this.ifNull((JsonNode)node, n -> n.getNodeType() == JsonNodeType.BOOLEAN ? Boolean.valueOf(n.booleanValue()) : Coercions.coerce((Object)this.textOrWrite((JsonNode)n), (Type)to));
        }
        if (Map.class.isAssignableFrom(actualTo)) {
            return (CoercionFrom & Serializable)node -> this.ifNull((JsonNode)node, n -> this.convertTree((JsonNode)n, actualTo));
        }
        if (List.class.isAssignableFrom(actualTo)) {
            return (CoercionFrom & Serializable)node -> this.ifNull((JsonNode)node, n -> this.convertTree((JsonNode)n, actualTo));
        }
        if (Temporal.class.isAssignableFrom(actualTo)) {
            return (CoercionFrom & Serializable)node -> this.ifNull((JsonNode)node, n -> this.convertTree((JsonNode)n, actualTo));
        }
        if (TemporalAmount.class.isAssignableFrom(actualTo)) {
            return (CoercionFrom & Serializable)node -> this.ifNull((JsonNode)node, n -> this.convertTree((JsonNode)n, actualTo));
        }
        if (to instanceof CoercibleType) {
            return (CoercionFrom & Serializable)node -> this.ifNull((JsonNode)node, n -> ((CoercibleType)to).canonical((Object)this.textOrWrite((JsonNode)n)));
        }
        throw new CascadingException("unknown type coercion requested, from: " + Util.getTypeName(JsonNode.class) + " to: " + Util.getTypeName((Type)to));
    }

    public <Coerce> Coerce coerce(Object value, Type to) {
        if (to == null || to.getClass() == JSONCoercibleType.class) {
            return (Coerce)value;
        }
        if (value == null) {
            return null;
        }
        Class<?> from = value.getClass();
        if (!JsonNode.class.isAssignableFrom(from)) {
            throw new IllegalStateException("was not normalized, got: " + from.getName());
        }
        JsonNode node = (JsonNode)value;
        if (node.isMissingNode()) {
            return null;
        }
        JsonNodeType nodeType = node.getNodeType();
        if (nodeType == JsonNodeType.NULL) {
            return null;
        }
        Class actualTo = to instanceof CoercibleType ? ((CoercibleType)to).getCanonicalType() : (Class)to;
        if (JsonNode.class.isAssignableFrom(actualTo)) {
            return (Coerce)node;
        }
        if (actualTo == String.class) {
            return (Coerce)(nodeType == JsonNodeType.STRING ? node.textValue() : this.textOrWrite(node));
        }
        if (actualTo == Short.class || actualTo == Short.TYPE) {
            return (Coerce)(nodeType == JsonNodeType.NUMBER ? Short.valueOf(node.shortValue()) : Coercions.coerce((Object)this.textOrWrite(node), (Type)to));
        }
        if (actualTo == Integer.class || actualTo == Integer.TYPE) {
            return (Coerce)(nodeType == JsonNodeType.NUMBER ? Integer.valueOf(node.intValue()) : Coercions.coerce((Object)this.textOrWrite(node), (Type)to));
        }
        if (actualTo == Long.class || actualTo == Long.TYPE) {
            return (Coerce)(nodeType == JsonNodeType.NUMBER ? Long.valueOf(node.longValue()) : Coercions.coerce((Object)this.textOrWrite(node), (Type)to));
        }
        if (actualTo == Float.class || actualTo == Float.TYPE) {
            return (Coerce)(nodeType == JsonNodeType.NUMBER ? Float.valueOf(node.floatValue()) : Coercions.coerce((Object)this.textOrWrite(node), (Type)to));
        }
        if (actualTo == Double.class || actualTo == Double.TYPE) {
            return (Coerce)(nodeType == JsonNodeType.NUMBER ? Double.valueOf(node.doubleValue()) : Coercions.coerce((Object)this.textOrWrite(node), (Type)to));
        }
        if (actualTo == Boolean.class || actualTo == Boolean.TYPE) {
            return (Coerce)(nodeType == JsonNodeType.BOOLEAN ? Boolean.valueOf(node.booleanValue()) : Coercions.coerce((Object)this.textOrWrite(node), (Type)to));
        }
        if (Map.class.isAssignableFrom(actualTo)) {
            return (Coerce)this.convertTree(node, actualTo);
        }
        if (List.class.isAssignableFrom(actualTo)) {
            return (Coerce)this.convertTree(node, actualTo);
        }
        if (Temporal.class.isAssignableFrom(actualTo)) {
            return (Coerce)this.convertTree(node, actualTo);
        }
        if (TemporalAmount.class.isAssignableFrom(actualTo)) {
            return (Coerce)this.convertTree(node, actualTo);
        }
        if (to instanceof CoercibleType) {
            return (Coerce)((CoercibleType)to).canonical((Object)this.textOrWrite(node));
        }
        throw new CascadingException("unknown type coercion requested, from: " + Util.getTypeName(from) + " to: " + Util.getTypeName((Type)to));
    }

    private Object convertTree(JsonNode value, Class<?> to) {
        try {
            return this.mapper.treeToValue((TreeNode)value, to);
        }
        catch (JsonProcessingException exception) {
            throw new CascadingException("unable to coerce json node into " + to.getName(), (Throwable)exception);
        }
    }

    private String textOrWrite(JsonNode value) {
        if (value != null && value.isTextual()) {
            return value.textValue();
        }
        try {
            return this.write(value);
        }
        catch (JsonProcessingException exception) {
            throw new CascadingException("unable to write value as json", (Throwable)exception);
        }
    }

    private String write(JsonNode value) throws JsonProcessingException {
        return this.mapper.writeValueAsString((Object)value);
    }

    private JsonNode nodeOrParse(String value) {
        try {
            return this.parse(value);
        }
        catch (JsonParseException exception) {
            return JsonNodeFactory.instance.textNode(value);
        }
        catch (IOException exception) {
            throw new CascadingException("unable to read json", (Throwable)exception);
        }
    }

    private JsonNode parse(String value) throws IOException {
        return this.mapper.readTree(value);
    }

    public NestedPointerCompiler<JsonNode, ArrayNode> getNestedPointerCompiler() {
        return JSONNestedPointerCompiler.COMPILER;
    }

    public JsonNode deepCopy(JsonNode jsonNode) {
        if (jsonNode == null) {
            return null;
        }
        return jsonNode.deepCopy();
    }

    public JsonNode newRoot() {
        return JsonNodeFactory.instance.objectNode();
    }

    public Class getSerializer(Class base) {
        if (base == Serialization.class) {
            return JSONHadoopSerialization.class;
        }
        return null;
    }

    public String toString() {
        return this.getClass().getName();
    }

    public int hashCode() {
        return this.getCanonicalType().hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CoercibleType)) {
            return false;
        }
        return this.getCanonicalType().equals(((CoercibleType)object).getCanonicalType());
    }
}

