/*
 * Decompiled with CFR 0.152.
 */
package cascading.nested.json;

import cascading.CascadingTestCase;
import cascading.nested.core.BuildSpec;
import cascading.nested.json.JSONBuildAsAggregator;
import cascading.nested.json.JSONCoercibleType;
import cascading.operation.Aggregator;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.TupleListCollector;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.lang.reflect.Type;
import org.junit.Test;

public class JSONBuildAsAggregatorTest
extends CascadingTestCase {
    @Test
    public void testBuilderAggregator() throws Exception {
        Fields fields = new Fields((Comparable)((Object)"result"), (Type)JSONCoercibleType.TYPE);
        TupleEntry group = new TupleEntry(new Fields((Comparable)((Object)"id"), String.class), new Tuple(new Object[]{"123-45-6789"}));
        Fields argumentFields = Fields.NONE.append(new Fields((Comparable)((Object)"id"), String.class)).append(new Fields((Comparable)((Object)"age"), Integer.class)).append(new Fields((Comparable)((Object)"first"), String.class)).append(new Fields((Comparable)((Object)"last"), String.class)).append(new Fields((Comparable)((Object)"child"), String.class)).append(new Fields((Comparable)((Object)"child-age"), String.class));
        TupleEntry[] arguments = new TupleEntry[]{new TupleEntry(argumentFields, new Tuple(new Object[]{"123-45-6789", 22, "john", "doe", "jane", "12"})), new TupleEntry(argumentFields, new Tuple(new Object[]{"123-45-6789", 22, "john", "doe", "jill", "13"})), new TupleEntry(argumentFields, new Tuple(new Object[]{"123-45-6789", 22, "john", "doe", "julie", "14"}))};
        BuildSpec spec = (BuildSpec)((BuildSpec)((BuildSpec)((BuildSpec)((BuildSpec)((BuildSpec)new BuildSpec().putInto("id", "/ssn")).putInto("age", String.class, "/age")).putInto("first", "/name/first")).putInto("last", "/name/last")).addInto("child", "/children")).addInto("child-age", Integer.class, "/childAges");
        JSONBuildAsAggregator aggregator = new JSONBuildAsAggregator(fields, new BuildSpec[]{spec});
        TupleListCollector result = JSONBuildAsAggregatorTest.invokeAggregator((Aggregator)aggregator, (TupleEntry)group, (TupleEntry[])arguments, (Fields)fields);
        ObjectNode value = (ObjectNode)((Tuple)result.iterator().next()).getObject(0);
        JSONBuildAsAggregatorTest.assertNotNull((Object)value);
        JSONBuildAsAggregatorTest.assertEquals((String)"john", (String)value.findPath("name").findPath("first").textValue());
        JSONBuildAsAggregatorTest.assertEquals((Object)JsonNodeType.STRING, (Object)value.findPath("age").getNodeType());
        JSONBuildAsAggregatorTest.assertEquals((String)"22", (String)value.findPath("age").textValue());
        JSONBuildAsAggregatorTest.assertEquals((String)"123-45-6789", (String)value.findValue("ssn").textValue());
        JSONBuildAsAggregatorTest.assertEquals((Object)JsonNodeType.ARRAY, (Object)value.findPath("childAges").getNodeType());
        JSONBuildAsAggregatorTest.assertEquals((int)3, (int)value.findPath("childAges").size());
        JSONBuildAsAggregatorTest.assertEquals((Object)JsonNodeType.NUMBER, (Object)value.findPath("childAges").get(0).getNodeType());
    }
}

