/*
 * Decompiled with CFR 0.152.
 */
package cascading.platform.local;

import cascading.flow.FlowConnector;
import cascading.flow.FlowProcess;
import cascading.flow.FlowSession;
import cascading.flow.local.LocalFlowConnector;
import cascading.flow.local.LocalFlowProcess;
import cascading.nested.json.local.JSONTextLine;
import cascading.platform.TestPlatform;
import cascading.platform.local.LocalConfigDefScheme;
import cascading.platform.local.LocalFailScheme;
import cascading.platform.local.TestLongComparator;
import cascading.platform.local.TestStringComparator;
import cascading.property.PropertyUtil;
import cascading.scheme.Scheme;
import cascading.scheme.local.TextDelimited;
import cascading.scheme.local.TextLine;
import cascading.scheme.util.DelimitedParser;
import cascading.scheme.util.FieldTypeResolver;
import cascading.tap.SinkMode;
import cascading.tap.Tap;
import cascading.tap.local.DirTap;
import cascading.tap.local.FileTap;
import cascading.tap.local.PartitionTap;
import cascading.tap.partition.Partition;
import cascading.tuple.Fields;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;

public class LocalPlatform
extends TestPlatform {
    private Properties properties = new Properties();

    public void setUp() throws IOException {
        this.properties.putAll((Map<?, ?>)LocalPlatform.getGlobalProperties());
    }

    public Map<Object, Object> getProperties() {
        return PropertyUtil.asFlatMap((Map)this.properties);
    }

    public void tearDown() {
    }

    public void copyFromLocal(String inputFile) throws IOException {
    }

    public void copyToLocal(String outputFile) throws IOException {
    }

    public boolean remoteExists(String outputFile) throws IOException {
        return new File(outputFile).exists();
    }

    public boolean remoteRemove(String outputFile, boolean recursive) throws IOException {
        if (!this.remoteExists(outputFile)) {
            return true;
        }
        File file = new File(outputFile);
        if (!recursive || !file.isDirectory()) {
            return file.delete();
        }
        try {
            FileUtils.deleteDirectory((File)file);
        }
        catch (IOException exception) {
            return false;
        }
        return !file.exists();
    }

    public FlowProcess getFlowProcess() {
        return new LocalFlowProcess(FlowSession.NULL, PropertyUtil.createProperties(this.getProperties(), null));
    }

    public FlowConnector getFlowConnector(Map<Object, Object> properties) {
        return new LocalFlowConnector(properties);
    }

    public Tap getTap(Scheme scheme, String filename, SinkMode mode) {
        return new FileTap(scheme, filename, mode);
    }

    public Tap getTextFile(Fields sourceFields, Fields sinkFields, String filename, SinkMode mode) {
        if (sourceFields == null) {
            return new DirTap((Scheme)new TextLine(), filename, mode);
        }
        return new DirTap((Scheme)new TextLine(sourceFields, sinkFields), filename, mode);
    }

    public Tap getDelimitedFile(Fields fields, boolean hasHeader, String delimiter, String quote, Class[] types, String filename, SinkMode mode) {
        return new DirTap((Scheme)new TextDelimited(fields, hasHeader, delimiter, quote, types), filename, mode);
    }

    public Tap getDelimitedFile(Fields fields, boolean skipHeader, boolean writeHeader, String delimiter, String quote, Class[] types, String filename, SinkMode mode) {
        return new DirTap((Scheme)new TextDelimited(fields, skipHeader, writeHeader, delimiter, quote, types), filename, mode);
    }

    public Tap getDelimitedFile(String delimiter, String quote, FieldTypeResolver fieldTypeResolver, String filename, SinkMode mode) {
        return new DirTap((Scheme)new TextDelimited(true, new DelimitedParser(delimiter, quote, fieldTypeResolver)), filename, mode);
    }

    public Tap getJSONFile(Fields fields, String filename, SinkMode mode) {
        return new DirTap((Scheme)new JSONTextLine(fields), filename, mode);
    }

    public Tap getPartitionTap(Tap sink, Partition partition, int openThreshold) {
        return new PartitionTap((Tap)((FileTap)sink), partition, openThreshold);
    }

    public Scheme getTestConfigDefScheme() {
        return new LocalConfigDefScheme(new Fields(new Comparable[]{"line"}));
    }

    public Scheme getTestFailScheme() {
        return new LocalFailScheme(new Fields(new Comparable[]{"line"}));
    }

    public Comparator getLongComparator(boolean reverseSort) {
        return new TestLongComparator(reverseSort);
    }

    public Comparator getStringComparator(boolean reverseSort) {
        return new TestStringComparator(reverseSort);
    }

    public String getHiddenTemporaryPath() {
        return null;
    }
}

