/*
 * Decompiled with CFR 0.152.
 */
package cascading.local.tap.splunk;

import cascading.flow.FlowProcess;
import cascading.local.tap.splunk.SplunkScheme;
import cascading.local.tap.splunk.SplunkTap;
import cascading.tap.SinkMode;
import cascading.tap.Tap;
import cascading.tuple.TupleEntryCollector;
import cascading.tuple.TupleEntrySchemeCollector;
import com.splunk.Index;
import com.splunk.JobExportArgs;
import com.splunk.Service;
import com.splunk.ServiceArgs;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Properties;

public class SplunkIndexTap
extends SplunkTap {
    private String indexName;

    public SplunkIndexTap(SplunkScheme scheme, String host, int port, String indexName) {
        super(scheme, host, port);
        this.indexName = indexName;
    }

    public SplunkIndexTap(SplunkScheme scheme, ServiceArgs serviceArgs, String indexName) {
        super(scheme, serviceArgs);
        this.indexName = indexName;
    }

    public SplunkIndexTap(SplunkScheme scheme, ServiceArgs serviceArgs, JobExportArgs exportArgs, String indexName) {
        super(scheme, serviceArgs, exportArgs);
        this.indexName = indexName;
    }

    public SplunkIndexTap(SplunkScheme scheme, ServiceArgs serviceArgs, JobExportArgs exportArgs, SinkMode sinkMode, String indexName) {
        super(scheme, serviceArgs, exportArgs, sinkMode);
        this.indexName = indexName;
    }

    public SplunkIndexTap(SplunkScheme scheme, Service service, String indexName) {
        super(scheme, service, null);
        this.indexName = indexName;
    }

    public SplunkIndexTap(SplunkScheme scheme, Service service, JobExportArgs exportArgs, String indexName) {
        super(scheme, service, exportArgs);
        this.indexName = indexName;
    }

    public SplunkIndexTap(SplunkScheme scheme, Service service, JobExportArgs exportArgs, SinkMode sinkMode, String indexName) {
        super(scheme, service, exportArgs, sinkMode);
        this.indexName = indexName;
    }

    @Override
    protected String getSplunkQuery() {
        return null;
    }

    @Override
    protected String getSplunkPath() {
        return "/" + this.indexName;
    }

    @Override
    protected String getSearch() {
        return String.format("search index=%s *", this.indexName);
    }

    public TupleEntryCollector openForWrite(FlowProcess<? extends Properties> flowProcess, OutputStream outputStream) throws IOException {
        Index index = this.getOrCreateIndex();
        final Socket socket = index.attach();
        BufferedOutputStream stream = new BufferedOutputStream(socket.getOutputStream()){

            @Override
            public void close() throws IOException {
                super.close();
                socket.close();
            }
        };
        return new TupleEntrySchemeCollector(flowProcess, (Tap)this, this.getScheme(), (Object)stream, this::getIdentifier);
    }

    protected Index getOrCreateIndex() {
        Index index = this.getIndex();
        if (index == null) {
            index = (Index)this.getService().getIndexes().create(this.indexName);
        }
        return index;
    }

    protected Index getIndex() {
        return (Index)this.getService().getIndexes().get((Object)this.indexName);
    }

    public boolean createResource(Properties conf) {
        Index index = this.getOrCreateIndex();
        return index != null;
    }

    public boolean deleteResource(Properties conf) {
        Index index = this.getIndex();
        index.remove();
        return true;
    }

    public boolean resourceExists(Properties conf) throws IOException {
        return this.getIndex() != null;
    }

    public long getModifiedTime(Properties conf) throws IOException {
        return this.resourceExists(conf) ? Long.MAX_VALUE : 0L;
    }
}

