/*
 * Decompiled with CFR 0.152.
 */
package com.splunk;

import com.splunk.Args;
import com.splunk.Command;
import com.splunk.HttpException;
import com.splunk.HttpService;
import com.splunk.Index;
import com.splunk.Job;
import com.splunk.Message;
import com.splunk.MessageCollection;
import com.splunk.ResourceRoot;
import com.splunk.ResponseMessage;
import com.splunk.ResultsReaderXml;
import com.splunk.SSLSecurityProtocol;
import com.splunk.Service;
import com.splunk.Util;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public abstract class SDKTestCase {
    protected static final boolean WORKAROUND_KNOWN_BUGS = true;
    private static final boolean VERBOSE_PORT_SCAN = false;
    protected static Service service;
    protected List<String> installedApps;
    protected Command command;

    public static String streamToString(InputStream is) {
        InputStreamReader r = null;
        try {
            r = new InputStreamReader(is, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Your JVM does not support UTF-8!");
        }
        StringBuffer sb = new StringBuffer();
        try {
            int ch;
            while ((ch = ((Reader)r).read()) != -1) {
                sb.append((char)ch);
            }
        }
        catch (IOException ioex) {
            throw new RuntimeException(ioex.getMessage());
        }
        return sb.toString();
    }

    public void connect() {
        if (service != null) {
            service.login(SDKTestCase.service.username, SDKTestCase.service.password);
        } else {
            service = Service.connect((Map)this.command.opts);
        }
    }

    public static Integer getJavaVersion() {
        String ver = System.getProperty("java.version");
        return Integer.parseInt(ver.substring(2, 3));
    }

    @Before
    public void setUp() throws Exception {
        HttpService.setSslSecurityProtocol((SSLSecurityProtocol)SSLSecurityProtocol.TLSv1_2);
        if (service == null) {
            this.command = Command.splunk();
        }
        this.connect();
        if (this.restartRequired()) {
            System.out.println("WARNING: Splunk was already in a state requiring a restart prior to running this test. Trying to recover...");
            this.splunkRestart();
            System.out.println("Restart complete.");
        }
        this.installedApps = new ArrayList<String>();
    }

    @After
    public void tearDown() throws Exception {
        if (this.restartRequired()) {
            Assert.fail((String)"Test left Splunk in a state that required restart.");
        }
        if (service.versionIsAtLeast("4.3")) {
            for (String applicationName : this.installedApps) {
                block5: {
                    try {
                        service.getApplications().remove(applicationName);
                    }
                    catch (HttpException e) {
                        if (service.versionCompare("6.0.0") != 0 || e.getStatus() == 500) break block5;
                        throw e;
                    }
                }
                this.clearRestartMessage();
            }
        }
    }

    protected static String createTimestamp() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd-HH:mm:ss");
        return dateFormat.format(new Date());
    }

    protected static String createTemporaryName() {
        return "delete-me-" + UUID.randomUUID().toString();
    }

    public static InputStream openResource(String path) {
        if (path.startsWith("splunk_search:")) {
            path = path.substring("splunk_search:".length());
            String[] pathComponents = path.split("/");
            String searchType = pathComponents[0];
            String outputMode = pathComponents[1];
            String search = pathComponents[2];
            Args resultsArgs = new Args("output_mode", (Object)outputMode);
            if (searchType.equals("blocking")) {
                Job job = service.getJobs().create(search, (Map)new Args("exec_mode", (Object)"blocking"));
                return job.getResults((Map)resultsArgs);
            }
            if (searchType.equals("oneshot")) {
                return service.oneshotSearch(search, resultsArgs);
            }
            throw new IllegalArgumentException("Unrecognized search type: " + searchType);
        }
        InputStream input = ResourceRoot.class.getResourceAsStream(path);
        Assert.assertNotNull((String)("Could not open " + path), (Object)input);
        return input;
    }

    public static boolean assertEventuallyTrue(EventuallyTrueBehavior behavior) {
        int remainingTries = behavior.tries();
        while (remainingTries > 0) {
            boolean succeeded = (Boolean)behavior.get();
            if (succeeded) {
                return true;
            }
            --remainingTries;
            try {
                Thread.sleep(behavior.pauseTime());
            }
            catch (InterruptedException interruptedException) {}
        }
        Assert.fail((String)behavior.message());
        return false;
    }

    public boolean hasTestData() {
        String collectionName = "sdk-app-collection";
        return service.getApplications().containsKey((Object)"sdk-app-collection");
    }

    public void installApplicationFromTestData(String applicationName) {
        String separator;
        String collectionName = "sdk-app-collection";
        if (!service.getApplications().containsKey((Object)"sdk-app-collection")) {
            throw new RuntimeException("no apps instaled");
        }
        String splunkHome = service.getSettings().getSplunkHome();
        if (splunkHome.contains("/") && splunkHome.contains("\\")) {
            separator = "\\";
        } else if (splunkHome.contains("/")) {
            separator = "/";
        } else if (splunkHome.contains("\\")) {
            separator = "\\";
        } else {
            throw new RuntimeException("Couldn't determine what the path separator was for splunkd.");
        }
        String[] pathComponents = new String[]{splunkHome, "etc", "apps", collectionName, "build", applicationName + ".tar"};
        String appPath = Util.join((String)separator, (String[])pathComponents);
        Args args = new Args();
        args.put((Object)"name", (Object)appPath);
        args.put((Object)"update", (Object)"1");
        service.post("apps/appinstall", (Map)args);
        this.installedApps.add(applicationName);
    }

    public void clearRestartMessage() {
        MessageCollection messages = service.getMessages();
        if (messages.containsKey((Object)"restart_required")) {
            messages.remove("restart_required");
            SDKTestCase.assertEventuallyTrue(() -> {
                messages.refresh();
                return !messages.containsKey((Object)"restart_required");
            });
        }
    }

    public boolean restartRequired() {
        for (Message message : service.getMessages().values()) {
            if (!message.containsKey((Object)"restart_required")) continue;
            return true;
        }
        return false;
    }

    private void markAsRestartRequired() {
        service.getMessages().create("restart_required", "Unit test called markAsRestartRequired().");
    }

    public void splunkRestart() {
        if (!this.restartRequired()) {
            Assert.fail((String)"Asked to restart Splunk when no restart was required.");
        }
        this.uncheckedSplunkRestart();
    }

    public void uncheckedSplunkRestart() {
        ResponseMessage response = service.restart();
        if (response.getStatus() != 200) {
            Assert.fail((String)("Restart command failed: " + response.getContent()));
        }
        this.markAsRestartRequired();
        SDKTestCase.assertEventuallyTrue(() -> {
            try {
                this.connect();
                return !this.restartRequired();
            }
            catch (Exception e) {
                return false;
            }
        });
    }

    protected static void sleep(int milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected int findNextUnusedPort(int startingPort) {
        int port = startingPort;
        while (this.isPortInUse(port)) {
            ++port;
        }
        return port;
    }

    public boolean isPortInUse(int port) {
        try {
            Socket pingSocket = new Socket();
            try {
                pingSocket.connect(new InetSocketAddress(service.getHost(), port), 1000);
            }
            catch (SocketTimeoutException ste) {
                return false;
            }
            pingSocket.close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    protected static boolean contains(String[] array, String value) {
        return Arrays.asList(array).contains(value);
    }

    protected static String locateSystemLog() {
        String filename = null;
        String osName = service.getInfo().getOsName();
        if (osName.equals("Windows")) {
            filename = "C:\\Windows\\WindowsUpdate.log";
        } else if (osName.equals("Linux")) {
            filename = "/etc/fstab";
        } else if (osName.equals("Darwin")) {
            filename = "/var/log/system.log";
        } else {
            throw new RuntimeException("OS " + osName + " not recognized");
        }
        Assert.assertNotNull((Object)filename);
        return filename;
    }

    protected static String joinServerPath(String[] components) {
        String separator;
        String osName = service.getInfo().getOsName();
        if (osName.equals("Windows")) {
            separator = "\\";
        } else if (osName.equals("Linux")) {
            separator = "/";
        } else if (osName.equals("Darwin")) {
            separator = "/";
        } else {
            throw new RuntimeException("OS " + osName + " not recognized");
        }
        return Util.join((String)separator, (String[])components);
    }

    protected boolean firstLineIsXmlDtd(InputStream stream) {
        InputStreamReader reader;
        try {
            reader = new InputStreamReader(stream, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
        BufferedReader lineReader = new BufferedReader(reader);
        try {
            return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>".equals(lineReader.readLine());
        }
        catch (IOException e) {
            Assert.fail((String)e.toString());
            return false;
        }
    }

    protected int getResultCountOfIndex(Service service, String indexName) {
        InputStream results = service.oneshotSearch("search index=" + indexName);
        BufferedInputStream stream = new BufferedInputStream(results);
        try {
            stream.mark(2048);
            ResultsReaderXml resultsReader = new ResultsReaderXml((InputStream)stream);
            int numEvents = 0;
            while (resultsReader.getNextEvent() != null) {
                ++numEvents;
            }
            return numEvents;
        }
        catch (Exception e) {
            try {
                String line;
                stream.reset();
                BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)stream, StandardCharsets.UTF_8));
                while ((line = r.readLine()) != null) {
                    System.out.println("line = " + line);
                }
            }
            catch (IOException exception) {
                System.out.println("exception = " + exception);
            }
            throw new RuntimeException(e);
        }
    }

    protected int getTotalEventCount(Index index) {
        index.refresh();
        return index.getTotalEventCount();
    }

    public static interface EventuallyTrueBehavior
    extends Supplier<Boolean> {
        default public int tries() {
            return 60;
        }

        default public int pauseTime() {
            return 1000;
        }

        default public String message() {
            return "Test timed out before true.";
        }
    }
}

