/*
 * Decompiled with CFR 0.152.
 */
package cascading.local.tap.splunk;

import cascading.flow.FlowProcess;
import cascading.local.tap.splunk.SplunkCSV;
import cascading.local.tap.splunk.SplunkScheme;
import cascading.local.tap.splunk.SplunkSearchTap;
import cascading.local.tap.splunk.SplunkUtil;
import cascading.tuple.Fields;
import cascading.tuple.TupleEntry;
import cascading.tuple.TupleEntryIterator;
import com.splunk.HttpService;
import com.splunk.JobExportArgs;
import com.splunk.SSLSecurityProtocol;
import com.splunk.ServiceArgs;
import java.io.IOException;

public class Main {
    public static void main(String[] args) throws IOException {
        HttpService.setSslSecurityProtocol((SSLSecurityProtocol)SSLSecurityProtocol.TLSv1_2);
        String host = args[0];
        String port = args[1];
        String search = args[2];
        String earliest = args[3];
        String latest = args[4];
        ServiceArgs serviceArgs = new ServiceArgs();
        serviceArgs.putAll(SplunkUtil.loadSplunkRC());
        serviceArgs.setHost(host);
        serviceArgs.setPort(Integer.valueOf(port).intValue());
        serviceArgs.setUsername(System.getenv("SPLUNK_USERNAME"));
        serviceArgs.setPassword(System.getenv("SPLUNK_PASSWORD"));
        JobExportArgs exportArgs = new JobExportArgs();
        exportArgs.setEarliestTime(earliest);
        exportArgs.setLatestTime(latest);
        SplunkCSV splunkCSV = new SplunkCSV(Fields.ALL);
        SplunkSearchTap searchTap = new SplunkSearchTap((SplunkScheme)splunkCSV, serviceArgs, exportArgs, search);
        TupleEntryIterator iterator = searchTap.openForRead(FlowProcess.nullFlowProcess());
        while (iterator.hasNext()) {
            System.out.println(((TupleEntry)iterator.next()).getTuple());
        }
    }
}

