/*
 * Decompiled with CFR 0.152.
 */
package cascading.local.tap.aws.s3;

import cascading.util.Util;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.time.Duration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class S3Iterable
implements Iterable<S3ObjectSummary> {
    private static final Logger LOG = LoggerFactory.getLogger(S3Iterable.class);
    private AmazonS3 client;
    private String bucketName;
    private String prefix;
    private String marker;
    private String delimiter;
    private Predicate<String> filter;
    private int maxDepth = Integer.MAX_VALUE;
    private Integer batchSize;

    public static S3Iterable iterable(AmazonS3 s3, String bucketName, String prefix) {
        S3Iterable iterable = new S3Iterable(s3, bucketName);
        iterable.prefix = prefix;
        return iterable;
    }

    private S3Iterable(AmazonS3 client, String bucketName) {
        this.client = client;
        this.bucketName = bucketName;
    }

    public S3Iterable withMarker(String marker) {
        this.marker = marker;
        return this;
    }

    public S3Iterable withBatchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public S3Iterable withDelimiter(String delimiter) {
        this.delimiter = delimiter;
        return this;
    }

    public S3Iterable withFilter(Predicate<String> filter) {
        this.filter = filter;
        return this;
    }

    public S3Iterable withMaxDepth(int depth) {
        this.maxDepth = depth;
        return this;
    }

    public AmazonS3 getClient() {
        return this.client;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getMarker() {
        return this.marker;
    }

    public Predicate<String> getFilter() {
        return this.filter;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    @Override
    public Iterator<S3ObjectSummary> iterator() {
        return new S3ObjectIterator();
    }

    class S3ObjectIterator
    implements Iterator<S3ObjectSummary> {
        private int depth = 0;
        private Queue<String> prefixes = new LinkedList<String>();
        private ObjectListing current = null;
        private Iterator<S3ObjectSummary> iterator = null;

        protected S3ObjectIterator() {
            if (!Util.isEmpty((String)S3Iterable.this.getPrefix())) {
                this.prefixes.offer(S3Iterable.this.getPrefix());
            }
        }

        @Override
        public boolean hasNext() {
            return this.currentIterator().hasNext();
        }

        @Override
        public S3ObjectSummary next() {
            return this.currentIterator().next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private Iterator<S3ObjectSummary> currentIterator() {
            while (!(this.depth >= S3Iterable.this.maxDepth || this.current != null && (this.iterator.hasNext() || !this.current.isTruncated() && this.prefixes.isEmpty()))) {
                if (!(this.current == null || this.iterator.hasNext() || this.current.isTruncated() || this.prefixes.isEmpty())) {
                    this.current = null;
                }
                long startTime = System.currentTimeMillis();
                this.current = this.current == null ? S3Iterable.this.getClient().listObjects(this.createRequest()) : S3Iterable.this.getClient().listNextBatchOfObjects(this.current);
                long duration = System.currentTimeMillis() - startTime;
                this.prefixes.addAll(this.current.getCommonPrefixes());
                List objectSummaries = this.current.getObjectSummaries();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("s3 {}/{} listed items: {}, with max: {}, in: {}", new Object[]{S3Iterable.this.bucketName, S3Iterable.this.prefix == null ? "" : S3Iterable.this.prefix, objectSummaries.size(), this.current.getMaxKeys(), Duration.ofMillis(duration)});
                }
                if (S3Iterable.this.filter != null) {
                    this.iterator = objectSummaries.stream().filter(s -> S3Iterable.this.filter.test(s.getKey())).iterator();
                    continue;
                }
                this.iterator = objectSummaries.iterator();
            }
            return this.iterator;
        }

        protected ListObjectsRequest createRequest() {
            ++this.depth;
            return new ListObjectsRequest().withBucketName(S3Iterable.this.getBucketName()).withPrefix(this.prefixes.poll()).withMaxKeys(S3Iterable.this.getBatchSize()).withDelimiter(S3Iterable.this.getDelimiter()).withMarker(S3Iterable.this.getMarker());
        }
    }
}

