/*
 * Decompiled with CFR 0.152.
 */
package cascading.local.util;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.transfer.MultipleFileUpload;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.TransferManagerBuilder;
import java.io.File;
import java.net.URI;
import java.util.Properties;
import java.util.function.Supplier;
import org.gaul.s3proxy.S3Proxy;
import org.jclouds.ContextBuilder;
import org.jclouds.blobstore.BlobStoreContext;
import org.junit.rules.ExternalResource;

public class S3Rule
extends ExternalResource {
    public static final String IDENTITY = "identity";
    public static final String CREDENTIAL = "credential";
    public static final String REGION = "us-east-1";
    public static final String BUCKET = "bucket";
    public static String DEFAULT_URL = "http://127.0.0.1:5555";
    Properties properties = new Properties();
    S3Proxy s3Proxy;
    AmazonS3 s3client;
    String endpoint = DEFAULT_URL;
    String bucketName = "bucket";
    String directoryKeyPrefix = null;
    String inputPath;
    Supplier<String> storageDir;

    public S3Rule(Supplier<String> storageDir, String bucketName, String inputPath) {
        this(storageDir);
        this.bucketName = bucketName;
        this.inputPath = inputPath;
    }

    public S3Rule(Supplier<String> storageDir, String bucketName) {
        this(storageDir);
        this.bucketName = bucketName;
    }

    public S3Rule(Supplier<String> storageDir) {
        this.storageDir = storageDir;
    }

    public S3Rule(String storageDir) {
        this(() -> storageDir);
    }

    public S3Rule(String storageDir, String bucketName) {
        this(() -> storageDir);
        this.bucketName = bucketName;
    }

    public AmazonS3 get3Client() {
        if (this.s3client != null) {
            return this.s3client;
        }
        this.s3client = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().enablePathStyleAccess()).withClientConfiguration(new ClientConfiguration().withSignerOverride("S3SignerType"))).withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(IDENTITY, CREDENTIAL)))).withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.endpoint, REGION))).build();
        return this.s3client;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    protected void before() throws Throwable {
        this.properties.setProperty("jclouds.filesystem.basedir", this.storageDir.get());
        BlobStoreContext context = (BlobStoreContext)ContextBuilder.newBuilder((String)"filesystem").credentials(IDENTITY, CREDENTIAL).overrides(this.properties).build(BlobStoreContext.class);
        this.s3Proxy = S3Proxy.builder().blobStore(context.getBlobStore()).endpoint(URI.create(this.endpoint)).build();
        this.s3Proxy.start();
        this.uploadData(this.inputPath);
    }

    public void uploadData(String inputPath) throws InterruptedException {
        if (inputPath == null) {
            return;
        }
        this.createBucket(this.bucketName);
        TransferManager transferManager = TransferManagerBuilder.standard().withS3Client(this.get3Client()).build();
        MultipleFileUpload upload = transferManager.uploadDirectory(this.bucketName, this.directoryKeyPrefix, new File(inputPath), true);
        upload.waitForCompletion();
    }

    public void createBucket(String bucketName) {
        AmazonS3 client = this.get3Client();
        if (client.doesBucketExist(bucketName)) {
            return;
        }
        client.createBucket(bucketName);
    }

    protected void after() {
        try {
            if (this.s3Proxy != null) {
                this.s3Proxy.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

