/*
 * Decompiled with CFR 0.152.
 */
package cascading.local.tap.aws.s3;

import cascading.CascadingTestCase;
import cascading.flow.FlowProcess;
import cascading.local.tap.aws.s3.S3Checkpointer;
import cascading.local.tap.aws.s3.S3FileCheckpointer;
import cascading.local.tap.aws.s3.S3Tap;
import cascading.local.util.S3Rule;
import cascading.scheme.Scheme;
import cascading.scheme.local.TextDelimited;
import cascading.scheme.local.TextLine;
import cascading.tap.Tap;
import cascading.tap.local.PartitionTap;
import cascading.tap.partition.DelimitedPartition;
import cascading.tap.partition.Partition;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntryCollector;
import cascading.tuple.TupleStream;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.SecureRandom;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.junit.Rule;
import org.junit.Test;

public class S3TapTest
extends CascadingTestCase {
    private final String bucketName = "bucket";
    @Rule
    public S3Rule s3Rule = new S3Rule(() -> ((S3TapTest)this).getOutputPath());

    @Test
    public void writeRead() throws Exception {
        String key = "write-read/";
        TextDelimited textDelimited = new TextDelimited(new Fields((Comparable)((Object)"value"), Integer.TYPE));
        int totalItems = 100;
        for (int i = 0; i < totalItems; ++i) {
            S3Tap output = new S3Tap((Scheme)textDelimited, this.s3Rule.get3Client(), "bucket", key + i);
            try (TupleEntryCollector collector = output.openForWrite(FlowProcess.nullFlowProcess());){
                collector.add(new Tuple(new Object[]{i}));
                continue;
            }
        }
        S3Tap tap = new S3Tap((Scheme)textDelimited, this.s3Rule.get3Client(), "bucket", key);
        String[] childIdentifiers = tap.getChildIdentifiers(FlowProcess.nullFlowProcess(), Integer.MAX_VALUE, false);
        S3TapTest.assertEquals((int)totalItems, (int)childIdentifiers.length);
        S3TapTest.assertTrue((!childIdentifiers[0].startsWith(key) ? 1 : 0) != 0);
        childIdentifiers = tap.getChildIdentifiers(FlowProcess.nullFlowProcess(), Integer.MAX_VALUE, true);
        S3TapTest.assertNotSame((Object)0, (Object)childIdentifiers.length);
        S3TapTest.assertTrue((boolean)childIdentifiers[0].contains(key));
        int sum = TupleStream.tupleStream((Tap)tap, (FlowProcess)FlowProcess.nullFlowProcess()).mapToInt(t -> t.getInteger(0)).sum();
        S3TapTest.assertEquals((int)IntStream.range(0, totalItems).sum(), (int)sum);
    }

    @Test
    public void writeReadPartitioned() throws Exception {
        String key = "write-read-partitioned/";
        TextDelimited textDelimited = new TextDelimited(new Fields(new Comparable[]{"char", "value"}).applyTypes(new Type[]{String.class, Integer.TYPE}));
        int totalItems = 100;
        for (int i = 0; i < totalItems; ++i) {
            S3Tap output = new S3Tap((Scheme)textDelimited, this.s3Rule.get3Client(), "bucket", key + i);
            output = new PartitionTap((Tap)output, (Partition)new DelimitedPartition(new Fields(new Comparable[]{"char"}), "/"));
            try (TupleEntryCollector collector = output.openForWrite(FlowProcess.nullFlowProcess());){
                collector.add(new Tuple(new Object[]{Character.toString((char)(97 + i)), i}));
                continue;
            }
        }
        S3Tap tap = new S3Tap((Scheme)textDelimited, this.s3Rule.get3Client(), "bucket", key);
        String[] childIdentifiers = tap.getChildIdentifiers(FlowProcess.nullFlowProcess(), Integer.MAX_VALUE, false);
        S3TapTest.assertEquals((int)totalItems, (int)childIdentifiers.length);
        S3TapTest.assertTrue((!childIdentifiers[0].startsWith(key) ? 1 : 0) != 0);
        childIdentifiers = tap.getChildIdentifiers(FlowProcess.nullFlowProcess(), Integer.MAX_VALUE, true);
        S3TapTest.assertNotSame((Object)0, (Object)childIdentifiers.length);
        S3TapTest.assertTrue((boolean)childIdentifiers[0].contains(key));
        int sum = TupleStream.tupleStream((Tap)tap, (FlowProcess)FlowProcess.nullFlowProcess()).mapToInt(t -> t.getInteger(1)).sum();
        S3TapTest.assertEquals((int)IntStream.range(0, totalItems).sum(), (int)sum);
    }

    @Test
    public void readS3Glob() throws Exception {
        String key = "glob/";
        TextLine textLine = new TextLine(new Fields(new Comparable[]{"line"}));
        TextLine jsonLine = new TextLine(new Fields(new Comparable[]{"line"})){

            protected String getBaseFileExtension() {
                return "json";
            }
        };
        for (int i = 0; i < 100; ++i) {
            S3Tap output = new S3Tap((Scheme)(i % 2 == 0 ? textLine : jsonLine), this.s3Rule.get3Client(), "bucket", key + "foo/bar/" + i);
            try (TupleEntryCollector collector = output.openForWrite(FlowProcess.nullFlowProcess());){
                collector.add(new Tuple(new Object[]{i}));
                continue;
            }
        }
        S3Tap tap = new S3Tap((Scheme)textLine, this.s3Rule.get3Client(), S3Tap.makeURI((String)"bucket", (String)key, (String)"**/*.txt"));
        String[] childIdentifiers = tap.getChildIdentifiers(FlowProcess.nullFlowProcess(), Integer.MAX_VALUE, true);
        S3TapTest.assertEquals((int)50, (int)childIdentifiers.length);
        for (String childIdentifier : childIdentifiers) {
            S3TapTest.assertTrue((boolean)childIdentifier.contains("/foo/bar/"));
            S3TapTest.assertTrue((boolean)childIdentifier.endsWith(".txt"));
        }
    }

    @Test
    public void writeReadMark() throws Exception {
        String key = "write-read-checkpoint/";
        TextDelimited textLine = new TextDelimited(new Fields((Comparable)((Object)"value"), Integer.TYPE));
        int totalItems = 100;
        for (int i = 0; i < totalItems; ++i) {
            S3Tap output = new S3Tap((Scheme)textLine, this.s3Rule.get3Client(), "bucket", String.format("%s%04d", key, i));
            try (TupleEntryCollector collector = output.openForWrite(FlowProcess.nullFlowProcess());){
                collector.add(new Tuple(new Object[]{i}));
                continue;
            }
        }
        TestS3Checkpoint checkpoint = new TestS3Checkpoint("write-read-checkpoint/0050.txt");
        S3Tap tap = new S3Tap((Scheme)textLine, this.s3Rule.get3Client(), (S3Checkpointer)checkpoint, "bucket", key);
        String[] childIdentifiers = tap.getChildIdentifiers(FlowProcess.nullFlowProcess(), Integer.MAX_VALUE, false);
        S3TapTest.assertEquals((int)49, (int)childIdentifiers.length);
        S3TapTest.assertTrue((!childIdentifiers[0].startsWith(key) ? 1 : 0) != 0);
        try (Stream tupleStream = TupleStream.tupleStream((Tap)tap, (FlowProcess)FlowProcess.nullFlowProcess());){
            int sum = tupleStream.mapToInt(t -> t.getInteger(0)).sum();
            S3TapTest.assertEquals((int)IntStream.range(51, 100).sum(), (int)sum);
        }
        S3TapTest.assertEquals((String)"write-read-checkpoint/0099.txt", (String)checkpoint.key);
        S3TapTest.assertTrue((boolean)checkpoint.committed);
    }

    @Test
    public void writeReadMarkOnDisk() throws Exception {
        Throwable throwable;
        String key = "write-read-checkpoint-disk/";
        TextDelimited textLine = new TextDelimited(new Fields((Comparable)((Object)"value"), Integer.TYPE));
        int totalItems = 100;
        for (int i = 0; i < totalItems; ++i) {
            S3Tap output = new S3Tap((Scheme)textLine, this.s3Rule.get3Client(), "bucket", String.format("%s%04d", key, i));
            throwable = null;
            try (TupleEntryCollector collector = output.openForWrite(FlowProcess.nullFlowProcess());){
                collector.add(new Tuple(new Object[]{i}));
                continue;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        Path path = Paths.get(this.getOutputPath(), new String[0]).resolve("checkpoints-" + SecureRandom.getInstanceStrong().nextInt());
        S3Tap tap = new S3Tap((Scheme)textLine, this.s3Rule.get3Client(), (S3Checkpointer)new S3FileCheckpointer(path), "bucket", key);
        throwable = null;
        try (Stream tupleStream = TupleStream.tupleStream((Tap)tap, (FlowProcess)FlowProcess.nullFlowProcess());){
            int sum = tupleStream.limit(10L).mapToInt(t -> t.getInteger(0)).sum();
            S3TapTest.assertEquals((int)IntStream.range(0, 10).sum(), (int)sum);
        }
        catch (Throwable sum) {
            throwable = sum;
            throw sum;
        }
        tap = new S3Tap((Scheme)textLine, this.s3Rule.get3Client(), (S3Checkpointer)new S3FileCheckpointer(path), "bucket", key);
        tupleStream = TupleStream.tupleStream((Tap)tap, (FlowProcess)FlowProcess.nullFlowProcess());
        throwable = null;
        try {
            int sum = tupleStream.mapToInt(t -> t.getInteger(0)).sum();
            S3TapTest.assertEquals((int)IntStream.range(10, 100).sum(), (int)sum);
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        finally {
            if (tupleStream != null) {
                if (throwable != null) {
                    try {
                        tupleStream.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    tupleStream.close();
                }
            }
        }
    }

    public static class TestS3Checkpoint
    implements S3Checkpointer {
        public String key;
        public boolean committed = false;

        public TestS3Checkpoint(String key) {
            this.key = key;
        }

        public String getLastKey(String bucketName) {
            return this.key;
        }

        public void setLastKey(String bucketName, String key) {
            this.key = key;
        }

        public void commit() {
            this.committed = true;
        }
    }
}

