/*
 * Decompiled with CFR 0.152.
 */
package cascading.local.tap.neo4j;

import cascading.flow.FlowProcess;
import cascading.local.tap.neo4j.JSONGraphSpec;
import cascading.local.tap.neo4j.Neo4jIntegrationTestCase;
import cascading.local.tap.neo4j.Neo4jJSONScheme;
import cascading.local.tap.neo4j.Neo4jScheme;
import cascading.local.tap.neo4j.Neo4jTap;
import cascading.nested.json.JSONCoercibleType;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntryCollector;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.driver.v1.Driver;
import org.neo4j.driver.v1.GraphDatabase;
import org.neo4j.driver.v1.Session;

public class Neo4jTapIntegrationTest
extends Neo4jIntegrationTestCase {
    public static String[] values = new String[]{"{\"trace_id\":\"e2366267f86db8f4\", \"parent_id\": 1, \"id\": 2, \"description\":\"Perform needs analysis\", \"tag\":{\"duration\":10}}", "{\"trace_id\":\"e2366267f86db8f4\", \"parent_id\": 2, \"id\": 3, \"description\":\"Perform dependency analysis\", \"annotations\":[{\"timestamp\":1548968531962000,\"value\":\"ws\"},{\"timestamp\":1548968531963000,\"value\":\"wr\"}], \"tag\":{\"duration\":10}}", "{\"trace_id\":\"e2366267f86db8f4\", \"id\": 1, \"description\":\"Start\", \"tag\":{\"duration\":0, \"earliest_start\":0, \"earliest_finish\":0, \"latest_start\":0, \"latest_finish\":0}}", "{\"trace_id\":\"e2366267f86db8f4\", \"parent_id\": 3, \"id\": 4, \"description\":\"More analysis\", \"tag\":{\"role/version\": \"1.1.0\"}}"};

    @Test
    public void write() throws Exception {
        Integer result;
        URI uri = URI.create("bolt://" + this.getContainerHost());
        Properties properties = new Properties();
        JSONGraphSpec graphSpec = new JSONGraphSpec("Span");
        graphSpec.addProperty("id", "/id", null);
        graphSpec.addEdge("TRACE").addTargetLabel("Trace").addTargetProperty("trace_id", "/trace_id", null);
        graphSpec.addEdge("PARENT").addTargetLabel("Span").addTargetProperty("id", "/parent_id", null);
        Fields json = new Fields((Comparable)((Object)"json"), (Type)JSONCoercibleType.TYPE);
        Neo4jJSONScheme scheme = new Neo4jJSONScheme(json, graphSpec);
        Neo4jTap output = new Neo4jTap(properties, (Neo4jScheme)scheme, uri);
        try (TupleEntryCollector collector = output.openForWrite(FlowProcess.nullFlowProcess());){
            for (String value : values) {
                collector.add(new Tuple(new Object[]{JSONCoercibleType.TYPE.canonical((Object)value)}));
            }
        }
        Driver driver = GraphDatabase.driver((URI)uri);
        try (Session session = driver.session();){
            result = (Integer)session.writeTransaction(tx -> tx.run("match (n:Span) return count(n)").single().get(0).asInt());
        }
        Assert.assertEquals((long)4L, (long)result.intValue());
        session = driver.session();
        var10_13 = null;
        try {
            result = (Integer)session.writeTransaction(tx -> tx.run("match (n:Trace) return count(n)").single().get(0).asInt());
        }
        catch (Throwable throwable) {
            var10_13 = throwable;
            throw throwable;
        }
        finally {
            if (session != null) {
                if (var10_13 != null) {
                    try {
                        session.close();
                    }
                    catch (Throwable throwable) {
                        var10_13.addSuppressed(throwable);
                    }
                } else {
                    session.close();
                }
            }
        }
        Assert.assertEquals((long)1L, (long)result.intValue());
    }
}

