/*
 * Decompiled with CFR 0.152.
 */
package cascading.local.tap.neo4j;

import java.time.Duration;
import java.util.function.Consumer;
import org.junit.ClassRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;

public abstract class Neo4jIntegrationTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(Neo4jIntegrationTestCase.class);
    public static final int PORTAL_PORT = 7474;
    public static final int BOLT_PORT = 7687;
    @ClassRule
    public static GenericContainer neo4jRule = new GenericContainer("neo4j:3.5.2").withExposedPorts(new Integer[]{7474, 7687}).withLogConsumer((Consumer)new Slf4jLogConsumer(LOG)).withEnv("NEO4J_AUTH", "none").withStartupTimeout(Duration.ofMinutes(3L));

    protected String getContainerHost() {
        return String.format("%s:%d", neo4jRule.getContainerIpAddress(), neo4jRule.getMappedPort(7687));
    }
}

