/*
 * Decompiled with CFR 0.152.
 */
package cascading.local.tap.kafka.commit;

import cascading.local.tap.kafka.commit.CommitListener;
import cascading.local.tap.kafka.decorator.ForwardingConsumerRebalanceListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;

public class CommittingRebalanceListener<K, V>
extends ForwardingConsumerRebalanceListener {
    Consumer<K, V> consumer;
    CommitListener commitListener;
    Map<TopicPartition, OffsetAndMetadata> currentOffsets;

    public CommittingRebalanceListener(Consumer<K, V> consumer, CommitListener commitListener, Map<TopicPartition, OffsetAndMetadata> currentOffsets) {
        this.consumer = consumer;
        this.commitListener = commitListener;
        this.currentOffsets = currentOffsets;
    }

    public CommittingRebalanceListener(ConsumerRebalanceListener listener, Consumer<K, V> consumer, CommitListener commitListener, Map<TopicPartition, OffsetAndMetadata> currentOffsets) {
        super(listener);
        this.consumer = consumer;
        this.commitListener = commitListener;
        this.currentOffsets = currentOffsets;
    }

    @Override
    public void onPartitionsRevoked(Collection<TopicPartition> collection) {
        super.onPartitionsRevoked(collection);
        HashMap<TopicPartition, OffsetAndMetadata> revoked = new HashMap<TopicPartition, OffsetAndMetadata>();
        for (TopicPartition topicPartition : collection) {
            OffsetAndMetadata removed = this.currentOffsets.remove(topicPartition);
            if (removed == null) continue;
            revoked.put(topicPartition, removed);
        }
        this.commitListener.onRevoke(this.consumer, revoked);
        try {
            this.consumer.commitSync(revoked);
        }
        catch (RuntimeException exception) {
            if (this.commitListener.onFail(this.consumer, exception, revoked)) {
                throw exception;
            }
            this.currentOffsets.putAll(revoked);
        }
    }
}

