/*
 * Decompiled with CFR 0.152.
 */
package cascading.local.tap.kafka.commit;

import java.util.Iterator;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;

public class OffsetRecorderIterator<K, V>
implements Iterator<ConsumerRecord<K, V>> {
    private final Map<TopicPartition, OffsetAndMetadata> currentOffsets;
    private final Iterator<ConsumerRecord<K, V>> iterator;
    private String topic;
    private int partition;
    private long offset;

    public OffsetRecorderIterator(Map<TopicPartition, OffsetAndMetadata> currentOffsets, Iterator<ConsumerRecord<K, V>> iterator) {
        this.currentOffsets = currentOffsets;
        this.iterator = iterator;
    }

    @Override
    public boolean hasNext() {
        boolean hasNext = this.iterator.hasNext();
        if (!hasNext) {
            this.addLastOffset();
        }
        return hasNext;
    }

    @Override
    public ConsumerRecord<K, V> next() {
        this.addLastOffset();
        ConsumerRecord<K, V> next = this.iterator.next();
        this.topic = next.topic();
        this.partition = next.partition();
        this.offset = next.offset();
        return next;
    }

    private void addLastOffset() {
        if (this.topic == null) {
            return;
        }
        this.currentOffsets.put(new TopicPartition(this.topic, this.partition), new OffsetAndMetadata(this.offset + 1L));
    }
}

