/*
 * Decompiled with CFR 0.152.
 */
package cascading;

import cascading.PlatformTestCase;
import cascading.flow.Flow;
import cascading.flow.local.LocalFlowConnector;
import cascading.pipe.Pipe;
import cascading.platform.PlatformRunner;
import cascading.platform.hadoop2.Hadoop2MR1Platform;
import cascading.scheme.Scheme;
import cascading.scheme.hadoop.TextDelimited;
import cascading.scheme.hadoop.TextLine;
import cascading.tap.MultiSourceTap;
import cascading.tap.SinkMode;
import cascading.tap.Tap;
import cascading.tap.hadoop.Hfs;
import cascading.tap.hadoop.PartitionTap;
import cascading.tap.local.FileTap;
import cascading.tap.local.hadoop.LocalHfsAdaptor;
import cascading.tap.partition.DelimitedPartition;
import cascading.tap.partition.Partition;
import cascading.tuple.Fields;
import data.InputData;
import org.junit.Test;

@PlatformRunner.Platform(value={Hadoop2MR1Platform.class})
public class HadoopAdapterTapPlatformTest
extends PlatformTestCase {
    public HadoopAdapterTapPlatformTest() {
        super(true, 5, 3);
    }

    @Test
    public void testWriteReadHDFS() throws Exception {
        this.copyFromLocal(InputData.inputFileApache);
        FileTap source = new FileTap((Scheme)new cascading.scheme.local.TextLine(new Fields(new Comparable[]{"offset", "line"})), InputData.inputFileApache);
        LocalHfsAdaptor intermediate = new LocalHfsAdaptor((Tap)new Hfs((Scheme)new TextLine(), this.getOutputPath("/intermediate"), SinkMode.REPLACE));
        FileTap sink = new FileTap((Scheme)new cascading.scheme.local.TextLine(), this.getOutputPath("/final"), SinkMode.REPLACE);
        Pipe pipe = new Pipe("test");
        Flow first = new LocalFlowConnector(this.getPlatform().getProperties()).connect((Tap)source, (Tap)intermediate, pipe);
        first.complete();
        HadoopAdapterTapPlatformTest.validateLength((Flow)first, (int)10);
        Flow second = new LocalFlowConnector(this.getPlatform().getProperties()).connect((Tap)intermediate, (Tap)sink, pipe);
        second.complete();
        HadoopAdapterTapPlatformTest.validateLength((Flow)second, (int)10);
    }

    @Test
    public void testWriteReadHDFSMultiSource() throws Exception {
        this.copyFromLocal(InputData.inputFileApache);
        MultiSourceTap source = new MultiSourceTap(new Tap[]{new FileTap((Scheme)new cascading.scheme.local.TextLine(new Fields(new Comparable[]{"offset", "line"})), InputData.inputFileApache), new FileTap((Scheme)new cascading.scheme.local.TextLine(new Fields(new Comparable[]{"offset", "line"})), InputData.inputFileApache)});
        LocalHfsAdaptor intermediate = new LocalHfsAdaptor((Tap)new Hfs((Scheme)new TextLine(), this.getOutputPath("/intermediate"), SinkMode.REPLACE));
        FileTap sink = new FileTap((Scheme)new cascading.scheme.local.TextLine(), this.getOutputPath("/final"), SinkMode.REPLACE);
        Pipe pipe = new Pipe("test");
        Flow first = new LocalFlowConnector(this.getPlatform().getProperties()).connect((Tap)source, (Tap)intermediate, pipe);
        first.complete();
        HadoopAdapterTapPlatformTest.validateLength((Flow)first, (int)20);
        Flow second = new LocalFlowConnector(this.getPlatform().getProperties()).connect((Tap)intermediate, (Tap)sink, pipe);
        second.complete();
        HadoopAdapterTapPlatformTest.validateLength((Flow)second, (int)20);
    }

    @Test
    public void testPartitionedWriteReadHDFS() throws Exception {
        this.copyFromLocal(InputData.inputFileLhs);
        FileTap source = new FileTap((Scheme)new cascading.scheme.local.TextDelimited(new Fields(new Comparable[]{"num", "char"}), " "), InputData.inputFileLhs);
        Hfs original = new Hfs((Scheme)new TextDelimited(new Fields(new Comparable[]{"num", "char"}), " "), this.getOutputPath("/intermediate"), SinkMode.REPLACE);
        LocalHfsAdaptor intermediate = new LocalHfsAdaptor((Tap)new PartitionTap(original, (Partition)new DelimitedPartition(new Fields(new Comparable[]{"num"}), "/")));
        FileTap sink = new FileTap((Scheme)new cascading.scheme.local.TextDelimited(new Fields(new Comparable[]{"num", "char"}), " "), this.getOutputPath("/final"), SinkMode.REPLACE);
        Pipe pipe = new Pipe("test");
        Flow first = new LocalFlowConnector(this.getPlatform().getProperties()).connect((Tap)source, (Tap)intermediate, pipe);
        first.complete();
        HadoopAdapterTapPlatformTest.validateLength((Flow)first, (int)13);
        Flow second = new LocalFlowConnector(this.getPlatform().getProperties()).connect((Tap)intermediate, (Tap)sink, pipe);
        second.complete();
        HadoopAdapterTapPlatformTest.validateLength((Flow)second, (int)13);
    }
}

