/*
 * Decompiled with CFR 0.152.
 */
package cascading.stats.tez.util;

import cascading.CascadingException;
import cascading.flow.hadoop.util.HadoopUtil;
import cascading.flow.planner.PlatformInfo;
import cascading.stats.tez.util.TezTimelineClient;
import cascading.util.Util;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Set;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.tez.client.FrameworkClient;
import org.apache.tez.client.TezClient;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.client.DAGClient;
import org.apache.tez.dag.api.client.DAGStatus;
import org.apache.tez.dag.api.client.StatusGetOpts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TezStatsUtil {
    private static final Logger LOG = LoggerFactory.getLogger(TezStatsUtil.class);
    public static final Set<StatusGetOpts> STATUS_GET_COUNTERS = EnumSet.of(StatusGetOpts.GET_COUNTERS);
    static Class<DAGClient> timelineClientClass = null;
    public static final String TIMELINE_CLIENT_CLASS = "cascading.stats.tez.util.TezTimelineClient";

    public static String getPlatformVersion() {
        PlatformInfo tez = HadoopUtil.getPlatformInfo(DAG.class, null, (String)"Tez");
        if (tez == null || tez.version == null) {
            return "unknown";
        }
        return tez.version;
    }

    private static boolean loadClass() {
        if (timelineClientClass != null) {
            return true;
        }
        try {
            timelineClientClass = Thread.currentThread().getContextClassLoader().loadClass(TIMELINE_CLIENT_CLASS);
            return true;
        }
        catch (ClassNotFoundException exception) {
            LOG.error("'yarn.timeline-service.enabled' is enabled, yet unable to load Tez YARN timeline client class: {}, ensure these dependencies are in your local CLASSPATH: tez-yarn-timeline-history, org.apache.tez:tez-yarn-timeline-history or org.apache.tez:tez-yarn-timeline-history-with-acls", (Object)TIMELINE_CLIENT_CLASS, (Object)exception);
            return false;
        }
    }

    public static DAGStatus getDagStatusWithCounters(DAGClient dagClient) {
        if (dagClient == null) {
            return null;
        }
        try {
            return dagClient.getDAGStatus(STATUS_GET_COUNTERS);
        }
        catch (IOException | TezException exception) {
            throw new CascadingException("unable to get counters from dag client", exception);
        }
    }

    public static DAGClient createTimelineClient(DAGClient dagClient) {
        if (dagClient == null) {
            return null;
        }
        if (!TezStatsUtil.loadClass()) {
            return null;
        }
        Class[] types = new Class[]{ApplicationId.class, String.class, TezConfiguration.class, FrameworkClient.class, DAGClient.class};
        ApplicationId appId = (ApplicationId)Util.returnInstanceFieldIfExistsSafe((Object)dagClient, (String)"appId");
        String dagId = (String)Util.returnInstanceFieldIfExistsSafe((Object)dagClient, (String)"dagId");
        TezConfiguration conf = (TezConfiguration)Util.returnInstanceFieldIfExistsSafe((Object)dagClient, (String)"conf");
        FrameworkClient frameworkClient = (FrameworkClient)Util.returnInstanceFieldIfExistsSafe((Object)dagClient, (String)"frameworkClient");
        Object[] parameters = new Object[]{appId, dagId, conf, frameworkClient, dagClient};
        try {
            return (DAGClient)Util.invokeConstructor(timelineClientClass, (Object[])parameters, (Class[])types);
        }
        catch (CascadingException exception) {
            Throwable cause = exception.getCause();
            if (cause instanceof ReflectiveOperationException && cause.getCause() instanceof TezException) {
                LOG.warn("unable to construct timeline server client", cause.getCause());
            } else if (cause instanceof ReflectiveOperationException && cause.getCause() instanceof NoSuchMethodError) {
                LOG.warn("unable to construct timeline server client, check for compatible Tez version, current: {}", (Object)TezStatsUtil.getPlatformVersion(), (Object)cause.getCause());
            } else {
                LOG.warn("unable to construct timeline server client", (Throwable)exception);
            }
            return null;
        }
    }

    public static String getTrackingURL(TezClient tezClient, DAGClient dagClient) {
        if (tezClient == null || dagClient == null) {
            return null;
        }
        try {
            ApplicationId applicationId = tezClient.getAppMasterApplicationId();
            FrameworkClient frameworkClient = TezStatsUtil.getFrameworkClient(dagClient);
            if (frameworkClient == null) {
                LOG.info("unable to get framework client");
                return null;
            }
            ApplicationReport report = frameworkClient.getApplicationReport(applicationId);
            if (report != null) {
                return report.getTrackingUrl();
            }
        }
        catch (IOException | YarnException exception) {
            LOG.info("unable to get tracking url");
            LOG.debug("exception retrieving application report", exception);
        }
        return null;
    }

    private static FrameworkClient getFrameworkClient(DAGClient dagClient) {
        if (dagClient instanceof TezTimelineClient) {
            return ((TezTimelineClient)dagClient).getFrameworkClient();
        }
        return (FrameworkClient)Util.returnInstanceFieldIfExistsSafe((Object)dagClient, (String)"frameworkClient");
    }
}

