/*
 * Decompiled with CFR 0.152.
 */
package cascading.stats.tez;

import cascading.stats.CascadingStats;
import cascading.stats.FlowSliceStats;
import cascading.stats.ProvidesCounters;
import cascading.stats.tez.TezNodeStats;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class TezSliceStats
extends FlowSliceStats<TezNodeStats.Kind>
implements ProvidesCounters {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private String id;
    private TezNodeStats.Kind kind;
    private final CascadingStats.Status parentStatus;
    private CascadingStats.Status status;
    private long submitTime;
    private long startTime;
    private long finishTime;
    private String successfulAttemptID;
    private String diagnostics;
    private String vertexID;
    private String taskID;
    private long lastFetch = -1L;
    private Map<String, Map<String, Long>> counters = Collections.emptyMap();
    private Map<Integer, FlowSliceStats.FlowSliceAttempt> attempts = new HashMap<Integer, FlowSliceStats.FlowSliceAttempt>();

    TezSliceStats(String id, TezNodeStats.Kind kind, CascadingStats.Status parentStatus, String vertexID, String taskID) {
        this.id = id;
        this.kind = kind;
        this.parentStatus = parentStatus;
        this.vertexID = vertexID;
        this.taskID = taskID;
    }

    public void setSubmitTime(long submitTime) {
        this.submitTime = submitTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public void setFinishTime(long finishTime) {
        this.finishTime = finishTime;
    }

    public void setSuccessfulAttemptID(String successfulAttemptID) {
        this.successfulAttemptID = successfulAttemptID;
    }

    public String getID() {
        return this.id;
    }

    public long getProcessStartTime() {
        return this.submitTime;
    }

    public long getProcessRunTime() {
        return this.startTime;
    }

    public long getProcessFinishTime() {
        return this.finishTime;
    }

    public void setDiagnostics(String diagnostics) {
        this.diagnostics = diagnostics;
    }

    public CascadingStats.Status getParentStatus() {
        return this.parentStatus;
    }

    protected void setStatus(@Nullable CascadingStats.Status status) {
        if (status != null) {
            this.status = status;
        }
    }

    public CascadingStats.Status getStatus() {
        return this.status;
    }

    public TezNodeStats.Kind getKind() {
        return this.kind;
    }

    public String[] getDiagnostics() {
        if (this.diagnostics == null) {
            return new String[0];
        }
        return this.diagnostics.split(LINE_SEPARATOR);
    }

    public Map<String, Map<String, Long>> getCounters() {
        return this.counters;
    }

    public String getProcessSliceID() {
        return this.taskID;
    }

    public String getProcessNodeID() {
        return this.vertexID;
    }

    public String getProcessStepID() {
        return null;
    }

    public String getProcessStatus() {
        return null;
    }

    public float getProcessProgress() {
        return 0.0f;
    }

    public Map<Integer, FlowSliceStats.FlowSliceAttempt> getAttempts() {
        return this.attempts;
    }

    public void setCounters(@Nullable Map<String, Map<String, Long>> counters) {
        if (counters != null) {
            this.counters = counters;
        }
    }

    public void setLastFetch(long lastFetch) {
        this.lastFetch = lastFetch;
    }

    public long getLastSuccessfulCounterFetchTime() {
        return this.lastFetch;
    }

    public Collection<String> getCounterGroups() {
        return this.getCounters().keySet();
    }

    public Collection<String> getCountersFor(String group) {
        return this.getCounters().get(group).keySet();
    }

    public Collection<String> getCountersFor(Class<? extends Enum> group) {
        return this.getCountersFor(group.getDeclaringClass().getName());
    }

    public long getCounterValue(Enum counter) {
        return this.getCounterValue(counter.getDeclaringClass().getName(), counter.name());
    }

    public long getCounterValue(String group, String name) {
        if (this.getCounters() == null || this.getCounters().get(group) == null) {
            return 0L;
        }
        Long value = this.getCounters().get(group).get(name);
        if (value == null) {
            return 0L;
        }
        return value;
    }

    public void addAttempt(Object event) {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TezSliceStats");
        sb.append("{id='").append(this.id).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public static class TezAttempt
    extends FlowSliceStats.FlowSliceAttempt {
        public String getProcessAttemptID() {
            return null;
        }

        public int getEventId() {
            return 0;
        }

        public int getProcessDuration() {
            return 0;
        }

        public String getProcessStatus() {
            return null;
        }

        public String getStatusURL() {
            return null;
        }

        public CascadingStats.Status getStatus() {
            return null;
        }

        public String getProcessHostname() {
            return null;
        }
    }
}

