/*
 * Decompiled with CFR 0.152.
 */
package cascading.stats.tez;

import cascading.CascadingException;
import cascading.flow.FlowNode;
import cascading.flow.hadoop.util.HadoopUtil;
import cascading.flow.stream.annotations.StreamMode;
import cascading.management.state.ClientState;
import cascading.property.PropertyUtil;
import cascading.stats.BaseCachedNodeStats;
import cascading.stats.BaseCachedStepStats;
import cascading.stats.CascadingStats;
import cascading.stats.FlowSliceStats;
import cascading.stats.tez.TezCounterCache;
import cascading.stats.tez.TezSliceStats;
import cascading.stats.tez.util.TaskStatus;
import cascading.stats.tez.util.TezStatsUtil;
import cascading.stats.tez.util.TimelineClient;
import cascading.tap.Tap;
import cascading.util.Util;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.client.DAGClient;
import org.apache.tez.dag.api.client.Progress;
import org.apache.tez.dag.api.client.StatusGetOpts;
import org.apache.tez.dag.api.client.VertexStatus;
import org.apache.tez.dag.api.oldrecords.TaskState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TezNodeStats
extends BaseCachedNodeStats<Configuration, DAGClient, TezCounters> {
    private static final Logger LOG = LoggerFactory.getLogger(TezNodeStats.class);
    public static final String TIMELINE_FETCH_LIMIT = "cascading.stats.timeline.fetch.limit";
    public static final int DEFAULT_FETCH_LIMIT = 500;
    private static int fetchLimit = -1;
    private BaseCachedStepStats<Configuration, DAGClient, TezCounters> parentStepStats;
    private Kind kind;
    private String vertexID;
    private int totalTaskCount;
    private int succeededTaskCount;
    private int failedTaskCount;
    private int killedTaskCount;
    private int runningTaskCount;

    private static void setFetchLimit(Configuration configuration) {
        if (fetchLimit > -1) {
            return;
        }
        fetchLimit = PropertyUtil.getIntProperty((Map)HadoopUtil.createProperties((Configuration)configuration), (String)TIMELINE_FETCH_LIMIT, (int)500);
        if (fetchLimit < 2) {
            LOG.warn("property: {}, was set to: {}, may not be less than 2, setting to 2", (Object)TIMELINE_FETCH_LIMIT, (Object)fetchLimit);
            fetchLimit = 2;
        }
    }

    protected TezNodeStats(final BaseCachedStepStats<Configuration, DAGClient, TezCounters> parentStepStats, FlowNode flowNode, ClientState clientState, Configuration configuration) {
        super(flowNode, clientState);
        TezNodeStats.setFetchLimit(configuration);
        this.parentStepStats = parentStepStats;
        this.kind = this.getStreamedTaps(flowNode).isEmpty() ? Kind.PARTITIONED : Kind.SPLIT;
        this.counterCache = new TezCounterCache<DAGClient>((CascadingStats)this, configuration){

            protected DAGClient getJobStatusClient() {
                return (DAGClient)parentStepStats.getJobStatusClient();
            }

            protected TezCounters getCounters(DAGClient dagClient) throws IOException {
                VertexStatus vertexStatus = TezNodeStats.this.updateProgress(dagClient, TezStatsUtil.STATUS_GET_COUNTERS);
                if (vertexStatus == null) {
                    return null;
                }
                TezCounters vertexCounters = vertexStatus.getVertexCounters();
                if (vertexCounters == null) {
                    TezNodeStats.this.logWarn("could not retrieve vertex counters in stats status: {}, and vertex state: {}", new Object[]{TezNodeStats.this.getStatus(), vertexStatus.getState()});
                }
                return vertexCounters;
            }
        };
    }

    private Set<Tap> getStreamedTaps(FlowNode flowNode) {
        HashSet<Tap> taps = new HashSet<Tap>(flowNode.getSourceTaps());
        taps.remove(flowNode.getSourceElements((Enum)StreamMode.Accumulated));
        return taps;
    }

    public String getKind() {
        if (this.kind == null) {
            return null;
        }
        return this.kind.name();
    }

    private String retrieveVertexID(DAGClient dagClient) {
        if (this.vertexID != null || !(dagClient instanceof TimelineClient)) {
            return this.vertexID;
        }
        try {
            this.vertexID = ((TimelineClient)dagClient).getVertexID(this.getID());
        }
        catch (CascadingException | IOException | TezException exception) {
            this.logWarn("unable to get vertex id", new Object[]{exception});
        }
        return this.vertexID;
    }

    public int getTotalTaskCount() {
        return this.totalTaskCount;
    }

    public int getSucceededTaskCount() {
        return this.succeededTaskCount;
    }

    public int getFailedTaskCount() {
        return this.failedTaskCount;
    }

    public int getKilledTaskCount() {
        return this.killedTaskCount;
    }

    public int getRunningTaskCount() {
        return this.runningTaskCount;
    }

    protected boolean captureChildDetailInternal() {
        if (this.allChildrenFinished) {
            return true;
        }
        DAGClient dagClient = (DAGClient)this.parentStepStats.getJobStatusClient();
        if (dagClient == null) {
            return false;
        }
        if (dagClient instanceof TimelineClient) {
            return this.withTimelineServer((TimelineClient)dagClient);
        }
        return this.withoutTimelineServer(dagClient);
    }

    private boolean withTimelineServer(TimelineClient timelineClient) {
        this.updateProgress((DAGClient)timelineClient, null);
        if (this.getTotalTaskCount() == 0) {
            return false;
        }
        if (this.sliceStatsMap.size() == this.getTotalTaskCount()) {
            return this.updateAllTasks(timelineClient);
        }
        return this.fetchAllTasks(timelineClient);
    }

    private boolean updateAllTasks(TimelineClient timelineClient) {
        if (this.allChildrenFinished) {
            return true;
        }
        long startTime = System.currentTimeMillis();
        int count = 0;
        for (FlowSliceStats sliceStats : this.sliceStatsMap.values()) {
            if (sliceStats.getStatus().isFinished()) continue;
            TaskStatus taskStatus = this.getTaskStatusFor(timelineClient, sliceStats.getProcessSliceID());
            this.updateSliceWith((TezSliceStats)sliceStats, taskStatus, System.currentTimeMillis());
            ++count;
        }
        if (count == 0) {
            this.allChildrenFinished = true;
        }
        this.logInfo("updated {} slices in: {}", new Object[]{count, Util.formatDurationFromMillis((long)(System.currentTimeMillis() - startTime))});
        return this.sliceStatsMap.size() == this.getTotalTaskCount();
    }

    private boolean fetchAllTasks(TimelineClient timelineClient) {
        long startTime = System.currentTimeMillis();
        String fromTaskId = null;
        int startSize = this.sliceStatsMap.size();
        int iteration = 0;
        boolean continueIterating = true;
        boolean retrievedAreFinished = true;
        while (continueIterating && this.sliceStatsMap.size() != this.getTotalTaskCount()) {
            long lastFetch = System.currentTimeMillis();
            Iterator<TaskStatus> vertexChildren = this.getTaskStatusIterator(timelineClient, fromTaskId);
            if (vertexChildren == null) {
                return false;
            }
            int added = 0;
            int updated = 0;
            while (vertexChildren.hasNext()) {
                TaskStatus taskStatus = vertexChildren.next();
                fromTaskId = taskStatus.getTaskID();
                TezSliceStats sliceStats = (TezSliceStats)((Object)this.sliceStatsMap.get(fromTaskId));
                if (sliceStats == null) {
                    ++added;
                    sliceStats = new TezSliceStats(Util.createUniqueID(), this.kind, this.getStatus(), this.vertexID, fromTaskId);
                    this.sliceStatsMap.put(sliceStats.getProcessSliceID(), sliceStats);
                } else {
                    ++updated;
                }
                this.updateSliceWith(sliceStats, taskStatus, lastFetch);
                if (sliceStats.getStatus().isFinished()) continue;
                retrievedAreFinished = false;
            }
            int retrieved = added + updated;
            if (added == 0 && updated == 1) {
                continueIterating = false;
            } else {
                boolean bl = continueIterating = retrieved != 0;
            }
            if (!continueIterating) continue;
            this.logInfo("iteration retrieved: {}, added {}, updated {} slices in iteration: {}, fetch limit: {}", new Object[]{retrieved, added, updated, ++iteration, fetchLimit});
        }
        int total = this.sliceStatsMap.size();
        int added = total - startSize;
        int remaining = this.getTotalTaskCount() - total;
        String duration = Util.formatDurationFromMillis((long)(System.currentTimeMillis() - startTime));
        if (total == this.getTotalTaskCount() && retrievedAreFinished) {
            this.allChildrenFinished = true;
        }
        if (iteration == 0 && total == 0) {
            this.logInfo("no slices stats available yet, expecting: {}", new Object[]{remaining});
        } else {
            this.logInfo("added {} slices, in iterations: {}, with duration: {}, total fetched: {}, remaining: {}", new Object[]{added, iteration, duration, total, remaining});
        }
        return total == this.getTotalTaskCount();
    }

    private void updateSliceWith(TezSliceStats sliceStats, TaskStatus taskStatus, long lastFetch) {
        if (taskStatus == null) {
            return;
        }
        sliceStats.setStatus(this.getStatusForTaskStatus(taskStatus.getStatus()));
        sliceStats.setSubmitTime(taskStatus.getScheduledTime());
        sliceStats.setStartTime(taskStatus.getStartTime());
        sliceStats.setFinishTime(taskStatus.getEndTime());
        sliceStats.setDiagnostics(taskStatus.getDiagnostics());
        sliceStats.setSuccessfulAttemptID(taskStatus.getSuccessfulAttemptID());
        Map<String, Map<String, Long>> counters = taskStatus.getCounters();
        sliceStats.setCounters(counters);
        if (counters != null) {
            sliceStats.setLastFetch(lastFetch);
        }
    }

    private TaskStatus getTaskStatusFor(TimelineClient timelineClient, String taskID) {
        try {
            return timelineClient.getVertexChild(taskID);
        }
        catch (TezException exception) {
            this.logWarn("unable to get slice stat from timeline server for task id: {}", new Object[]{taskID, exception});
            return null;
        }
    }

    private Iterator<TaskStatus> getTaskStatusIterator(TimelineClient timelineClient, String startTaskID) {
        try {
            String vertexID = this.retrieveVertexID((DAGClient)timelineClient);
            if (vertexID == null) {
                this.logWarn("unable to get slice stats from timeline server, did not retrieve valid vertex id for vertex name: {}", new Object[]{this.getID()});
                return null;
            }
            return timelineClient.getVertexChildren(vertexID, fetchLimit, startTaskID);
        }
        catch (CascadingException | IOException | TezException exception) {
            this.logWarn("unable to get slice stats from timeline server", new Object[]{exception});
            return null;
        }
    }

    private boolean withoutTimelineServer(DAGClient dagClient) {
        int i;
        VertexStatus vertexStatus = this.updateProgress(dagClient, TezStatsUtil.STATUS_GET_COUNTERS);
        if (vertexStatus == null || this.getTotalTaskCount() == 0) {
            return false;
        }
        int total = this.sliceStatsMap.size();
        if (total == 0) {
            this.logWarn("'{}' is disabled, or running an incompatible Tez version: {}, task level counters cannot be retrieved", new Object[]{"yarn.timeline-service.enabled", TezStatsUtil.getPlatformVersion()});
        }
        for (int i2 = total; i2 < this.totalTaskCount; ++i2) {
            TezSliceStats sliceStats = new TezSliceStats(Util.createUniqueID(), this.kind, this.getStatus(), this.vertexID, null);
            this.sliceStatsMap.put(sliceStats.getID(), sliceStats);
        }
        Iterator iterator = this.sliceStatsMap.values().iterator();
        for (i = 0; i < this.runningTaskCount && iterator.hasNext(); ++i) {
            ((TezSliceStats)((Object)iterator.next())).setStatus(CascadingStats.Status.RUNNING);
        }
        for (i = 0; i < this.succeededTaskCount && iterator.hasNext(); ++i) {
            ((TezSliceStats)((Object)iterator.next())).setStatus(CascadingStats.Status.SUCCESSFUL);
        }
        for (i = 0; i < this.failedTaskCount && iterator.hasNext(); ++i) {
            ((TezSliceStats)((Object)iterator.next())).setStatus(CascadingStats.Status.FAILED);
        }
        for (i = 0; i < this.killedTaskCount && iterator.hasNext(); ++i) {
            ((TezSliceStats)((Object)iterator.next())).setStatus(CascadingStats.Status.STOPPED);
        }
        List diagnostics = vertexStatus.getDiagnostics();
        for (String diagnostic : diagnostics) {
            this.logInfo("vertex diagnostics: {}", new Object[]{diagnostic});
        }
        int finishedTaskCount = this.succeededTaskCount + this.failedTaskCount + this.killedTaskCount;
        this.allChildrenFinished = this.totalTaskCount == finishedTaskCount;
        return true;
    }

    private CascadingStats.Status getStatusForTaskStatus(@Nullable String status) {
        if (Util.isEmpty((String)status)) {
            return null;
        }
        TaskState state = TaskState.valueOf((String)status);
        switch (state) {
            case NEW: {
                return CascadingStats.Status.PENDING;
            }
            case SCHEDULED: {
                return CascadingStats.Status.SUBMITTED;
            }
            case RUNNING: {
                return CascadingStats.Status.RUNNING;
            }
            case SUCCEEDED: {
                return CascadingStats.Status.SUCCESSFUL;
            }
            case FAILED: {
                return CascadingStats.Status.FAILED;
            }
            case KILLED: {
                return CascadingStats.Status.STOPPED;
            }
        }
        return null;
    }

    private VertexStatus updateProgress(DAGClient dagClient, Set<StatusGetOpts> statusGetOpts) {
        VertexStatus vertexStatus = null;
        try {
            vertexStatus = dagClient.getVertexStatus(this.getID(), statusGetOpts);
        }
        catch (IOException | TezException exception) {
            this.logWarn("unable to get vertex status for: {}", new Object[]{this.getID(), exception});
        }
        if (vertexStatus == null) {
            return null;
        }
        Progress progress = vertexStatus.getProgress();
        this.totalTaskCount = progress.getTotalTaskCount();
        this.runningTaskCount = progress.getRunningTaskCount();
        this.succeededTaskCount = progress.getSucceededTaskCount();
        this.failedTaskCount = progress.getFailedTaskCount();
        this.killedTaskCount = progress.getKilledTaskCount();
        return vertexStatus;
    }

    public static enum Kind {
        SPLIT,
        PARTITIONED,
        UNKNOWN;

    }
}

