/*
 * Decompiled with CFR 0.152.
 */
package cascading.stats.tez;

import cascading.flow.FlowNode;
import cascading.flow.FlowStep;
import cascading.management.state.ClientState;
import cascading.stats.BaseCachedStepStats;
import cascading.stats.CascadingStats;
import cascading.stats.FlowNodeStats;
import cascading.stats.tez.TezCounterCache;
import cascading.stats.tez.TezNodeStats;
import cascading.stats.tez.util.TezStatsUtil;
import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.client.DAGClient;
import org.apache.tez.dag.api.client.DAGStatus;

public abstract class TezStepStats
extends BaseCachedStepStats<Configuration, DAGClient, TezCounters> {
    protected TezStepStats(FlowStep flowStep, ClientState clientState) {
        super(flowStep, clientState);
        Configuration config = (Configuration)flowStep.getConfig();
        this.counterCache = new TezCounterCache<DAGClient>((CascadingStats)this, config){

            protected DAGClient getJobStatusClient() {
                return (DAGClient)TezStepStats.this.getJobStatusClient();
            }

            protected TezCounters getCounters(DAGClient statusClient) throws IOException {
                TezCounters counters;
                DAGStatus dagStatus = TezStatsUtil.getDagStatusWithCounters(statusClient);
                if (dagStatus != null && (counters = dagStatus.getDAGCounters()) != null && counters.countCounters() != 0) {
                    return counters;
                }
                return null;
            }
        };
        Iterator iterator = flowStep.getFlowNodeGraph().getOrderedTopologicalIterator();
        while (iterator.hasNext()) {
            this.addNodeStats((FlowNodeStats)new TezNodeStats(this, (FlowNode)iterator.next(), clientState, config));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void captureDetail(CascadingStats.Type depth) {
        if (!this.getType().isChild(depth) || !this.isDetailStale()) {
            return;
        }
        DAGClient dagClient = (DAGClient)this.getJobStatusClient();
        if (dagClient == null) {
            return;
        }
        TezStepStats tezStepStats = this;
        synchronized (tezStepStats) {
            if (!this.isDetailStale()) {
                return;
            }
            for (FlowNodeStats flowNodeStats : this.getFlowNodeStatsMap().values()) {
                flowNodeStats.captureDetail(depth);
            }
            this.markDetailCaptured();
        }
    }
}

