/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.hadoop;

import cascading.CascadingTestCase;
import cascading.flow.FlowProcess;
import cascading.flow.hadoop.HadoopFlowProcess;
import cascading.tuple.Tuple;
import cascading.tuple.hadoop.TestSerialization;
import cascading.tuple.hadoop.TestText;
import cascading.tuple.hadoop.collect.HadoopSpillableTupleList;
import cascading.tuple.hadoop.collect.HadoopSpillableTupleMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.io.serializer.WritableSerialization;
import org.apache.hadoop.util.ReflectionUtils;
import org.junit.Test;

public class SpillableTupleHadoopTest
extends CascadingTestCase {
    @Test
    public void testSpillList() {
        long time = System.currentTimeMillis();
        this.performListTest(5, 50, null, 0);
        this.performListTest(49, 50, null, 0);
        this.performListTest(50, 50, null, 0);
        this.performListTest(51, 50, null, 1);
        this.performListTest(499, 50, null, 9);
        this.performListTest(500, 50, null, 9);
        this.performListTest(501, 50, null, 10);
        System.out.println("time = " + (System.currentTimeMillis() - time));
    }

    @Test
    public void testSpillListCompressed() {
        GzipCodec codec = (GzipCodec)ReflectionUtils.newInstance(GzipCodec.class, (Configuration)new Configuration());
        long time = System.currentTimeMillis();
        this.performListTest(5, 50, (CompressionCodec)codec, 0);
        this.performListTest(49, 50, (CompressionCodec)codec, 0);
        this.performListTest(50, 50, (CompressionCodec)codec, 0);
        this.performListTest(51, 50, (CompressionCodec)codec, 1);
        this.performListTest(499, 50, (CompressionCodec)codec, 9);
        this.performListTest(500, 50, (CompressionCodec)codec, 9);
        this.performListTest(501, 50, (CompressionCodec)codec, 10);
        System.out.println("time = " + (System.currentTimeMillis() - time));
    }

    private void performListTest(int size, int threshold, CompressionCodec codec, int spills) {
        int i;
        Configuration jobConf = new Configuration();
        jobConf.set("io.serializations", TestSerialization.class.getName() + "," + WritableSerialization.class.getName());
        jobConf.set("cascading.serialization.tokens", "1000=" + BooleanWritable.class.getName() + ",10001=" + Text.class.getName());
        HadoopSpillableTupleList list = new HadoopSpillableTupleList(threshold, codec, jobConf);
        for (i = 0; i < size; ++i) {
            String aString = "string number " + i;
            double random = Math.random();
            list.add(new Tuple(new Object[]{i, aString, random, new Text(aString), new TestText(aString), new Tuple(new Object[]{"inner tuple", new BytesWritable(aString.getBytes())})}));
        }
        SpillableTupleHadoopTest.assertEquals((String)"not equal: list.size();", (int)size, (int)list.size());
        SpillableTupleHadoopTest.assertEquals((String)"not equal: list.getNumFiles()", (int)spills, (int)list.spillCount());
        i = -1;
        int count = 0;
        for (Tuple tuple : list) {
            int value = tuple.getInteger(0);
            SpillableTupleHadoopTest.assertTrue((String)"wrong diff", (value - i == 1 ? 1 : 0) != 0);
            SpillableTupleHadoopTest.assertEquals((String)"wrong value", (String)("string number " + count), (String)tuple.getObject(3).toString());
            SpillableTupleHadoopTest.assertEquals((String)"wrong value", (String)("string number " + count), (String)tuple.getObject(4).toString());
            SpillableTupleHadoopTest.assertTrue((String)"wrong type", (boolean)(tuple.getObject(5) instanceof Tuple));
            BytesWritable bytesWritable = (BytesWritable)((Tuple)tuple.getObject(5)).getObject(1);
            byte[] bytes = bytesWritable.getBytes();
            String actual = new String(bytes, 0, bytesWritable.getLength());
            SpillableTupleHadoopTest.assertEquals((String)"wrong value", (String)("string number " + count), (String)actual);
            i = value;
            ++count;
        }
        SpillableTupleHadoopTest.assertEquals((String)"not equal: list.size();", (int)size, (int)count);
        Iterator iterator = list.iterator();
        SpillableTupleHadoopTest.assertEquals((String)"not equal: iterator.next().get(1)", (Object)"string number 0", (Object)((Tuple)iterator.next()).getObject(1));
        SpillableTupleHadoopTest.assertEquals((String)"not equal: iterator.next().get(1)", (Object)"string number 1", (Object)((Tuple)iterator.next()).getObject(1));
    }

    @Test
    public void testSpillMap() {
        long time = System.currentTimeMillis();
        Configuration jobConf = new Configuration();
        this.performMapTest(5, 5, 100, 20, jobConf);
        this.performMapTest(5, 50, 100, 20, jobConf);
        this.performMapTest(50, 5, 200, 20, jobConf);
        this.performMapTest(500, 50, 7000, 20, jobConf);
        System.out.println("time = " + (System.currentTimeMillis() - time));
    }

    @Test
    public void testSpillMapCompressed() {
        long time = System.currentTimeMillis();
        Configuration jobConf = new Configuration();
        jobConf.set("cascading.spill.codecs", "org.apache.hadoop.io.compress.GzipCodec");
        this.performMapTest(5, 5, 100, 20, jobConf);
        this.performMapTest(5, 50, 100, 20, jobConf);
        this.performMapTest(50, 5, 200, 20, jobConf);
        this.performMapTest(500, 50, 7000, 20, jobConf);
        System.out.println("time = " + (System.currentTimeMillis() - time));
    }

    private void performMapTest(int numKeys, int listSize, int mapThreshold, int listThreshold, Configuration jobConf) {
        jobConf.set("io.serializations", TestSerialization.class.getName() + "," + WritableSerialization.class.getName());
        jobConf.set("cascading.serialization.tokens", "1000=" + BooleanWritable.class.getName() + ",10001=" + Text.class.getName());
        HadoopFlowProcess flowProcess = new HadoopFlowProcess(jobConf);
        HadoopSpillableTupleMap map = new HadoopSpillableTupleMap(100000, 0.75f, mapThreshold, listThreshold, (FlowProcess)flowProcess);
        HashSet<Integer> keySet = new HashSet<Integer>();
        Random gen = new Random(1L);
        for (int i = 0; i < listSize * numKeys; ++i) {
            String aString = "string number " + i;
            double random = Math.random();
            double keys = (double)numKeys / 3.0;
            int key = (int)(gen.nextDouble() * keys + gen.nextDouble() * keys + gen.nextDouble() * keys);
            Tuple tuple = new Tuple(new Object[]{i, aString, random, new Text(aString), new TestText(aString), new Tuple(new Object[]{"inner tuple", new BytesWritable(aString.getBytes())})});
            map.get((Object)new Tuple(new Object[]{key})).add(tuple);
            keySet.add(key);
        }
        SpillableTupleHadoopTest.assertEquals((String)"not equal: map.size();", (int)keySet.size(), (int)map.size());
    }
}

