/*
 * Decompiled with CFR 0.152.
 */
package cascading.tap.hadoop;

import cascading.PlatformTestCase;
import cascading.flow.Flow;
import cascading.flow.FlowProcess;
import cascading.operation.BaseOperation;
import cascading.operation.Filter;
import cascading.operation.FilterCall;
import cascading.pipe.Pipe;
import cascading.scheme.Scheme;
import cascading.scheme.hadoop.TextLine;
import cascading.tap.MultiSourceTap;
import cascading.tap.SinkMode;
import cascading.tap.Tap;
import cascading.tap.hadoop.Hfs;
import cascading.tap.hadoop.HfsProps;
import cascading.tap.hadoop.PartitionTap;
import cascading.tap.partition.DelimitedPartition;
import cascading.tap.partition.Partition;
import cascading.tuple.Fields;
import cascading.tuple.FieldsResolverException;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntryIterator;
import data.InputData;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobInProgress;
import org.junit.Test;

public class HadoopMR1TapPlatformTest
extends PlatformTestCase
implements Serializable {
    public HadoopMR1TapPlatformTest() {
        super(true);
    }

    @Test
    public void testCombinedHfs() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileLower);
        this.getPlatform().copyFromLocal(InputData.inputFileUpper);
        Hfs sourceLower = new Hfs((Scheme)new TextLine(new Fields(new Comparable[]{"offset", "line"})), InputData.inputFileLower);
        Hfs sourceUpper = new Hfs((Scheme)new TextLine(new Fields(new Comparable[]{"offset", "line"})), InputData.inputFileUpper);
        MultiSourceTap source = new MultiSourceTap((Tap[])new Hfs[]{sourceLower, sourceUpper});
        FlowProcess process = this.getPlatform().getFlowProcess();
        JobConf conf = (JobConf)process.getConfigCopy();
        conf.setBoolean("cascading.hadoop.hfs.combine.files", true);
        conf.set("cascading.flow.platform", "hadoop");
        source.sourceConfInit(process, (Object)conf);
        InputFormat inputFormat = conf.getInputFormat();
        HadoopMR1TapPlatformTest.assertEquals(Hfs.CombinedInputFormat.class, inputFormat.getClass());
        InputSplit[] splits = inputFormat.getSplits(conf, 1);
        HadoopMR1TapPlatformTest.assertEquals((int)1, (int)splits.length);
        HadoopMR1TapPlatformTest.validateLength((TupleEntryIterator)source.openForRead(process), (int)10);
    }

    @Test
    public void testCombinedPartitionTap() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileLower);
        Tap source = this.getPlatform().getDelimitedFile(new Fields(new Comparable[]{"number", "lower"}), " ", InputData.inputFileLower);
        Tap partitionTap = this.getPlatform().getDelimitedFile(new Fields(new Comparable[]{"lower"}), "+", this.getOutputPath("/combinedpartition/partitioned"), SinkMode.REPLACE);
        DelimitedPartition partition = new DelimitedPartition(new Fields(new Comparable[]{"number"}));
        partitionTap = this.getPlatform().getPartitionTap(partitionTap, (Partition)partition, 1);
        Flow firstFlow = this.getPlatform().getFlowConnector().connect(source, partitionTap, new Pipe("partition"));
        firstFlow.complete();
        Map properties = this.getProperties();
        HfsProps.setUseCombinedInput((Map)properties, (Boolean)true);
        HfsProps.setCombinedInputMaxSize((Map)properties, (Long)100000000L);
        Tap sink = this.getPlatform().getDelimitedFile(new Fields(new Comparable[]{"number", "lower"}), "+", this.getOutputPath("/combinedpartition/final"), SinkMode.REPLACE);
        Flow secondFlow = this.getPlatform().getFlowConnector(properties).connect(partitionTap, sink, new Pipe("copy"));
        secondFlow.complete();
        if (this.getPlatform().isUseCluster()) {
            HadoopMR1TapPlatformTest.assertEquals((long)1L, (long)secondFlow.getStats().getCounterValue((Enum)JobInProgress.Counter.TOTAL_LAUNCHED_MAPS));
        }
        List values = HadoopMR1TapPlatformTest.getSinkAsList((Flow)secondFlow);
        HadoopMR1TapPlatformTest.assertEquals((int)5, (int)values.size());
        HadoopMR1TapPlatformTest.assertTrue((boolean)values.contains(new Tuple(new Object[]{"1", "a"})));
        HadoopMR1TapPlatformTest.assertTrue((boolean)values.contains(new Tuple(new Object[]{"2", "b"})));
        HadoopMR1TapPlatformTest.assertTrue((boolean)values.contains(new Tuple(new Object[]{"3", "c"})));
        HadoopMR1TapPlatformTest.assertTrue((boolean)values.contains(new Tuple(new Object[]{"4", "d"})));
        HadoopMR1TapPlatformTest.assertTrue((boolean)values.contains(new Tuple(new Object[]{"5", "e"})));
    }

    @Test
    public void testFilteredPartitionTap_Typical() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileLower);
        Tap source = this.getPlatform().getDelimitedFile(new Fields(new Comparable[]{"number", "lower"}), " ", InputData.inputFileLower);
        Tap delimitedFile = this.getPlatform().getDelimitedFile(new Fields(new Comparable[]{"lower"}), "+", this.getOutputPath("/filteredpartition/partitioned"), SinkMode.REPLACE);
        DelimitedPartition partition = new DelimitedPartition(new Fields(new Comparable[]{"number"}));
        PartitionTap partitionTap = (PartitionTap)this.getPlatform().getPartitionTap(delimitedFile, (Partition)partition, 1);
        Flow firstFlow = this.getPlatform().getFlowConnector().connect(source, (Tap)partitionTap, new Pipe("partition"));
        firstFlow.complete();
        partitionTap = (PartitionTap)this.getPlatform().getPartitionTap(delimitedFile, (Partition)partition, 1);
        partitionTap.addSourcePartitionFilter(new Fields(new Comparable[]{"number"}), (Filter)new PartitionFilter(Arrays.asList("2", "4")));
        Tap sink = this.getPlatform().getDelimitedFile(new Fields(new Comparable[]{"number", "lower"}), "+", this.getOutputPath("/filteredpartition/final"), SinkMode.REPLACE);
        Flow secondFlow = this.getPlatform().getFlowConnector().connect((Tap)partitionTap, sink, new Pipe("copy"));
        secondFlow.complete();
        List values = HadoopMR1TapPlatformTest.getSinkAsList((Flow)secondFlow);
        HadoopMR1TapPlatformTest.assertEquals((int)3, (int)values.size());
        HadoopMR1TapPlatformTest.assertTrue((boolean)values.contains(new Tuple(new Object[]{"1", "a"})));
        HadoopMR1TapPlatformTest.assertTrue((boolean)values.contains(new Tuple(new Object[]{"3", "c"})));
        HadoopMR1TapPlatformTest.assertTrue((boolean)values.contains(new Tuple(new Object[]{"5", "e"})));
    }

    @Test
    public void testFilteredPartitionTap_NoFilters() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileLower);
        Tap source = this.getPlatform().getDelimitedFile(new Fields(new Comparable[]{"number", "lower"}), " ", InputData.inputFileLower);
        Tap delimitedFile = this.getPlatform().getDelimitedFile(new Fields(new Comparable[]{"lower"}), "+", this.getOutputPath("/filteredpartition/partitioned"), SinkMode.REPLACE);
        DelimitedPartition partition = new DelimitedPartition(new Fields(new Comparable[]{"number"}));
        Tap partitionTap = this.getPlatform().getPartitionTap(delimitedFile, (Partition)partition, 1);
        Flow firstFlow = this.getPlatform().getFlowConnector().connect(source, partitionTap, new Pipe("partition"));
        firstFlow.complete();
        partitionTap = this.getPlatform().getPartitionTap(delimitedFile, (Partition)partition, 1);
        Tap sink = this.getPlatform().getDelimitedFile(new Fields(new Comparable[]{"number", "lower"}), "+", this.getOutputPath("/filteredpartition/final"), SinkMode.REPLACE);
        Flow secondFlow = this.getPlatform().getFlowConnector().connect(partitionTap, sink, new Pipe("copy"));
        secondFlow.complete();
        List values = HadoopMR1TapPlatformTest.getSinkAsList((Flow)secondFlow);
        HadoopMR1TapPlatformTest.assertEquals((int)5, (int)values.size());
        HadoopMR1TapPlatformTest.assertTrue((boolean)values.contains(new Tuple(new Object[]{"1", "a"})));
        HadoopMR1TapPlatformTest.assertTrue((boolean)values.contains(new Tuple(new Object[]{"2", "b"})));
        HadoopMR1TapPlatformTest.assertTrue((boolean)values.contains(new Tuple(new Object[]{"3", "c"})));
        HadoopMR1TapPlatformTest.assertTrue((boolean)values.contains(new Tuple(new Object[]{"4", "d"})));
        HadoopMR1TapPlatformTest.assertTrue((boolean)values.contains(new Tuple(new Object[]{"5", "e"})));
    }

    @Test
    public void testFilteredPartitionTap_SameNameWithType() throws Exception {
        Fields partitionFields = new Fields((Comparable)((Object)"name"), String.class);
        Fields argumentSelector = new Fields(new Comparable[]{"name"});
        this.testFilteredPartitionTapFields(partitionFields, argumentSelector);
    }

    @Test
    public void testFilteredPartitionTap_SameNameNoTypes() throws Exception {
        Fields partitionFields = new Fields(new Comparable[]{"name"});
        Fields argumentSelector = new Fields(new Comparable[]{"name"});
        this.testFilteredPartitionTapFields(partitionFields, argumentSelector);
    }

    @Test(expected=FieldsResolverException.class)
    public void testFilteredPartitionTap_DifferentNameNoType() throws Exception {
        Fields partitionFields = new Fields(new Comparable[]{"name1"});
        Fields argumentSelector = new Fields(new Comparable[]{"name2"});
        this.testFilteredPartitionTapFields(partitionFields, argumentSelector);
    }

    @Test(expected=FieldsResolverException.class)
    public void testFilteredPartitionTap_DifferentNameWithTYpe() throws Exception {
        Fields partitionFields = new Fields((Comparable)((Object)"name1"), String.class);
        Fields argumentSelector = new Fields(new Comparable[]{"name2"});
        this.testFilteredPartitionTapFields(partitionFields, argumentSelector);
    }

    private void testFilteredPartitionTapFields(Fields partitionFields, Fields argumentSelector) throws Exception {
        Tap tap = this.getPlatform().getTextFile("dummy");
        DelimitedPartition partition = new DelimitedPartition(partitionFields);
        PartitionTap partitionTap = (PartitionTap)this.getPlatform().getPartitionTap(tap, (Partition)partition, 1);
        partitionTap.addSourcePartitionFilter(argumentSelector, (Filter)new TrueFilter());
    }

    static class PartitionFilter
    extends BaseOperation
    implements Filter {
        private static final long serialVersionUID = 1L;
        private final List<String> partitions;

        public PartitionFilter(List<String> partitions) {
            this.partitions = partitions;
        }

        public boolean isRemove(FlowProcess flowProcess, FilterCall filterCall) {
            return this.partitions.contains(filterCall.getArguments().getString((Comparable)((Object)"number")));
        }
    }

    static class TrueFilter
    extends BaseOperation
    implements Filter {
        private static final long serialVersionUID = 1L;

        TrueFilter() {
        }

        public boolean isRemove(FlowProcess flowProcess, FilterCall filterCall) {
            return true;
        }
    }
}

