/*
 * Decompiled with CFR 0.152.
 */
package cascading.stats.hadoop;

import cascading.CascadingException;
import cascading.PlatformTestCase;
import cascading.TestFailAggregator;
import cascading.cascade.Cascade;
import cascading.cascade.CascadeConnector;
import cascading.flow.Flow;
import cascading.flow.FlowProcess;
import cascading.flow.hadoop.planner.HadoopFlowStepJob;
import cascading.operation.Aggregator;
import cascading.operation.BaseOperation;
import cascading.operation.Function;
import cascading.operation.FunctionCall;
import cascading.operation.regex.RegexParser;
import cascading.pipe.Each;
import cascading.pipe.Every;
import cascading.pipe.GroupBy;
import cascading.pipe.Pipe;
import cascading.stats.CascadeStats;
import cascading.tap.SinkMode;
import cascading.tap.Tap;
import cascading.tuple.Fields;
import data.InputData;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class CascadingStatsLocalHadoopErrorPlatformTest
extends PlatformTestCase {
    public CascadingStatsLocalHadoopErrorPlatformTest() {
        super(false);
    }

    @Before
    public void setUp() {
        HadoopFlowStepJob.reportLocalError(null);
    }

    @After
    public void tearDown() {
        HadoopFlowStepJob.reportLocalError(null);
    }

    @Test
    public void testLocalErrorReportingInMapper() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileApache);
        Tap source = this.getPlatform().getTextFile(InputData.inputFileApache);
        Pipe pipe = new Pipe("failing mapper");
        pipe = new Each(pipe, new Fields(new Comparable[]{"line"}), (Function)new FailFunction(new Fields(new Comparable[]{"ip"})), new Fields(new Comparable[]{"ip"}));
        Tap sink = this.getPlatform().getTextFile(this.getOutputPath("mapperfail"), SinkMode.REPLACE);
        Flow flow = this.getPlatform().getFlowConnector().connect("mapper fail test", source, sink, pipe);
        Cascade cascade = new CascadeConnector(this.getProperties()).connect(new Flow[]{flow});
        CascadingStatsLocalHadoopErrorPlatformTest.assertNull((Object)cascade.getCascadeStats().getThrowable());
        try {
            cascade.complete();
            CascadingStatsLocalHadoopErrorPlatformTest.fail((String)"An exception should have been thrown");
        }
        catch (Throwable throwable) {
            CascadeStats cascadeStats = cascade.getCascadeStats();
            CascadingStatsLocalHadoopErrorPlatformTest.assertEquals((Object)throwable, (Object)cascadeStats.getThrowable());
        }
    }

    @Test
    public void testLocalErrorReportingInReducer() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileApache);
        Tap source = this.getPlatform().getTextFile(InputData.inputFileApache);
        Pipe pipe = new Pipe("failing reducer");
        pipe = new Each(pipe, new Fields(new Comparable[]{"line"}), (Function)new RegexParser(new Fields(new Comparable[]{"ip"}), "^[^ ]*"), new Fields(new Comparable[]{"ip"}));
        pipe = new GroupBy(pipe, new Fields(new Comparable[]{"ip"}));
        pipe = new Every(pipe, (Aggregator)new TestFailAggregator(new Fields(new Comparable[]{"count"}), 1));
        Tap sink = this.getPlatform().getTextFile(this.getOutputPath("reducerfail"), SinkMode.REPLACE);
        Flow flow = this.getPlatform().getFlowConnector().connect("reducer fail test", source, sink, pipe);
        Cascade cascade = new CascadeConnector(this.getProperties()).connect(new Flow[]{flow});
        CascadingStatsLocalHadoopErrorPlatformTest.assertNull((Object)cascade.getCascadeStats().getThrowable());
        try {
            cascade.complete();
            CascadingStatsLocalHadoopErrorPlatformTest.fail((String)"An exception should have been thrown");
        }
        catch (Throwable throwable) {
            CascadeStats cascadeStats = cascade.getCascadeStats();
            CascadingStatsLocalHadoopErrorPlatformTest.assertEquals((Object)throwable, (Object)cascadeStats.getThrowable());
        }
    }

    public class FailFunction
    extends BaseOperation
    implements Function {
        public FailFunction(Fields fieldDeclaration) {
            super(1, fieldDeclaration);
        }

        public void operate(FlowProcess flowProcess, FunctionCall functionCall) {
            throw new CascadingException("testing");
        }
    }
}

