/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.hadoop.io;

import cascading.tuple.Tuple;
import cascading.tuple.io.IndexTuple;
import cascading.tuple.io.TupleOutputStream;
import cascading.tuple.io.TuplePair;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.hadoop.io.WritableUtils;

public class HadoopTupleOutputStream
extends TupleOutputStream {
    public static final int WRITABLE_TOKEN = 32;
    private static final Map<Class, TupleOutputStream.TupleElementWriter> staticTupleUnTypedElementWriters = new IdentityHashMap<Class, TupleOutputStream.TupleElementWriter>();
    private static final Map<Class, TupleOutputStream.TupleElementWriter> staticTupleTypedElementWriters = new IdentityHashMap<Class, TupleOutputStream.TupleElementWriter>();

    public static TupleOutputStream.TupleElementWriter[] getWritersFor(TupleOutputStream.ElementWriter elementWriter, Class[] keyClasses) {
        if (keyClasses == null || keyClasses.length == 0) {
            return null;
        }
        TupleOutputStream.TupleElementWriter[] writers = new TupleOutputStream.TupleElementWriter[keyClasses.length];
        for (int i = 0; i < keyClasses.length; ++i) {
            TupleOutputStream.TupleElementWriter writer = staticTupleTypedElementWriters.get(keyClasses[i]);
            if (writer != null) {
                writers[i] = writer;
                continue;
            }
            int index = i;
            writers[i] = (stream, element) -> elementWriter.write((DataOutputStream)stream, keyClasses[index], element);
        }
        return writers;
    }

    public HadoopTupleOutputStream(OutputStream outputStream, TupleOutputStream.ElementWriter elementWriter) {
        super(staticTupleUnTypedElementWriters, staticTupleTypedElementWriters, outputStream, elementWriter);
    }

    protected void writeIntInternal(int value) throws IOException {
        WritableUtils.writeVInt((DataOutput)((Object)this), (int)value);
    }

    public void writeIndexTuple(IndexTuple indexTuple) throws IOException {
        this.writeIntInternal(indexTuple.getIndex());
        this.writeTuple(indexTuple.getTuple());
    }

    static {
        staticTupleUnTypedElementWriters.put(String.class, (stream, element) -> {
            WritableUtils.writeVInt((DataOutput)stream, (int)1);
            WritableUtils.writeString((DataOutput)stream, (String)((String)element));
        });
        staticTupleUnTypedElementWriters.put(Float.class, (stream, element) -> {
            WritableUtils.writeVInt((DataOutput)stream, (int)2);
            stream.writeFloat(((Float)element).floatValue());
        });
        staticTupleUnTypedElementWriters.put(Double.class, (stream, element) -> {
            WritableUtils.writeVInt((DataOutput)stream, (int)3);
            stream.writeDouble(((Double)element).doubleValue());
        });
        staticTupleUnTypedElementWriters.put(Integer.class, (stream, element) -> {
            WritableUtils.writeVInt((DataOutput)stream, (int)4);
            WritableUtils.writeVInt((DataOutput)stream, (int)((Integer)element));
        });
        staticTupleUnTypedElementWriters.put(Long.class, (stream, element) -> {
            WritableUtils.writeVInt((DataOutput)stream, (int)5);
            WritableUtils.writeVLong((DataOutput)stream, (long)((Long)element));
        });
        staticTupleUnTypedElementWriters.put(Boolean.class, (stream, element) -> {
            WritableUtils.writeVInt((DataOutput)stream, (int)6);
            stream.writeBoolean(((Boolean)element).booleanValue());
        });
        staticTupleUnTypedElementWriters.put(Short.class, (stream, element) -> {
            WritableUtils.writeVInt((DataOutput)stream, (int)7);
            stream.writeShort((int)((Short)element).shortValue());
        });
        staticTupleUnTypedElementWriters.put(Tuple.class, (stream, element) -> {
            WritableUtils.writeVInt((DataOutput)stream, (int)8);
            stream.writeTuple((Tuple)element);
        });
        staticTupleUnTypedElementWriters.put(TuplePair.class, (stream, element) -> {
            WritableUtils.writeVInt((DataOutput)stream, (int)9);
            stream.writeTuplePair((TuplePair)element);
        });
        staticTupleUnTypedElementWriters.put(IndexTuple.class, (stream, element) -> {
            WritableUtils.writeVInt((DataOutput)stream, (int)10);
            stream.writeIndexTuple((IndexTuple)element);
        });
        staticTupleTypedElementWriters.put(Void.class, (stream, element) -> {});
        staticTupleTypedElementWriters.put(String.class, (stream, element) -> WritableUtils.writeString((DataOutput)stream, (String)((String)element)));
        staticTupleTypedElementWriters.put(Float.class, (stream, element) -> {
            if (element == null) {
                stream.writeByte(0);
                return;
            }
            stream.writeByte(1);
            stream.writeFloat(((Float)element).floatValue());
        });
        staticTupleTypedElementWriters.put(Double.class, (stream, element) -> {
            if (element == null) {
                stream.writeByte(0);
                return;
            }
            stream.writeByte(1);
            stream.writeDouble(((Double)element).doubleValue());
        });
        staticTupleTypedElementWriters.put(Integer.class, (stream, element) -> {
            if (element == null) {
                stream.writeByte(0);
                return;
            }
            stream.writeByte(1);
            WritableUtils.writeVInt((DataOutput)stream, (int)((Integer)element));
        });
        staticTupleTypedElementWriters.put(Long.class, (stream, element) -> {
            if (element == null) {
                stream.writeByte(0);
                return;
            }
            stream.writeByte(1);
            WritableUtils.writeVLong((DataOutput)stream, (long)((Long)element));
        });
        staticTupleTypedElementWriters.put(Boolean.class, (stream, element) -> {
            if (element == null) {
                stream.writeByte(0);
                return;
            }
            stream.writeByte(1);
            stream.writeBoolean(((Boolean)element).booleanValue());
        });
        staticTupleTypedElementWriters.put(Short.class, (stream, element) -> {
            if (element == null) {
                stream.writeByte(0);
                return;
            }
            stream.writeByte(1);
            stream.writeShort((int)((Short)element).shortValue());
        });
        staticTupleTypedElementWriters.put(Float.TYPE, (stream, element) -> {
            if (element == null) {
                stream.writeFloat(0.0f);
            } else {
                stream.writeFloat(((Float)element).floatValue());
            }
        });
        staticTupleTypedElementWriters.put(Double.TYPE, (stream, element) -> {
            if (element == null) {
                stream.writeDouble(0.0);
            } else {
                stream.writeDouble(((Double)element).doubleValue());
            }
        });
        staticTupleTypedElementWriters.put(Integer.TYPE, (stream, element) -> {
            if (element == null) {
                WritableUtils.writeVInt((DataOutput)stream, (int)0);
            } else {
                WritableUtils.writeVInt((DataOutput)stream, (int)((Integer)element));
            }
        });
        staticTupleTypedElementWriters.put(Long.TYPE, (stream, element) -> {
            if (element == null) {
                WritableUtils.writeVLong((DataOutput)stream, (long)0L);
            } else {
                WritableUtils.writeVLong((DataOutput)stream, (long)((Long)element));
            }
        });
        staticTupleTypedElementWriters.put(Boolean.TYPE, (stream, element) -> {
            if (element == null) {
                stream.writeBoolean(false);
            } else {
                stream.writeBoolean(((Boolean)element).booleanValue());
            }
        });
        staticTupleTypedElementWriters.put(Short.TYPE, (stream, element) -> {
            if (element == null) {
                stream.writeShort(0);
            } else {
                stream.writeShort((int)((Short)element).shortValue());
            }
        });
        staticTupleTypedElementWriters.put(Tuple.class, (stream, element) -> stream.writeTuple((Tuple)element));
        staticTupleTypedElementWriters.put(TuplePair.class, (stream, element) -> stream.writeTuplePair((TuplePair)element));
        staticTupleTypedElementWriters.put(IndexTuple.class, (stream, element) -> stream.writeIndexTuple((IndexTuple)element));
    }
}

