/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.hadoop.collect;

import cascading.flow.FlowProcess;
import cascading.tuple.Tuple;
import cascading.tuple.collect.SpillableTupleList;
import cascading.tuple.collect.SpillableTupleMap;
import cascading.tuple.collect.TupleMapFactory;
import cascading.tuple.hadoop.collect.HadoopSpillableTupleMap;
import java.util.Collection;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;

public class HadoopTupleMapFactory
implements TupleMapFactory<Configuration> {
    private int capacity;
    private float loadFactor;
    private int mapThreshold;
    private int listThreshold;

    public void initialize(FlowProcess<? extends Configuration> flowProcess) {
        this.capacity = SpillableTupleMap.getMapCapacity(flowProcess, (int)100000);
        this.loadFactor = SpillableTupleMap.getMapLoadFactor(flowProcess, (float)0.75f);
        this.mapThreshold = SpillableTupleMap.getMapThreshold(flowProcess, (int)10000);
        this.listThreshold = SpillableTupleList.getThreshold(flowProcess, (int)10000);
    }

    public Map<Tuple, Collection<Tuple>> create(FlowProcess<? extends Configuration> flowProcess) {
        return new HadoopSpillableTupleMap(this.capacity, this.loadFactor, this.mapThreshold, this.listThreshold, flowProcess);
    }
}

