/*
 * Decompiled with CFR 0.152.
 */
package cascading.tap.hadoop.io;

import java.io.IOException;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.lib.CombineFileSplit;

public class CombineFileRecordReaderWrapper<K, V>
implements RecordReader<K, V> {
    public static final String INDIVIDUAL_INPUT_FORMAT = "cascading.individual.input.format";
    private final RecordReader<K, V> delegate;

    public CombineFileRecordReaderWrapper(CombineFileSplit split, Configuration conf, Reporter reporter, Integer idx) throws Exception {
        FileSplit fileSplit = new FileSplit(split.getPath(idx.intValue()), split.getOffset(idx.intValue()), split.getLength(idx.intValue()), split.getLocations());
        Class clz = conf.getClass(INDIVIDUAL_INPUT_FORMAT, null);
        FileInputFormat inputFormat = (FileInputFormat)clz.newInstance();
        if (inputFormat instanceof Configurable) {
            ((Configurable)inputFormat).setConf(conf);
        }
        this.delegate = inputFormat.getRecordReader((InputSplit)fileSplit, (JobConf)conf, reporter);
    }

    public boolean next(K key, V value) throws IOException {
        return this.delegate.next(key, value);
    }

    public K createKey() {
        return (K)this.delegate.createKey();
    }

    public V createValue() {
        return (V)this.delegate.createValue();
    }

    public long getPos() throws IOException {
        return this.delegate.getPos();
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    public float getProgress() throws IOException {
        return this.delegate.getProgress();
    }
}

