/*
 * Decompiled with CFR 0.152.
 */
package cascading.scheme.hadoop;

import cascading.flow.FlowProcess;
import cascading.scheme.SinkCall;
import cascading.scheme.SourceCall;
import cascading.scheme.hadoop.SequenceFile;
import cascading.tap.Tap;
import cascading.tuple.Fields;
import cascading.tuple.TupleEntry;
import java.beans.ConstructorProperties;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;

public class WritableSequenceFile
extends SequenceFile {
    protected final Class<? extends Writable> keyType;
    protected final Class<? extends Writable> valueType;

    @ConstructorProperties(value={"fields", "valueType"})
    public WritableSequenceFile(Fields fields, Class<? extends Writable> valueType) {
        this(fields, null, valueType);
    }

    @ConstructorProperties(value={"fields", "keyType", "valueType"})
    public WritableSequenceFile(Fields fields, Class<? extends Writable> keyType, Class<? extends Writable> valueType) {
        super(fields);
        this.keyType = keyType;
        this.valueType = valueType;
        if (keyType == null && valueType == null) {
            throw new IllegalArgumentException("both keyType and valueType may not be null");
        }
        if (keyType == null && fields.size() != 1) {
            throw new IllegalArgumentException("fields must declare exactly one field when only reading/writing 'keys' from a sequence file");
        }
        if (valueType == null && fields.size() != 1) {
            throw new IllegalArgumentException("fields must declare exactly one field when only reading/writing 'values' from a sequence file");
        }
        if (keyType != null && valueType != null && fields.size() != 2) {
            throw new IllegalArgumentException("fields must declare exactly two fields when only reading/writing 'keys' and 'values' from a sequence file");
        }
    }

    @Override
    public void sinkConfInit(FlowProcess<? extends Configuration> flowProcess, Tap<Configuration, RecordReader, OutputCollector> tap, Configuration conf) {
        if (this.keyType != null) {
            conf.setClass("mapred.output.key.class", this.keyType, Object.class);
        } else {
            conf.setClass("mapred.output.key.class", NullWritable.class, Object.class);
        }
        if (this.valueType != null) {
            conf.setClass("mapred.output.value.class", this.valueType, Object.class);
        } else {
            conf.setClass("mapred.output.value.class", NullWritable.class, Object.class);
        }
        conf.setClass("mapred.output.format.class", SequenceFileOutputFormat.class, OutputFormat.class);
    }

    @Override
    public boolean source(FlowProcess<? extends Configuration> flowProcess, SourceCall<Object[], RecordReader> sourceCall) throws IOException {
        Object key = ((Object[])sourceCall.getContext())[0];
        Object value = ((Object[])sourceCall.getContext())[1];
        boolean result = ((RecordReader)sourceCall.getInput()).next(key, value);
        if (!result) {
            return false;
        }
        int count = 0;
        TupleEntry entry = sourceCall.getIncomingEntry();
        if (this.keyType != null) {
            entry.setObject((Comparable)Integer.valueOf(count++), key);
        }
        if (this.valueType != null) {
            entry.setObject((Comparable)Integer.valueOf(count), value);
        }
        return true;
    }

    @Override
    public void sink(FlowProcess<? extends Configuration> flowProcess, SinkCall<Void, OutputCollector> sinkCall) throws IOException {
        TupleEntry tupleEntry = sinkCall.getOutgoingEntry();
        NullWritable keyValue = NullWritable.get();
        NullWritable valueValue = NullWritable.get();
        if (this.keyType == null) {
            valueValue = (Writable)tupleEntry.getObject(0);
        } else if (this.valueType == null) {
            keyValue = (Writable)tupleEntry.getObject(0);
        } else {
            keyValue = (Writable)tupleEntry.getObject(0);
            valueValue = (Writable)tupleEntry.getObject(1);
        }
        ((OutputCollector)sinkCall.getOutput()).collect((Object)keyValue, (Object)valueValue);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof WritableSequenceFile)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        WritableSequenceFile that = (WritableSequenceFile)((Object)object);
        if (this.keyType != null ? !this.keyType.equals(that.keyType) : that.keyType != null) {
            return false;
        }
        return !(this.valueType != null ? !this.valueType.equals(that.valueType) : that.valueType != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.keyType != null ? this.keyType.hashCode() : 0);
        result = 31 * result + (this.valueType != null ? this.valueType.hashCode() : 0);
        return result;
    }
}

