/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.hadoop.io;

import cascading.tuple.Tuple;
import cascading.tuple.io.IndexTuple;
import cascading.tuple.io.TupleInputStream;
import cascading.tuple.io.TuplePair;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.hadoop.io.WritableUtils;

public class HadoopTupleInputStream
extends TupleInputStream {
    private static final Map<Class, TupleInputStream.TupleElementReader> staticTupleUnTypedElementReaders = new IdentityHashMap<Class, TupleInputStream.TupleElementReader>();
    private static final Map<Class, TupleInputStream.TupleElementReader> staticTupleTypedElementReaders = new IdentityHashMap<Class, TupleInputStream.TupleElementReader>();

    public static TupleInputStream.TupleElementReader[] getReadersFor(TupleInputStream.ElementReader elementReader, Class[] classes) {
        if (classes == null || classes.length == 0) {
            return null;
        }
        TupleInputStream.TupleElementReader[] readers = new TupleInputStream.TupleElementReader[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            TupleInputStream.TupleElementReader reader = staticTupleTypedElementReaders.get(classes[i]);
            if (reader != null) {
                readers[i] = reader;
                continue;
            }
            int index = i;
            readers[i] = stream -> elementReader.read(classes[index], (DataInputStream)stream);
        }
        return readers;
    }

    public HadoopTupleInputStream(InputStream inputStream, TupleInputStream.ElementReader elementReader) {
        super(inputStream, elementReader);
    }

    public int getNumElements() throws IOException {
        return this.readVInt();
    }

    public int readToken() throws IOException {
        return this.readVInt();
    }

    public Object getNextElement() throws IOException {
        return this.readType(this.readToken());
    }

    public IndexTuple readIndexTuple(IndexTuple tuple) throws IOException {
        tuple.setIndex(this.readVInt());
        tuple.setTuple(this.readTuple());
        return tuple;
    }

    public Long readNullVLong() throws IOException {
        byte b = this.readByte();
        if (b == 0) {
            return null;
        }
        return WritableUtils.readVLong((DataInput)((Object)this));
    }

    public long readVLong() throws IOException {
        return WritableUtils.readVLong((DataInput)((Object)this));
    }

    public Integer readNullVInt() throws IOException {
        byte b = this.readByte();
        if (b == 0) {
            return null;
        }
        return WritableUtils.readVInt((DataInput)((Object)this));
    }

    public int readVInt() throws IOException {
        return WritableUtils.readVInt((DataInput)((Object)this));
    }

    public String readString() throws IOException {
        return WritableUtils.readString((DataInput)((Object)this));
    }

    private Short readNullShort() throws IOException {
        byte b = this.readByte();
        if (b == 0) {
            return null;
        }
        return this.readShort();
    }

    private Object readNullBoolean() throws IOException {
        byte b = this.readByte();
        if (b == 0) {
            return null;
        }
        return this.readBoolean();
    }

    private Object readNullDouble() throws IOException {
        byte b = this.readByte();
        if (b == 0) {
            return null;
        }
        return this.readDouble();
    }

    private Object readNullFloat() throws IOException {
        byte b = this.readByte();
        if (b == 0) {
            return null;
        }
        return Float.valueOf(this.readFloat());
    }

    protected final Object readType(int type) throws IOException {
        switch (type) {
            case 0: {
                return null;
            }
            case 1: {
                return this.readString();
            }
            case 2: {
                return Float.valueOf(this.readFloat());
            }
            case 3: {
                return this.readDouble();
            }
            case 4: {
                return this.readVInt();
            }
            case 5: {
                return this.readVLong();
            }
            case 6: {
                return this.readBoolean();
            }
            case 7: {
                return this.readShort();
            }
            case 8: {
                return this.readTuple();
            }
            case 9: {
                return this.readTuplePair();
            }
            case 10: {
                return this.readIndexTuple();
            }
        }
        return this.elementReader.read(type, (DataInputStream)((Object)this));
    }

    public final Object readType(Class type) throws IOException {
        if (type == Void.class) {
            return null;
        }
        if (type == String.class) {
            return this.readString();
        }
        if (type == Float.class) {
            return this.readNullFloat();
        }
        if (type == Double.class) {
            return this.readNullDouble();
        }
        if (type == Integer.class) {
            return this.readNullVInt();
        }
        if (type == Long.class) {
            return this.readNullVLong();
        }
        if (type == Boolean.class) {
            return this.readNullBoolean();
        }
        if (type == Short.class) {
            return this.readNullShort();
        }
        if (type == Float.TYPE) {
            return Float.valueOf(this.readFloat());
        }
        if (type == Double.TYPE) {
            return this.readDouble();
        }
        if (type == Integer.TYPE) {
            return this.readVInt();
        }
        if (type == Long.TYPE) {
            return this.readVLong();
        }
        if (type == Boolean.TYPE) {
            return this.readBoolean();
        }
        if (type == Short.TYPE) {
            return this.readShort();
        }
        if (type == Tuple.class) {
            return this.readTuple();
        }
        if (type == TuplePair.class) {
            return this.readTuplePair();
        }
        if (type == IndexTuple.class) {
            return this.readIndexTuple();
        }
        return this.elementReader.read(type, (DataInputStream)((Object)this));
    }

    static {
        staticTupleTypedElementReaders.put(Void.class, stream -> null);
        staticTupleTypedElementReaders.put(String.class, HadoopTupleInputStream::readString);
        staticTupleTypedElementReaders.put(Float.class, HadoopTupleInputStream::readNullFloat);
        staticTupleTypedElementReaders.put(Double.class, HadoopTupleInputStream::readNullDouble);
        staticTupleTypedElementReaders.put(Integer.class, HadoopTupleInputStream::readNullVInt);
        staticTupleTypedElementReaders.put(Long.class, HadoopTupleInputStream::readNullVLong);
        staticTupleTypedElementReaders.put(Boolean.class, HadoopTupleInputStream::readNullBoolean);
        staticTupleTypedElementReaders.put(Short.class, HadoopTupleInputStream::readNullShort);
        staticTupleTypedElementReaders.put(Float.TYPE, DataInputStream::readFloat);
        staticTupleTypedElementReaders.put(Double.TYPE, DataInputStream::readDouble);
        staticTupleTypedElementReaders.put(Integer.TYPE, HadoopTupleInputStream::readVInt);
        staticTupleTypedElementReaders.put(Long.TYPE, HadoopTupleInputStream::readVLong);
        staticTupleTypedElementReaders.put(Boolean.TYPE, DataInputStream::readBoolean);
        staticTupleTypedElementReaders.put(Short.TYPE, DataInputStream::readShort);
        staticTupleTypedElementReaders.put(Tuple.class, TupleInputStream::readTuple);
        staticTupleTypedElementReaders.put(TuplePair.class, TupleInputStream::readTuplePair);
        staticTupleTypedElementReaders.put(IndexTuple.class, TupleInputStream::readIndexTuple);
    }
}

