/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.hadoop.io;

import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.hadoop.TupleSerialization;
import cascading.tuple.hadoop.io.HadoopTupleInputStream;
import cascading.tuple.io.TupleInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.io.serializer.Deserializer;

abstract class BaseDeserializer<T extends Tuple>
implements Deserializer<T> {
    private final TupleSerialization.SerializationElementReader elementReader;
    private TupleInputStream.TupleElementReader[] readers;
    HadoopTupleInputStream inputStream;

    protected BaseDeserializer(TupleSerialization.SerializationElementReader elementReader) {
        this.elementReader = elementReader;
    }

    protected void setReaders(Fields fields) {
        if (fields == null) {
            return;
        }
        Class[] classes = this.elementReader.getTupleSerialization().getTypesFor(fields);
        if (this.elementReader.getTupleSerialization().areTypesRequired() && classes == null) {
            throw new IllegalStateException("types are required to perform serialization, declared fields: " + fields);
        }
        this.readers = HadoopTupleInputStream.getReadersFor(this.elementReader, classes);
    }

    public void open(InputStream in) {
        this.inputStream = in instanceof HadoopTupleInputStream ? (HadoopTupleInputStream)((Object)in) : new HadoopTupleInputStream(in, this.elementReader);
    }

    public T deserialize(T tuple) throws IOException {
        if (tuple == null) {
            tuple = this.createTuple();
        }
        if (this.readers == null) {
            return (T)this.inputStream.readUnTyped((Tuple)tuple);
        }
        return (T)this.inputStream.readWith(this.readers, (Tuple)tuple);
    }

    protected abstract T createTuple();

    public void close() throws IOException {
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
        finally {
            this.inputStream = null;
        }
    }
}

