/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.hadoop.collect;

import cascading.flow.FlowProcess;
import cascading.provider.FactoryLoader;
import cascading.tuple.Tuple;
import cascading.tuple.collect.Spillable;
import cascading.tuple.collect.SpillableTupleMap;
import cascading.tuple.collect.TupleCollectionFactory;
import cascading.tuple.hadoop.collect.HadoopTupleCollectionFactory;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;

public class HadoopSpillableTupleMap
extends SpillableTupleMap {
    private final FlowProcess<? extends Configuration> flowProcess;
    private final Spillable.SpillStrategy spillStrategy;
    private final TupleCollectionFactory<Configuration> tupleCollectionFactory;

    public HadoopSpillableTupleMap(int initialCapacity, float loadFactor, int mapThreshold, int listThreshold, FlowProcess<? extends Configuration> flowProcess) {
        super(initialCapacity, loadFactor, mapThreshold, listThreshold);
        this.flowProcess = flowProcess;
        this.spillStrategy = this.getSpillStrategy();
        FactoryLoader loader = FactoryLoader.getInstance();
        this.tupleCollectionFactory = (TupleCollectionFactory)loader.loadFactoryFrom(flowProcess, "cascading.factory.tuple.map.classname", HadoopTupleCollectionFactory.class);
    }

    protected Collection<Tuple> createTupleCollection(Tuple tuple) {
        Collection collection = (Collection)this.tupleCollectionFactory.create(this.flowProcess);
        if (collection instanceof Spillable) {
            ((Spillable)collection).setGrouping(tuple);
            ((Spillable)collection).setSpillListener(this.getSpillListener());
            ((Spillable)collection).setSpillStrategy(this.spillStrategy);
        }
        return collection;
    }

    protected Spillable.SpillStrategy getSpillStrategy() {
        return new Spillable.SpillStrategy(){
            int minThreshold;
            {
                this.minThreshold = (int)((double)HadoopSpillableTupleMap.this.getMapThreshold() * 0.05);
            }

            int current() {
                return Math.max(this.minThreshold, Math.min(HadoopSpillableTupleMap.this.getInitListThreshold(), HadoopSpillableTupleMap.this.getMapThreshold() / HadoopSpillableTupleMap.this.size()));
            }

            public boolean doSpill(Spillable spillable, int size) {
                return this.current() <= size;
            }

            public String getSpillReason(Spillable spillable) {
                return "met current threshold: " + this.current();
            }
        };
    }
}

