/*
 * Decompiled with CFR 0.152.
 */
package cascading.tap.hadoop.util;

import cascading.flow.FlowProcess;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import org.apache.hadoop.mapred.OutputCollector;

public class MeasuredOutputCollector
implements OutputCollector,
Flushable,
Closeable {
    private final FlowProcess flowProcess;
    private final Enum counter;
    private OutputCollector outputCollector;

    public MeasuredOutputCollector(FlowProcess flowProcess, Enum counter) {
        this.flowProcess = flowProcess;
        this.counter = counter;
    }

    public MeasuredOutputCollector(FlowProcess flowProcess, Enum counter, OutputCollector outputCollector) {
        this.flowProcess = flowProcess;
        this.counter = counter;
        this.outputCollector = outputCollector;
    }

    public OutputCollector getOutputCollector() {
        return this.outputCollector;
    }

    public void setOutputCollector(OutputCollector outputCollector) {
        this.outputCollector = outputCollector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collect(Object key, Object value) throws IOException {
        long start = System.currentTimeMillis();
        try {
            this.outputCollector.collect(key, value);
        }
        finally {
            this.flowProcess.increment(this.counter, System.currentTimeMillis() - start);
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.outputCollector instanceof Flushable) {
            ((Flushable)this.outputCollector).flush();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.outputCollector instanceof Closeable) {
            ((Closeable)this.outputCollector).close();
        }
    }
}

