/*
 * Decompiled with CFR 0.152.
 */
package cascading.tap.hadoop;

import cascading.scheme.Scheme;
import cascading.tap.SinkMode;
import cascading.tap.TapException;
import cascading.tap.hadoop.Hfs;
import java.beans.ConstructorProperties;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;

public class Lfs
extends Hfs {
    @ConstructorProperties(value={"scheme"})
    Lfs(Scheme scheme) {
        super(scheme);
    }

    @ConstructorProperties(value={"scheme", "stringPath"})
    public Lfs(Scheme scheme, String stringPath) {
        super(scheme, stringPath);
    }

    @ConstructorProperties(value={"scheme", "stringPath", "sinkMode"})
    public Lfs(Scheme scheme, String stringPath, SinkMode sinkMode) {
        super(scheme, stringPath, sinkMode);
    }

    @Override
    protected void setStringPath(String stringPath) {
        if (stringPath.matches(".*://.*") && !stringPath.startsWith("file://")) {
            throw new IllegalArgumentException("uri must use the file scheme");
        }
        super.setStringPath(stringPath);
    }

    @Override
    protected FileSystem getFileSystem(Configuration conf) {
        try {
            return FileSystem.getLocal((Configuration)conf);
        }
        catch (IOException exception) {
            throw new TapException("unable to get handle to get local filesystem", (Throwable)exception);
        }
    }
}

