/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.hadoop.io;

import cascading.tuple.Tuple;
import cascading.tuple.hadoop.TupleSerialization;
import cascading.tuple.hadoop.io.BaseDeserializer;
import cascading.tuple.hadoop.io.HadoopTupleInputStream;
import cascading.tuple.io.TupleInputStream;
import cascading.tuple.io.TuplePair;
import java.io.IOException;

public class TuplePairDeserializer
extends BaseDeserializer<TuplePair> {
    private final TupleInputStream.TupleElementReader[] keyReaders;
    private final TupleInputStream.TupleElementReader[] sortReaders;

    public TuplePairDeserializer(TupleSerialization.SerializationElementReader elementReader) {
        super(elementReader);
        Class[] keyClasses = elementReader.getTupleSerialization().getKeyTypes();
        Class[] sortClasses = elementReader.getTupleSerialization().getSortTypes();
        if (elementReader.getTupleSerialization().areTypesRequired()) {
            if (keyClasses == null) {
                throw new IllegalStateException("types are required to perform serialization, grouping declared fields: " + elementReader.getTupleSerialization().getKeyFields());
            }
            if (sortClasses == null) {
                throw new IllegalStateException("types are required to perform serialization, sorting declared fields: " + elementReader.getTupleSerialization().getSortFields());
            }
        }
        this.keyReaders = HadoopTupleInputStream.getReadersFor(elementReader, keyClasses);
        this.sortReaders = HadoopTupleInputStream.getReadersFor(elementReader, sortClasses);
    }

    @Override
    public TuplePair deserialize(TuplePair tuple) throws IOException {
        if (tuple == null) {
            tuple = this.createTuple();
        }
        Tuple[] tuples = TuplePair.tuples((TuplePair)tuple);
        tuples[0] = this.keyReaders == null ? this.inputStream.readUnTyped(tuples[0]) : this.inputStream.readWith(this.keyReaders, tuples[0]);
        tuples[1] = this.sortReaders == null ? this.inputStream.readUnTyped(tuples[1]) : this.inputStream.readWith(this.sortReaders, tuples[1]);
        return tuple;
    }

    @Override
    protected TuplePair createTuple() {
        return new TuplePair();
    }
}

