/*
 * Decompiled with CFR 0.152.
 */
package cascading.tap.hadoop.io;

import cascading.flow.FlowProcess;
import cascading.flow.SliceCounters;
import cascading.scheme.Scheme;
import cascading.tap.Tap;
import cascading.tap.hadoop.io.MultiRecordReaderIterator;
import cascading.tap.hadoop.io.RecordReaderIterator;
import cascading.tap.hadoop.util.MeasuredRecordReader;
import cascading.tuple.TupleEntrySchemeIterator;
import cascading.util.CloseableIterator;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.RecordReader;

public class HadoopTupleEntrySchemeIterator
extends TupleEntrySchemeIterator<Configuration, RecordReader> {
    private MeasuredRecordReader measuredRecordReader;

    public HadoopTupleEntrySchemeIterator(FlowProcess<? extends Configuration> flowProcess, Tap parentTap, RecordReader recordReader) throws IOException {
        this(flowProcess, parentTap, parentTap.getScheme(), HadoopTupleEntrySchemeIterator.makeIterator(flowProcess, parentTap, recordReader));
    }

    @Deprecated
    public HadoopTupleEntrySchemeIterator(FlowProcess<? extends Configuration> flowProcess, Scheme scheme, CloseableIterator<RecordReader> closeableIterator) {
        super(flowProcess, scheme, closeableIterator, flowProcess.getStringProperty("cascading.source.path"));
    }

    public HadoopTupleEntrySchemeIterator(FlowProcess<? extends Configuration> flowProcess, Tap tap, Scheme scheme, CloseableIterator<RecordReader> closeableIterator) {
        super(flowProcess, tap, scheme, closeableIterator, flowProcess.getStringProperty("cascading.source.path"));
    }

    private static CloseableIterator<RecordReader> makeIterator(FlowProcess<? extends Configuration> flowProcess, Tap parentTap, RecordReader recordReader) throws IOException {
        if (recordReader != null) {
            return new RecordReaderIterator(recordReader);
        }
        return new MultiRecordReaderIterator(flowProcess, parentTap);
    }

    protected RecordReader wrapInput(RecordReader recordReader) {
        if (this.measuredRecordReader == null) {
            this.measuredRecordReader = new MeasuredRecordReader(this.getFlowProcess(), (Enum)SliceCounters.Read_Duration);
        }
        this.measuredRecordReader.setRecordReader((RecordReader)super.wrapInput((Object)recordReader));
        return this.measuredRecordReader;
    }
}

