/*
 * Decompiled with CFR 0.152.
 */
package cascading.tap.hadoop.io;

import cascading.flow.FlowProcess;
import cascading.tap.TapException;
import cascading.tap.partition.Partition;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.TupleEntrySchemeIterator;
import cascading.tuple.util.TupleViews;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;

public class CombineInputPartitionTupleEntryIterator
implements Iterator<Tuple> {
    private final TupleEntrySchemeIterator childIterator;
    private final FlowProcess<? extends Configuration> flowProcess;
    private final TupleEntry partitionEntry;
    private final Fields sourceFields;
    private final Partition partition;
    private final String parentIdentifier;
    private Tuple base;
    private Tuple view;
    private String currentFile;

    public CombineInputPartitionTupleEntryIterator(FlowProcess<? extends Configuration> flowProcess, Fields sourceFields, Partition partition, String parentIdentifier, TupleEntrySchemeIterator childIterator) {
        this.flowProcess = flowProcess;
        this.partition = partition;
        this.parentIdentifier = parentIdentifier;
        this.childIterator = childIterator;
        this.sourceFields = sourceFields;
        this.partitionEntry = new TupleEntry(partition.getPartitionFields(), Tuple.size((int)partition.getPartitionFields().size()));
    }

    @Override
    public boolean hasNext() {
        return this.childIterator.hasNext();
    }

    @Override
    public Tuple next() {
        String currentFile = this.getCurrentFile();
        if (this.currentFile == null || !this.currentFile.equals(currentFile)) {
            this.currentFile = currentFile;
            try {
                String childIdentifier = new Path(currentFile).getParent().toString();
                this.partition.toTuple(childIdentifier.substring(this.parentIdentifier.length() + 1), this.partitionEntry);
            }
            catch (Exception exception) {
                throw new TapException("unable to parse partition given parent: " + this.parentIdentifier + " and child: " + currentFile, (Throwable)exception);
            }
            this.base = TupleViews.createOverride((Fields)this.sourceFields, (Fields)this.partitionEntry.getFields());
            TupleViews.reset((Tuple)this.base, (Object[])new Tuple[]{Tuple.size((int)this.sourceFields.size()), this.partitionEntry.getTuple()});
            this.view = TupleViews.createOverride((Fields)this.sourceFields, (Fields)this.childIterator.getFields());
        }
        Tuple tuple = this.childIterator.next().getTuple();
        TupleViews.reset((Tuple)this.view, (Object[])new Tuple[]{this.base, tuple});
        return this.view;
    }

    private String getCurrentFile() {
        String result = this.flowProcess.getStringProperty("mapreduce.map.input.file");
        if (result == null) {
            result = this.flowProcess.getStringProperty("map.input.file");
        }
        return result;
    }

    @Override
    public void remove() {
        this.childIterator.remove();
    }
}

