/*
 * Decompiled with CFR 0.152.
 */
package cascading.tap.hadoop;

import cascading.flow.FlowProcess;
import cascading.tap.SinkMode;
import cascading.tap.Tap;
import cascading.tap.TapException;
import cascading.tap.hadoop.Hfs;
import cascading.tap.hadoop.io.CombineInputPartitionTupleEntryIterator;
import cascading.tap.hadoop.io.HadoopTupleEntrySchemeIterator;
import cascading.tap.hadoop.io.TapOutputCollector;
import cascading.tap.hadoop.util.Hadoop18TapUtil;
import cascading.tap.partition.BasePartitionTap;
import cascading.tap.partition.Partition;
import cascading.tuple.TupleEntryIterableChainIterator;
import cascading.tuple.TupleEntryIterator;
import cascading.tuple.TupleEntrySchemeCollector;
import cascading.tuple.TupleEntrySchemeIterator;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;

public class PartitionTap
extends BasePartitionTap<Configuration, RecordReader, OutputCollector> {
    @ConstructorProperties(value={"parent", "partition"})
    public PartitionTap(Hfs parent, Partition partition) {
        this(parent, partition, 300);
    }

    @ConstructorProperties(value={"parent", "partition", "openWritesThreshold"})
    public PartitionTap(Hfs parent, Partition partition, int openWritesThreshold) {
        super((Tap)parent, partition, openWritesThreshold);
    }

    @ConstructorProperties(value={"parent", "partition", "sinkMode"})
    public PartitionTap(Hfs parent, Partition partition, SinkMode sinkMode) {
        super((Tap)parent, partition, sinkMode);
    }

    @ConstructorProperties(value={"parent", "partition", "sinkMode", "keepParentOnDelete"})
    public PartitionTap(Hfs parent, Partition partition, SinkMode sinkMode, boolean keepParentOnDelete) {
        this(parent, partition, sinkMode, keepParentOnDelete, 300);
    }

    @ConstructorProperties(value={"parent", "partition", "sinkMode", "keepParentOnDelete", "openWritesThreshold"})
    public PartitionTap(Hfs parent, Partition partition, SinkMode sinkMode, boolean keepParentOnDelete, int openWritesThreshold) {
        super((Tap)parent, partition, sinkMode, keepParentOnDelete, openWritesThreshold);
    }

    protected TupleEntrySchemeCollector createTupleEntrySchemeCollector(FlowProcess<? extends Configuration> flowProcess, Tap parent, String path, long sequence) throws IOException {
        TapOutputCollector outputCollector = new TapOutputCollector(flowProcess, (Tap<Configuration, RecordReader, OutputCollector>)parent, path, sequence);
        return new TupleEntrySchemeCollector(flowProcess, parent, (Object)outputCollector);
    }

    protected TupleEntrySchemeIterator createTupleEntrySchemeIterator(FlowProcess<? extends Configuration> flowProcess, Tap parent, String path, RecordReader recordReader) throws IOException {
        return new HadoopTupleEntrySchemeIterator(flowProcess, new Hfs(parent.getScheme(), path), recordReader);
    }

    protected String getCurrentIdentifier(FlowProcess<? extends Configuration> flowProcess) {
        String identifier = flowProcess.getStringProperty("cascading.source.path");
        if (identifier == null) {
            if (flowProcess.getBooleanProperty("cascading.hadoop.hfs.combine.files", false)) {
                throw new TapException("combined input format support, via 'cascading.hadoop.hfs.combine.files', may not be enabled for use with the PartitionTap");
            }
            throw new TapException("unable to retrieve the current file being processed, 'cascading.source.path' is not set");
        }
        return new Path(identifier).getParent().toString();
    }

    public void sourceConfInit(FlowProcess<? extends Configuration> flowProcess, Configuration conf) {
        try {
            String[] childPartitions = this.getChildPartitionIdentifiers(flowProcess, true);
            ((Hfs)this.getParent()).applySourceConfInitIdentifiers(flowProcess, conf, childPartitions);
        }
        catch (IOException exception) {
            throw new TapException("unable to retrieve child partitions", (Throwable)exception);
        }
    }

    public TupleEntryIterator openForRead(FlowProcess<? extends Configuration> flowProcess, RecordReader input) throws IOException {
        if (flowProcess.getBooleanProperty("cascading.hadoop.hfs.combine.files", false)) {
            return new CombinePartitionIterator(flowProcess, input);
        }
        return super.openForRead(flowProcess, (Object)input);
    }

    public boolean commitResource(Configuration conf) throws IOException {
        Hadoop18TapUtil.writeSuccessMarker(conf, ((Hfs)this.parent).getPath());
        return super.commitResource((Object)conf);
    }

    private class CombinePartitionIterator
    extends TupleEntryIterableChainIterator {
        public CombinePartitionIterator(FlowProcess<? extends Configuration> flowProcess, RecordReader input) throws IOException {
            super(PartitionTap.this.getSourceFields());
            ArrayList<CombineInputPartitionTupleEntryIterator> iterators = new ArrayList<CombineInputPartitionTupleEntryIterator>();
            if (input == null) {
                throw new IOException("input cannot be null");
            }
            String identifier = PartitionTap.this.parent.getFullIdentifier(flowProcess);
            iterators.add(this.createPartitionEntryIterator(flowProcess, input, identifier));
            this.reset(iterators);
        }

        private CombineInputPartitionTupleEntryIterator createPartitionEntryIterator(FlowProcess<? extends Configuration> flowProcess, RecordReader input, String parentIdentifier) throws IOException {
            TupleEntrySchemeIterator schemeIterator = PartitionTap.this.createTupleEntrySchemeIterator(flowProcess, PartitionTap.this.parent, (String)null, input);
            return new CombineInputPartitionTupleEntryIterator(flowProcess, PartitionTap.this.getSourceFields(), PartitionTap.this.partition, parentIdentifier, schemeIterator);
        }
    }
}

