/*
 * Decompiled with CFR 0.152.
 */
package cascading.tap.hadoop;

import cascading.property.Props;
import java.util.Map;
import java.util.Properties;

public class HfsProps
extends Props {
    public static final String TEMPORARY_DIRECTORY = "cascading.tmp.dir";
    public static final String LOCAL_MODE_SCHEME = "cascading.hadoop.localmode.scheme";
    public static final String COMBINE_INPUT_FILES = "cascading.hadoop.hfs.combine.files";
    public static final String COMBINE_INPUT_FILES_SAFE_MODE = "cascading.hadoop.hfs.combine.safemode";
    public static final String COMBINE_INPUT_FILES_SIZE_MAX = "cascading.hadoop.hfs.combine.max.size";
    protected String temporaryDirectory;
    protected String localModeScheme;
    protected Boolean useCombinedInput;
    protected Long combinedInputMaxSize;
    protected Boolean combinedInputSafeMode;

    public static void setTemporaryDirectory(Map<Object, Object> properties, String temporaryDirectory) {
        properties.put(TEMPORARY_DIRECTORY, temporaryDirectory);
    }

    public static void setLocalModeScheme(Map<Object, Object> properties, String scheme) {
        properties.put(LOCAL_MODE_SCHEME, scheme);
    }

    public static void setUseCombinedInput(Map<Object, Object> properties, Boolean combine) {
        if (combine != null) {
            properties.put(COMBINE_INPUT_FILES, Boolean.toString(combine));
        }
    }

    public static void setUseCombinedInputSafeMode(Map<Object, Object> properties, Boolean safeMode) {
        if (safeMode != null) {
            properties.put(COMBINE_INPUT_FILES_SAFE_MODE, Boolean.toString(safeMode));
        }
    }

    public static void setCombinedInputMaxSize(Map<Object, Object> properties, Long size) {
        if (size != null) {
            properties.put(COMBINE_INPUT_FILES_SIZE_MAX, Long.toString(size));
        }
    }

    public static HfsProps hfsProps() {
        return new HfsProps();
    }

    public String getTemporaryDirectory() {
        return this.temporaryDirectory;
    }

    public HfsProps setTemporaryDirectory(String temporaryDirectory) {
        this.temporaryDirectory = temporaryDirectory;
        return this;
    }

    public String getLocalModeScheme() {
        return this.localModeScheme;
    }

    public HfsProps setLocalModeScheme(String localModeScheme) {
        this.localModeScheme = localModeScheme;
        return this;
    }

    public boolean isUseCombinedInput() {
        return this.useCombinedInput;
    }

    public HfsProps setUseCombinedInput(boolean useCombinedInput) {
        this.useCombinedInput = useCombinedInput;
        return this;
    }

    public Long getCombinedInputMaxSize() {
        return this.combinedInputMaxSize;
    }

    public HfsProps setCombinedInputMaxSize(long combinedInputMaxSize) {
        this.combinedInputMaxSize = combinedInputMaxSize;
        return this;
    }

    public boolean isUseCombinedInputSafeMode() {
        return this.combinedInputSafeMode;
    }

    public HfsProps setUseCombinedInputSafeMode(boolean combinedInputSafeMode) {
        this.combinedInputSafeMode = combinedInputSafeMode;
        return this;
    }

    protected void addPropertiesTo(Properties properties) {
        HfsProps.setTemporaryDirectory(properties, this.temporaryDirectory);
        HfsProps.setLocalModeScheme(properties, this.localModeScheme);
        HfsProps.setUseCombinedInput(properties, this.useCombinedInput);
        HfsProps.setCombinedInputMaxSize(properties, this.combinedInputMaxSize);
        HfsProps.setUseCombinedInputSafeMode(properties, this.combinedInputSafeMode);
    }
}

