/*
 * Decompiled with CFR 0.152.
 */
package cascading.scheme.hadoop;

import cascading.flow.FlowProcess;
import cascading.management.annotation.Property;
import cascading.management.annotation.PropertyDescription;
import cascading.management.annotation.Visibility;
import cascading.scheme.Scheme;
import cascading.scheme.SinkCall;
import cascading.scheme.SourceCall;
import cascading.scheme.hadoop.TextLine;
import cascading.scheme.util.DelimitedParser;
import cascading.tap.CompositeTap;
import cascading.tap.Tap;
import cascading.tap.hadoop.Hfs;
import cascading.tap.type.TapWith;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.util.TupleViews;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;

public class TextDelimited
extends TextLine {
    public static final String DEFAULT_CHARSET = "UTF-8";
    protected final DelimitedParser delimitedParser;
    private boolean skipHeader;
    private final boolean writeHeader;

    public TextDelimited() {
        this(Fields.ALL, null, "\t", null, null);
    }

    @ConstructorProperties(value={"hasHeader", "delimiter"})
    public TextDelimited(boolean hasHeader, String delimiter) {
        this(Fields.ALL, null, hasHeader, delimiter, null, (Class[])null);
    }

    @ConstructorProperties(value={"hasHeader", "delimiter", "quote"})
    public TextDelimited(boolean hasHeader, String delimiter, String quote) {
        this(Fields.ALL, null, hasHeader, delimiter, quote, (Class[])null);
    }

    @ConstructorProperties(value={"hasHeader", "delimitedParser"})
    public TextDelimited(boolean hasHeader, DelimitedParser delimitedParser) {
        this(Fields.ALL, null, hasHeader, hasHeader, delimitedParser);
    }

    @ConstructorProperties(value={"delimitedParser"})
    public TextDelimited(DelimitedParser delimitedParser) {
        this(Fields.ALL, null, true, true, delimitedParser);
    }

    @ConstructorProperties(value={"sinkCompression", "hasHeader", "delimitedParser"})
    public TextDelimited(TextLine.Compress sinkCompression, boolean hasHeader, DelimitedParser delimitedParser) {
        this(Fields.ALL, sinkCompression, hasHeader, hasHeader, delimitedParser);
    }

    @ConstructorProperties(value={"sinkCompression", "delimitedParser"})
    public TextDelimited(TextLine.Compress sinkCompression, DelimitedParser delimitedParser) {
        this(Fields.ALL, sinkCompression, true, true, delimitedParser);
    }

    @ConstructorProperties(value={"sinkCompression", "hasHeader", "delimiter", "quote"})
    public TextDelimited(TextLine.Compress sinkCompression, boolean hasHeader, String delimiter, String quote) {
        this(Fields.ALL, sinkCompression, hasHeader, delimiter, quote, (Class[])null);
    }

    @ConstructorProperties(value={"fields"})
    public TextDelimited(Fields fields) {
        this(fields, null, "\t", null, null);
    }

    @ConstructorProperties(value={"fields", "delimiter"})
    public TextDelimited(Fields fields, String delimiter) {
        this(fields, null, delimiter, null, null);
    }

    @ConstructorProperties(value={"fields", "hasHeader", "delimiter"})
    public TextDelimited(Fields fields, boolean hasHeader, String delimiter) {
        this(fields, null, hasHeader, hasHeader, delimiter, null, null);
    }

    @ConstructorProperties(value={"fields", "skipHeader", "writeHeader", "delimiter"})
    public TextDelimited(Fields fields, boolean skipHeader, boolean writeHeader, String delimiter) {
        this(fields, null, skipHeader, writeHeader, delimiter, null, null);
    }

    @ConstructorProperties(value={"fields", "delimiter", "types"})
    public TextDelimited(Fields fields, String delimiter, Class[] types) {
        this(fields, null, delimiter, null, types);
    }

    @ConstructorProperties(value={"fields", "hasHeader", "delimiter", "types"})
    public TextDelimited(Fields fields, boolean hasHeader, String delimiter, Class[] types) {
        this(fields, null, hasHeader, hasHeader, delimiter, null, types);
    }

    @ConstructorProperties(value={"fields", "skipHeader", "writeHeader", "delimiter", "types"})
    public TextDelimited(Fields fields, boolean skipHeader, boolean writeHeader, String delimiter, Class[] types) {
        this(fields, null, skipHeader, writeHeader, delimiter, null, types);
    }

    @ConstructorProperties(value={"fields", "delimiter", "quote", "types"})
    public TextDelimited(Fields fields, String delimiter, String quote, Class[] types) {
        this(fields, null, delimiter, quote, types);
    }

    @ConstructorProperties(value={"fields", "hasHeader", "delimiter", "quote", "types"})
    public TextDelimited(Fields fields, boolean hasHeader, String delimiter, String quote, Class[] types) {
        this(fields, null, hasHeader, hasHeader, delimiter, quote, types);
    }

    @ConstructorProperties(value={"fields", "skipHeader", "writeHeader", "delimiter", "quote", "types"})
    public TextDelimited(Fields fields, boolean skipHeader, boolean writeHeader, String delimiter, String quote, Class[] types) {
        this(fields, null, skipHeader, writeHeader, delimiter, quote, types);
    }

    @ConstructorProperties(value={"fields", "delimiter", "quote", "types", "safe"})
    public TextDelimited(Fields fields, String delimiter, String quote, Class[] types, boolean safe) {
        this(fields, null, delimiter, quote, types, safe);
    }

    @ConstructorProperties(value={"fields", "hasHeader", "delimiter", "quote", "types", "safe"})
    public TextDelimited(Fields fields, boolean hasHeader, String delimiter, String quote, Class[] types, boolean safe) {
        this(fields, null, hasHeader, hasHeader, delimiter, quote, types, safe);
    }

    @ConstructorProperties(value={"fields", "hasHeader", "delimiter", "quote", "types", "safe", "charsetName"})
    public TextDelimited(Fields fields, boolean hasHeader, String delimiter, String quote, Class[] types, boolean safe, String charsetName) {
        this(fields, null, hasHeader, hasHeader, delimiter, true, quote, types, safe, charsetName);
    }

    @ConstructorProperties(value={"fields", "skipHeader", "writeHeader", "delimiter", "quote", "types", "safe"})
    public TextDelimited(Fields fields, boolean skipHeader, boolean writeHeader, String delimiter, String quote, Class[] types, boolean safe) {
        this(fields, null, skipHeader, writeHeader, delimiter, quote, types, safe);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "delimiter"})
    public TextDelimited(Fields fields, TextLine.Compress sinkCompression, String delimiter) {
        this(fields, sinkCompression, delimiter, null, null);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "hasHeader", "delimiter"})
    public TextDelimited(Fields fields, TextLine.Compress sinkCompression, boolean hasHeader, String delimiter) {
        this(fields, sinkCompression, hasHeader, hasHeader, delimiter, null, null);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "skipHeader", "writeHeader", "delimiter"})
    public TextDelimited(Fields fields, TextLine.Compress sinkCompression, boolean skipHeader, boolean writeHeader, String delimiter) {
        this(fields, sinkCompression, skipHeader, writeHeader, delimiter, null, null);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "delimiter", "types"})
    public TextDelimited(Fields fields, TextLine.Compress sinkCompression, String delimiter, Class[] types) {
        this(fields, sinkCompression, delimiter, null, types);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "hasHeader", "delimiter", "types"})
    public TextDelimited(Fields fields, TextLine.Compress sinkCompression, boolean hasHeader, String delimiter, Class[] types) {
        this(fields, sinkCompression, hasHeader, hasHeader, delimiter, null, types);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "skipHeader", "writeHeader", "delimiter", "types"})
    public TextDelimited(Fields fields, TextLine.Compress sinkCompression, boolean skipHeader, boolean writeHeader, String delimiter, Class[] types) {
        this(fields, sinkCompression, skipHeader, writeHeader, delimiter, null, types);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "delimiter", "types", "safe"})
    public TextDelimited(Fields fields, TextLine.Compress sinkCompression, String delimiter, Class[] types, boolean safe) {
        this(fields, sinkCompression, delimiter, null, types, safe);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "hasHeader", "delimiter", "types", "safe"})
    public TextDelimited(Fields fields, TextLine.Compress sinkCompression, boolean hasHeader, String delimiter, Class[] types, boolean safe) {
        this(fields, sinkCompression, hasHeader, hasHeader, delimiter, null, types, safe);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "hasHeader", "delimiter", "types", "safe", "charsetName"})
    public TextDelimited(Fields fields, TextLine.Compress sinkCompression, boolean hasHeader, String delimiter, Class[] types, boolean safe, String charsetName) {
        this(fields, sinkCompression, hasHeader, hasHeader, delimiter, true, null, types, safe, charsetName);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "skipHeader", "writeHeader", "delimiter", "types", "safe"})
    public TextDelimited(Fields fields, TextLine.Compress sinkCompression, boolean skipHeader, boolean writeHeader, String delimiter, Class[] types, boolean safe) {
        this(fields, sinkCompression, skipHeader, writeHeader, delimiter, null, types, safe);
    }

    @ConstructorProperties(value={"fields", "delimiter", "quote"})
    public TextDelimited(Fields fields, String delimiter, String quote) {
        this(fields, null, delimiter, quote);
    }

    @ConstructorProperties(value={"fields", "hasHeader", "delimiter", "quote"})
    public TextDelimited(Fields fields, boolean hasHeader, String delimiter, String quote) {
        this(fields, null, hasHeader, hasHeader, delimiter, quote);
    }

    @ConstructorProperties(value={"fields", "skipHeader", "writeHeader", "delimiter", "quote"})
    public TextDelimited(Fields fields, boolean skipHeader, boolean writeHeader, String delimiter, String quote) {
        this(fields, null, skipHeader, writeHeader, delimiter, quote);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "delimiter", "quote"})
    public TextDelimited(Fields fields, TextLine.Compress sinkCompression, String delimiter, String quote) {
        this(fields, sinkCompression, false, false, delimiter, true, quote, null, true);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "hasHeader", "delimiter", "quote"})
    public TextDelimited(Fields fields, TextLine.Compress sinkCompression, boolean hasHeader, String delimiter, String quote) {
        this(fields, sinkCompression, hasHeader, hasHeader, delimiter, true, quote, null, true);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "hasHeader", "delimiter", "quote", "charsetName"})
    public TextDelimited(Fields fields, TextLine.Compress sinkCompression, boolean hasHeader, String delimiter, String quote, String charsetName) {
        this(fields, sinkCompression, hasHeader, hasHeader, delimiter, true, quote, null, true, charsetName);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "skipHeader", "writeHeader", "delimiter", "quote"})
    public TextDelimited(Fields fields, TextLine.Compress sinkCompression, boolean skipHeader, boolean writeHeader, String delimiter, String quote) {
        this(fields, sinkCompression, skipHeader, writeHeader, delimiter, true, quote, null, true);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "delimiter", "quote", "types"})
    public TextDelimited(Fields fields, TextLine.Compress sinkCompression, String delimiter, String quote, Class[] types) {
        this(fields, sinkCompression, false, false, delimiter, true, quote, types, true);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "hasHeader", "delimiter", "quote", "types"})
    public TextDelimited(Fields fields, TextLine.Compress sinkCompression, boolean hasHeader, String delimiter, String quote, Class[] types) {
        this(fields, sinkCompression, hasHeader, hasHeader, delimiter, true, quote, types, true);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "skipHeader", "writeHeader", "delimiter", "quote", "types"})
    public TextDelimited(Fields fields, TextLine.Compress sinkCompression, boolean skipHeader, boolean writeHeader, String delimiter, String quote, Class[] types) {
        this(fields, sinkCompression, skipHeader, writeHeader, delimiter, true, quote, types, true);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "delimiter", "quote", "types", "safe"})
    public TextDelimited(Fields fields, TextLine.Compress sinkCompression, String delimiter, String quote, Class[] types, boolean safe) {
        this(fields, sinkCompression, false, false, delimiter, true, quote, types, safe);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "hasHeader", "delimiter", "quote", "types", "safe"})
    public TextDelimited(Fields fields, TextLine.Compress sinkCompression, boolean hasHeader, String delimiter, String quote, Class[] types, boolean safe) {
        this(fields, sinkCompression, hasHeader, hasHeader, delimiter, true, quote, types, safe);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "skipHeader", "writeHeader", "delimiter", "quote", "types", "safe"})
    public TextDelimited(Fields fields, TextLine.Compress sinkCompression, boolean skipHeader, boolean writeHeader, String delimiter, String quote, Class[] types, boolean safe) {
        this(fields, sinkCompression, skipHeader, writeHeader, delimiter, true, quote, types, safe);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "skipHeader", "writeHeader", "delimiter", "strict", "quote", "types", "safe"})
    public TextDelimited(Fields fields, TextLine.Compress sinkCompression, boolean skipHeader, boolean writeHeader, String delimiter, boolean strict, String quote, Class[] types, boolean safe) {
        this(fields, sinkCompression, skipHeader, writeHeader, delimiter, strict, quote, types, safe, DEFAULT_CHARSET);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "skipHeader", "writeHeader", "delimiter", "strict", "quote", "types", "safe", "charsetName"})
    public TextDelimited(Fields fields, TextLine.Compress sinkCompression, boolean skipHeader, boolean writeHeader, String delimiter, boolean strict, String quote, Class[] types, boolean safe, String charsetName) {
        this(fields, sinkCompression, skipHeader, writeHeader, charsetName, new DelimitedParser(delimiter, quote, types, strict, safe));
    }

    @ConstructorProperties(value={"fields", "skipHeader", "writeHeader", "delimitedParser"})
    public TextDelimited(Fields fields, boolean skipHeader, boolean writeHeader, DelimitedParser delimitedParser) {
        this(fields, null, skipHeader, writeHeader, null, delimitedParser);
    }

    @ConstructorProperties(value={"fields", "hasHeader", "delimitedParser"})
    public TextDelimited(Fields fields, boolean hasHeader, DelimitedParser delimitedParser) {
        this(fields, null, hasHeader, hasHeader, null, delimitedParser);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "skipHeader", "writeHeader", "delimitedParser"})
    public TextDelimited(Fields fields, TextLine.Compress sinkCompression, boolean skipHeader, boolean writeHeader, DelimitedParser delimitedParser) {
        this(fields, sinkCompression, skipHeader, writeHeader, null, delimitedParser);
    }

    @ConstructorProperties(value={"fields", "sinkCompression", "skipHeader", "writeHeader", "charsetName", "delimitedParser"})
    public TextDelimited(Fields fields, TextLine.Compress sinkCompression, boolean skipHeader, boolean writeHeader, String charsetName, DelimitedParser delimitedParser) {
        super(sinkCompression);
        this.delimitedParser = delimitedParser;
        this.setSinkFields(fields);
        this.setSourceFields(fields);
        this.skipHeader = skipHeader;
        this.writeHeader = writeHeader;
        this.setCharsetName(charsetName);
    }

    @Property(name="delimiter", visibility=Visibility.PUBLIC)
    @PropertyDescription(value="The delimiter used to separate fields.")
    public String getDelimiter() {
        return this.delimitedParser.getDelimiter();
    }

    @Property(name="quote", visibility=Visibility.PUBLIC)
    @PropertyDescription(value="The string used for quoting.")
    public String getQuote() {
        return this.delimitedParser.getQuote();
    }

    public boolean isSymmetrical() {
        return super.isSymmetrical() && this.skipHeader == this.writeHeader;
    }

    public void setSinkFields(Fields sinkFields) {
        super.setSourceFields(sinkFields);
        super.setSinkFields(sinkFields);
        if (this.delimitedParser != null) {
            this.delimitedParser.reset(this.getSourceFields(), this.getSinkFields());
        }
    }

    public void setSourceFields(Fields sourceFields) {
        super.setSourceFields(sourceFields);
        super.setSinkFields(sourceFields);
        if (this.delimitedParser != null) {
            this.delimitedParser.reset(this.getSourceFields(), this.getSinkFields());
        }
    }

    public Fields retrieveSourceFields(FlowProcess<? extends Configuration> flowProcess, Tap tap) {
        if (!this.skipHeader || !this.getSourceFields().isUnknown()) {
            return this.getSourceFields();
        }
        if (tap instanceof CompositeTap) {
            tap = (Tap)((CompositeTap)tap).getChildTaps().next();
        }
        tap = tap instanceof TapWith ? ((TapWith)tap).withScheme((Scheme)new TextLine(new Fields(new Comparable[]{"line"}), this.charsetName)).asTap() : new Hfs(new TextLine(new Fields(new Comparable[]{"line"}), this.charsetName), tap.getFullIdentifier(flowProcess));
        this.setSourceFields(this.delimitedParser.parseFirstLine(flowProcess, tap));
        return this.getSourceFields();
    }

    @Override
    public void presentSourceFields(FlowProcess<? extends Configuration> flowProcess, Tap tap, Fields fields) {
        this.presentSourceFieldsInternal(fields);
    }

    @Override
    public void presentSinkFields(FlowProcess<? extends Configuration> flowProcess, Tap tap, Fields fields) {
        this.presentSinkFieldsInternal(fields);
    }

    @Override
    public void sourcePrepare(FlowProcess<? extends Configuration> flowProcess, SourceCall<Object[], RecordReader> sourceCall) {
        super.sourcePrepare(flowProcess, sourceCall);
        sourceCall.getIncomingEntry().setTuple(TupleViews.createObjectArray());
    }

    @Override
    public boolean source(FlowProcess<? extends Configuration> flowProcess, SourceCall<Object[], RecordReader> sourceCall) throws IOException {
        Object[] context = (Object[])sourceCall.getContext();
        if (!((RecordReader)sourceCall.getInput()).next(context[0], context[1])) {
            return false;
        }
        if (this.skipHeader && ((LongWritable)context[0]).get() == 0L && !((RecordReader)sourceCall.getInput()).next(context[0], context[1])) {
            return false;
        }
        Object[] split = this.delimitedParser.parseLine(this.makeEncodedString(context));
        Tuple tuple = sourceCall.getIncomingEntry().getTuple();
        TupleViews.reset((Tuple)tuple, (Object[])split);
        return true;
    }

    @Override
    public void sinkPrepare(FlowProcess<? extends Configuration> flowProcess, SinkCall<Object[], OutputCollector> sinkCall) throws IOException {
        sinkCall.setContext((Object)new Object[3]);
        ((Object[])sinkCall.getContext())[0] = new Text();
        ((Object[])sinkCall.getContext())[1] = new StringBuilder(4096);
        ((Object[])sinkCall.getContext())[2] = Charset.forName(this.charsetName);
        if (this.writeHeader) {
            this.writeHeader(sinkCall);
        }
    }

    protected void writeHeader(SinkCall<Object[], OutputCollector> sinkCall) throws IOException {
        Fields fields = sinkCall.getOutgoingEntry().getFields();
        Text text = (Text)((Object[])sinkCall.getContext())[0];
        StringBuilder line = (StringBuilder)((Object[])sinkCall.getContext())[1];
        Charset charset = (Charset)((Object[])sinkCall.getContext())[2];
        line = (StringBuilder)this.delimitedParser.joinFirstLine((Iterable)fields, (Appendable)line);
        text.set(line.toString().getBytes(charset));
        ((OutputCollector)sinkCall.getOutput()).collect(null, (Object)text);
        line.setLength(0);
    }

    @Override
    public void sink(FlowProcess<? extends Configuration> flowProcess, SinkCall<Object[], OutputCollector> sinkCall) throws IOException {
        TupleEntry tupleEntry = sinkCall.getOutgoingEntry();
        Text text = (Text)((Object[])sinkCall.getContext())[0];
        StringBuilder line = (StringBuilder)((Object[])sinkCall.getContext())[1];
        Charset charset = (Charset)((Object[])sinkCall.getContext())[2];
        Iterable strings = tupleEntry.asIterableOf(String.class);
        line = (StringBuilder)this.delimitedParser.joinLine(strings, (Appendable)line);
        text.set(line.toString().getBytes(charset));
        ((OutputCollector)sinkCall.getOutput()).collect(null, (Object)text);
        line.setLength(0);
    }

    @Override
    public String getExtension() {
        switch (this.getDelimiter().trim()) {
            case "\t": {
                return "tsv";
            }
            case ",": {
                return "csv";
            }
        }
        return "txt";
    }
}

