/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.hadoop.util;

import cascading.CascadingException;
import cascading.flow.FlowElement;
import cascading.flow.FlowException;
import cascading.flow.hadoop.util.JavaObjectSerializer;
import cascading.flow.hadoop.util.ObjectSerializer;
import cascading.flow.planner.BaseFlowStep;
import cascading.flow.planner.PlatformInfo;
import cascading.flow.planner.Scope;
import cascading.pipe.Group;
import cascading.scheme.hadoop.TextLine;
import cascading.tap.hadoop.Hfs;
import cascading.tuple.Fields;
import cascading.util.LogUtil;
import cascading.util.Util;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopUtil {
    public static final String CASCADING_FLOW_EXECUTING = "cascading.flow.executing";
    private static final Logger LOG = LoggerFactory.getLogger(HadoopUtil.class);
    private static final String ENCODING = "US-ASCII";
    private static final Class<?> DEFAULT_OBJECT_SERIALIZER = JavaObjectSerializer.class;
    private static PlatformInfo platformInfo;

    public static void setIsInflow(Configuration conf) {
        conf.setBoolean(CASCADING_FLOW_EXECUTING, true);
    }

    public static boolean isInflow(Configuration conf) {
        return conf.getBoolean(CASCADING_FLOW_EXECUTING, false);
    }

    public static void initLog4j(JobConf configuration) {
        HadoopUtil.initLog4j((Configuration)configuration);
    }

    public static void initLog4j(Configuration configuration) {
        String[] elements;
        String values = configuration.get("log4j.logger", null);
        if (values == null || values.length() == 0) {
            return;
        }
        if (!Util.hasClass((String)"org.apache.log4j.Logger")) {
            LOG.info("org.apache.log4j.Logger is not in the current CLASSPATH, not setting log4j.logger properties");
            return;
        }
        for (String element : elements = values.split(",")) {
            LogUtil.setLog4jLevel((String[])element.split("="));
        }
    }

    public static JobConf asJobConfInstance(Configuration configuration) {
        if (configuration instanceof JobConf) {
            return (JobConf)configuration;
        }
        return new JobConf(configuration);
    }

    public static <C> C copyJobConf(C parentJobConf) {
        return HadoopUtil.copyConfiguration(parentJobConf);
    }

    public static JobConf copyJobConf(JobConf parentJobConf) {
        if (parentJobConf == null) {
            throw new IllegalArgumentException("parent may not be null");
        }
        Configuration configurationCopy = new Configuration((Configuration)parentJobConf);
        JobConf jobConf = new JobConf(configurationCopy);
        jobConf.getCredentials().addAll(parentJobConf.getCredentials());
        return jobConf;
    }

    public static JobConf createJobConf(Map<Object, Object> properties) {
        return HadoopUtil.createJobConf(properties, null);
    }

    public static JobConf createJobConf(Map<Object, Object> properties, JobConf defaultJobconf) {
        JobConf jobConf;
        JobConf jobConf2 = jobConf = defaultJobconf == null ? new JobConf() : HadoopUtil.copyJobConf(defaultJobconf);
        if (properties == null) {
            return jobConf;
        }
        return HadoopUtil.copyConfiguration(properties, jobConf);
    }

    public static <C> C copyConfiguration(C parent) {
        if (parent == null) {
            throw new IllegalArgumentException("parent may not be null");
        }
        if (!(parent instanceof Configuration)) {
            throw new IllegalArgumentException("parent must be of type Configuration");
        }
        Configuration conf = (Configuration)parent;
        Configuration configurationCopy = new Configuration(conf);
        C copiedConf = HadoopUtil.callCopyConstructor(parent.getClass(), configurationCopy);
        if (Util.hasInstanceMethod(parent, (String)"getCredentials", null)) {
            Object result = Util.invokeInstanceMethod(parent, (String)"getCredentials", null, null);
            Object credentials = Util.invokeInstanceMethod(copiedConf, (String)"getCredentials", null, null);
            Util.invokeInstanceMethod((Object)credentials, (String)"addAll", (Object[])new Object[]{result}, (Class[])new Class[]{credentials.getClass()});
        }
        return copiedConf;
    }

    protected static <C extends Configuration> C callCopyConstructor(Class type, Configuration parent) {
        try {
            Constructor constructor = type.getConstructor(parent.getClass());
            return (C)((Configuration)constructor.newInstance(parent));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
            throw new CascadingException("unable to create copy of: " + type);
        }
    }

    public static <C extends Configuration> C copyConfiguration(Map<Object, Object> srcProperties, C dstConfiguration) {
        HashSet<Object> keys = new HashSet<Object>(srcProperties.keySet());
        if (srcProperties instanceof Properties) {
            keys.addAll(((Properties)srcProperties).stringPropertyNames());
        }
        for (Object e : keys) {
            Object value = srcProperties.get(e);
            if (value == null && srcProperties instanceof Properties && e instanceof String) {
                value = ((Properties)srcProperties).getProperty((String)e);
            }
            if (value == null || value instanceof Class || value instanceof JobConf) continue;
            dstConfiguration.set(e.toString(), value.toString());
        }
        return dstConfiguration;
    }

    public static Map<Object, Object> createProperties(Configuration jobConf) {
        HashMap<Object, Object> properties = new HashMap<Object, Object>();
        if (jobConf == null) {
            return properties;
        }
        for (Map.Entry entry : jobConf) {
            properties.put(entry.getKey(), entry.getValue());
        }
        return properties;
    }

    public static Thread getHDFSShutdownHook() {
        Exception caughtException;
        try {
            FileSystem.getLocal((Configuration)new JobConf());
            Field field = FileSystem.class.getDeclaredField("clientFinalizer");
            field.setAccessible(true);
            Thread finalizer = (Thread)field.get(null);
            if (finalizer != null) {
                Runtime.getRuntime().removeShutdownHook(finalizer);
            }
            return finalizer;
        }
        catch (NoSuchFieldException exception) {
            caughtException = exception;
        }
        catch (IllegalAccessException exception) {
            caughtException = exception;
        }
        catch (IOException exception) {
            caughtException = exception;
        }
        LOG.debug("unable to find and remove client hdfs shutdown hook, received exception: {}", (Object)caughtException.getClass().getName());
        return null;
    }

    public static String encodeBytes(byte[] bytes) {
        try {
            return new String(Base64.encodeBase64((byte[])bytes), ENCODING);
        }
        catch (UnsupportedEncodingException exception) {
            throw new RuntimeException(exception);
        }
    }

    public static byte[] decodeBytes(String string) {
        try {
            byte[] bytes = string.getBytes(ENCODING);
            return Base64.decodeBase64((byte[])bytes);
        }
        catch (UnsupportedEncodingException exception) {
            throw new RuntimeException(exception);
        }
    }

    public static <T> ObjectSerializer instantiateSerializer(Configuration conf, Class<T> type) throws ClassNotFoundException {
        ObjectSerializer objectSerializer;
        String serializerClassName = conf.get("cascading.util.serializer");
        Class<?> flowSerializerClass = serializerClassName == null || serializerClassName.length() == 0 ? DEFAULT_OBJECT_SERIALIZER : Class.forName(serializerClassName);
        try {
            objectSerializer = (ObjectSerializer)flowSerializerClass.newInstance();
            if (objectSerializer instanceof Configurable) {
                ((Configurable)objectSerializer).setConf(conf);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IllegalArgumentException("Unable to instantiate serializer \"" + flowSerializerClass.getName() + "\" for class: " + type.getName());
        }
        if (!objectSerializer.accepts(type)) {
            throw new IllegalArgumentException(serializerClassName + " won't accept objects of class " + type.toString());
        }
        return objectSerializer;
    }

    public static <T> String serializeBase64(T object, Configuration conf) throws IOException {
        return HadoopUtil.serializeBase64(object, conf, true);
    }

    public static <T> String serializeBase64(T object, Configuration conf, boolean compress) throws IOException {
        ObjectSerializer objectSerializer;
        try {
            objectSerializer = HadoopUtil.instantiateSerializer(conf, object.getClass());
        }
        catch (ClassNotFoundException exception) {
            throw new IOException(exception);
        }
        return HadoopUtil.encodeBytes(objectSerializer.serialize(object, compress));
    }

    public static <T> T deserializeBase64(String string, Configuration conf, Class<T> type) throws IOException {
        return HadoopUtil.deserializeBase64(string, conf, type, true);
    }

    public static <T> T deserializeBase64(String string, Configuration conf, Class<T> type, boolean decompress) throws IOException {
        ObjectSerializer objectSerializer;
        if (string == null || string.length() == 0) {
            return null;
        }
        try {
            objectSerializer = HadoopUtil.instantiateSerializer(conf, type);
        }
        catch (ClassNotFoundException exception) {
            throw new IOException(exception);
        }
        return objectSerializer.deserialize(HadoopUtil.decodeBytes(string), type, decompress);
    }

    public static Class findMainClass(Class defaultType) {
        return Util.findMainClass((Class)defaultType, (String)"org.apache.hadoop");
    }

    public static Map<String, String> getConfig(Configuration defaultConf, Configuration updatedConf) {
        HashMap<String, String> configs = new HashMap<String, String>();
        for (Map.Entry entry : updatedConf) {
            configs.put((String)entry.getKey(), (String)entry.getValue());
        }
        for (Map.Entry entry : defaultConf) {
            if (entry.getValue() == null) continue;
            String updatedValue = (String)configs.get(entry.getKey());
            if (updatedValue == null && entry.getValue() == null) {
                configs.remove(entry.getKey());
            }
            if (updatedValue != null && updatedValue.equals(entry.getValue())) {
                configs.remove(entry.getKey());
            }
            configs.remove("mapred.working.dir");
            configs.remove("mapreduce.job.working.dir");
        }
        return configs;
    }

    public static JobConf[] getJobConfs(Configuration job, List<Map<String, String>> configs) {
        JobConf[] jobConfs = new JobConf[configs.size()];
        for (int i = 0; i < jobConfs.length; ++i) {
            jobConfs[i] = (JobConf)HadoopUtil.mergeConf(job, configs.get(i), false);
        }
        return jobConfs;
    }

    public static <J extends Configuration> J mergeConf(J job, Map<String, String> config, boolean directly) {
        J currentConf = directly ? job : (job instanceof JobConf ? HadoopUtil.copyJobConf((JobConf)job) : new Configuration(job));
        for (String key : config.keySet()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("merging key: {} value: {}", (Object)key, (Object)config.get(key));
            }
            currentConf.set(key, config.get(key));
        }
        return currentConf;
    }

    public static Configuration removePropertiesFrom(Configuration jobConf, String ... keys) {
        Map<Object, Object> properties = HadoopUtil.createProperties(jobConf);
        for (String key : keys) {
            properties.remove(key);
        }
        return HadoopUtil.copyConfiguration(properties, new JobConf());
    }

    public static boolean removeStateFromDistCache(Configuration conf, String path) throws IOException {
        return new Hfs(new TextLine(), path).deleteResource(conf);
    }

    public static PlatformInfo getPlatformInfo() {
        if (platformInfo == null) {
            platformInfo = HadoopUtil.getPlatformInfoInternal(JobConf.class, "org/apache/hadoop", "Hadoop");
        }
        return platformInfo;
    }

    public static PlatformInfo getPlatformInfo(Class type, String attributePath, String platformName) {
        if (platformInfo == null) {
            platformInfo = HadoopUtil.getPlatformInfoInternal(type, attributePath, platformName);
        }
        return platformInfo;
    }

    public static PlatformInfo createPlatformInfo(Class type, String attributePath, String platformName) {
        return HadoopUtil.getPlatformInfoInternal(type, attributePath, platformName);
    }

    private static PlatformInfo getPlatformInfoInternal(Class type, String attributePath, String platformName) {
        Manifest manifest;
        URL url = type.getResource(type.getSimpleName() + ".class");
        if (url == null || !url.toString().startsWith("jar")) {
            return new PlatformInfo(platformName, null, null);
        }
        String path = url.toString();
        path = path.substring(0, path.lastIndexOf("!") + 1);
        String manifestPath = path + "/META-INF/MANIFEST.MF";
        String parsedVersion = Util.findVersion((String)path.substring(0, path.length() - 1));
        try {
            manifest = new Manifest(new URL(manifestPath).openStream());
        }
        catch (IOException exception) {
            LOG.warn("unable to get manifest from {}: {}", (Object)manifestPath, (Object)exception.getMessage());
            return new PlatformInfo(platformName, null, parsedVersion);
        }
        Attributes attributes = manifest.getAttributes(attributePath);
        if (attributes == null) {
            attributes = manifest.getMainAttributes();
        }
        if (attributes == null) {
            LOG.debug("unable to get platform manifest attributes");
            return new PlatformInfo(platformName, null, parsedVersion);
        }
        String vendor = attributes.getValue("Implementation-Vendor");
        String version = attributes.getValue("Implementation-Version");
        if (Util.isEmpty((String)version)) {
            version = parsedVersion;
        }
        return new PlatformInfo(platformName, vendor, version);
    }

    public static Map<String, Long> syncPaths(Configuration config, Map<Path, Path> commonPaths, boolean syncTimes) {
        if (commonPaths == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Long> timestampMap = new HashMap<String, Long>();
        Map<Path, Path> copyPaths = HadoopUtil.getCopyPaths(config, commonPaths);
        LocalFileSystem localFS = HadoopUtil.getLocalFS(config);
        FileSystem remoteFS = HadoopUtil.getDefaultFS(config);
        for (Map.Entry<Path, Path> entry : copyPaths.entrySet()) {
            Path localPath = entry.getKey();
            Path remotePath = entry.getValue();
            try {
                LOG.info("copying from: {}, to: {}", (Object)localPath, (Object)remotePath);
                remoteFS.copyFromLocalFile(localPath, remotePath);
                if (!syncTimes) {
                    timestampMap.put(remotePath.getName(), remoteFS.getFileStatus(remotePath).getModificationTime());
                    continue;
                }
            }
            catch (IOException exception) {
                throw new FlowException("unable to copy local: " + localPath + " to remote: " + remotePath, (Throwable)exception);
            }
            FileStatus localFileStatus = null;
            try {
                localFileStatus = localFS.getFileStatus(localPath);
                remoteFS.setTimes(remotePath, localFileStatus.getModificationTime(), -1L);
            }
            catch (IOException exception) {
                LOG.info("unable to set local modification time on remote file: {}, 'dfs.namenode.accesstime.precision' may be set to 0 on HDFS.", (Object)remotePath);
                if (localFileStatus == null) continue;
                timestampMap.put(remotePath.getName(), localFileStatus.getModificationTime());
            }
        }
        return timestampMap;
    }

    public static Map<Path, Path> getCommonPaths(Map<String, Path> localPaths, Map<String, Path> remotePaths) {
        HashMap<Path, Path> commonPaths = new HashMap<Path, Path>();
        for (Map.Entry<String, Path> entry : localPaths.entrySet()) {
            if (!remotePaths.containsKey(entry.getKey())) continue;
            commonPaths.put(entry.getValue(), remotePaths.get(entry.getKey()));
        }
        return commonPaths;
    }

    private static Map<Path, Path> getCopyPaths(Configuration config, Map<Path, Path> commonPaths) {
        HashMap<Path, Path> copyPaths = new HashMap<Path, Path>();
        FileSystem remoteFS = HadoopUtil.getDefaultFS(config);
        LocalFileSystem localFS = HadoopUtil.getLocalFS(config);
        for (Map.Entry<Path, Path> entry : commonPaths.entrySet()) {
            Path localPath = entry.getKey();
            Path remotePath = entry.getValue();
            try {
                long remoteModTime;
                long localModTime;
                boolean localExists = localFS.exists(localPath);
                boolean remoteExist = remoteFS.exists(remotePath);
                if (localExists && !remoteExist) {
                    copyPaths.put(localPath, remotePath);
                    continue;
                }
                if (!localExists || (localModTime = localFS.getFileStatus(localPath).getModificationTime()) <= (remoteModTime = remoteFS.getFileStatus(remotePath).getModificationTime())) continue;
                copyPaths.put(localPath, remotePath);
            }
            catch (IOException exception) {
                throw new FlowException("unable to get handle to underlying filesystem", (Throwable)exception);
            }
        }
        return copyPaths;
    }

    public static void resolvePaths(Configuration config, Collection<String> classpath, String remoteRoot, String resourceSubPath, Map<String, Path> localPaths, Map<String, Path> remotePaths) {
        FileSystem defaultFS = HadoopUtil.getDefaultFS(config);
        LocalFileSystem localFS = HadoopUtil.getLocalFS(config);
        Path remoteRootPath = new Path(remoteRoot == null ? "./.staging" : remoteRoot);
        if (resourceSubPath != null) {
            remoteRootPath = new Path(remoteRootPath, resourceSubPath);
        }
        remoteRootPath = defaultFS.makeQualified(remoteRootPath);
        boolean defaultIsLocal = defaultFS.equals(localFS);
        for (String stringPath : classpath) {
            String name;
            Path localPath;
            Path path = new Path(stringPath);
            URI uri = path.toUri();
            if (uri.getScheme() == null && !defaultIsLocal) {
                localPath = localFS.makeQualified(path);
                if (!HadoopUtil.exists((FileSystem)localFS, localPath)) {
                    throw new FlowException("path not found: " + localPath);
                }
                name = localPath.getName();
                if (resourceSubPath != null) {
                    name = resourceSubPath + "/" + name;
                }
                localPaths.put(name, localPath);
                remotePaths.put(name, defaultFS.makeQualified(new Path(remoteRootPath, path.getName())));
                continue;
            }
            if (localFS.equals(HadoopUtil.getFileSystem(config, path))) {
                if (!HadoopUtil.exists((FileSystem)localFS, path)) {
                    throw new FlowException("path not found: " + path);
                }
                localPath = localFS.makeQualified(path);
                name = localPath.getName();
                if (resourceSubPath != null) {
                    name = resourceSubPath + "/" + name;
                }
                localPaths.put(name, localPath);
                continue;
            }
            if (!HadoopUtil.exists(defaultFS, path)) {
                throw new FlowException("path not found: " + path);
            }
            Path defaultPath = defaultFS.makeQualified(path);
            name = defaultPath.getName();
            if (resourceSubPath != null) {
                name = resourceSubPath + "/" + name;
            }
            remotePaths.put(name, defaultPath);
        }
    }

    private static boolean exists(FileSystem fileSystem, Path path) {
        try {
            return fileSystem.exists(path);
        }
        catch (IOException exception) {
            throw new FlowException("could not test file exists: " + path);
        }
    }

    private static FileSystem getFileSystem(Configuration config, Path path) {
        try {
            return path.getFileSystem(config);
        }
        catch (IOException exception) {
            throw new FlowException("unable to get handle to underlying filesystem", (Throwable)exception);
        }
    }

    public static LocalFileSystem getLocalFS(Configuration config) {
        try {
            return FileSystem.getLocal((Configuration)config);
        }
        catch (IOException exception) {
            throw new FlowException("unable to get handle to underlying filesystem", (Throwable)exception);
        }
    }

    public static FileSystem getDefaultFS(Configuration config) {
        try {
            return FileSystem.get((Configuration)config);
        }
        catch (IOException exception) {
            throw new FlowException("unable to get handle to underlying filesystem", (Throwable)exception);
        }
    }

    public static boolean isLocal(Configuration conf) {
        String frameworkName = conf.get("mapreduce.framework.name");
        if (frameworkName != null) {
            return frameworkName.equals("local");
        }
        String tezLocal = conf.get("tez.local.mode");
        if (tezLocal != null) {
            return tezLocal.equals("true");
        }
        String hadoop1 = conf.get("mapred.job.tracker");
        if (hadoop1 == null) {
            LOG.warn("could not successfully test if Hadoop based platform is in standalone/local mode, no valid properties set, returning false - tests for: mapreduce.framework.name, tez.local.mode, and mapred.job.tracker");
            return false;
        }
        return hadoop1.equals("local");
    }

    public static boolean isYARN(Configuration conf) {
        return conf.get("mapreduce.framework.name") != null;
    }

    public static void setLocal(Configuration conf) {
        conf.set("mapred.job.tracker", "local");
        conf.set("mapreduce.framework.name", "local");
        conf.set("tez.local.mode", "true");
        conf.set("tez.runtime.optimize.local.fetch", "true");
    }

    private static boolean interfaceAssignableFromClassName(Class<?> xface, String className) {
        if (className == null || xface == null) {
            return false;
        }
        try {
            Class<?> klass = Class.forName(className);
            if (klass == null) {
                return false;
            }
            return xface.isAssignableFrom(klass);
        }
        catch (ClassNotFoundException cnfe) {
            return false;
        }
    }

    public static boolean setNewApi(Configuration conf, String className) {
        boolean isNew;
        if (className == null) {
            return false;
        }
        boolean isStable = className.startsWith("org.apache.hadoop.mapred.") || HadoopUtil.interfaceAssignableFromClassName(org.apache.hadoop.mapred.InputFormat.class, className);
        boolean bl = isNew = className.startsWith("org.apache.hadoop.mapreduce.") || HadoopUtil.interfaceAssignableFromClassName(InputFormat.class, className);
        if (isStable) {
            conf.setBoolean("mapred.mapper.new-api", false);
        } else if (isNew) {
            conf.setBoolean("mapred.mapper.new-api", true);
        } else {
            throw new IllegalStateException("cannot determine if class denotes stable or new api, please set 'mapred.mapper.new-api' to the appropriate value");
        }
        return true;
    }

    public static void addInputPaths(Configuration conf, Iterable<Path> paths) {
        Path workingDirectory = HadoopUtil.getWorkingDirectory(conf);
        String dirs = conf.get("mapred.input.dir");
        StringBuilder buffer = new StringBuilder(dirs == null ? "" : dirs);
        for (Path path : paths) {
            if (!path.isAbsolute()) {
                path = new Path(workingDirectory, path);
            }
            String dirStr = StringUtils.escapeString((String)path.toString());
            if (buffer.length() != 0) {
                buffer.append(',');
            }
            buffer.append(dirStr);
        }
        conf.set("mapred.input.dir", buffer.toString());
    }

    public static void addInputPath(Configuration conf, Path path) {
        Path workingDirectory = HadoopUtil.getWorkingDirectory(conf);
        path = new Path(workingDirectory, path);
        String dirStr = StringUtils.escapeString((String)path.toString());
        String dirs = conf.get("mapred.input.dir");
        conf.set("mapred.input.dir", dirs == null ? dirStr : dirs + "," + dirStr);
    }

    public static void setOutputPath(Configuration conf, Path path) {
        Path workingDirectory = HadoopUtil.getWorkingDirectory(conf);
        path = new Path(workingDirectory, path);
        conf.set("mapred.output.dir", path.toString());
    }

    private static Path getWorkingDirectory(Configuration conf) {
        String name = conf.get("mapred.working.dir");
        if (name != null) {
            return new Path(name);
        }
        try {
            Path dir = FileSystem.get((Configuration)conf).getWorkingDirectory();
            conf.set("mapred.working.dir", dir.toString());
            return dir;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Path getOutputPath(Configuration conf) {
        String name = conf.get("mapred.output.dir");
        return name == null ? null : new Path(name);
    }

    public static String pack(Object object, Configuration conf) {
        if (object == null) {
            return "";
        }
        try {
            return HadoopUtil.serializeBase64(object, conf, true);
        }
        catch (IOException exception) {
            throw new FlowException("unable to pack object: " + object.getClass().getCanonicalName(), (Throwable)exception);
        }
    }

    public static void addFields(Configuration conf, String property, Map<Integer, Fields> fields) {
        if (fields == null || fields.isEmpty()) {
            return;
        }
        HashMap<String, Fields> toPack = new HashMap<String, Fields>();
        for (Map.Entry<Integer, Fields> entry : fields.entrySet()) {
            toPack.put(entry.getKey().toString(), entry.getValue());
        }
        conf.set(property, HadoopUtil.pack(toPack, conf));
    }

    public static Map<Integer, Fields> getFields(Configuration conf, String property) throws IOException {
        String value = conf.getRaw(property);
        if (value == null || value.isEmpty()) {
            return Collections.emptyMap();
        }
        Map map = HadoopUtil.deserializeBase64(value, conf, Map.class, true);
        HashMap<Integer, Fields> result = new HashMap<Integer, Fields>();
        for (Map.Entry entry : map.entrySet()) {
            result.put(Integer.parseInt((String)entry.getKey()), (Fields)entry.getValue());
        }
        return result;
    }

    public static void addComparators(Configuration conf, String property, Map<String, Fields> map, BaseFlowStep flowStep, Group group) {
        Iterator<Fields> fieldsIterator = map.values().iterator();
        if (!fieldsIterator.hasNext()) {
            return;
        }
        Fields fields = fieldsIterator.next();
        if (fields.hasComparators()) {
            conf.set(property, HadoopUtil.pack(fields, conf));
            return;
        }
        Set previousScopes = flowStep.getPreviousScopes((FlowElement)group);
        fields = ((Scope)previousScopes.iterator().next()).getOutValuesFields();
        if (fields.size() != 0) {
            conf.setInt(property + ".size", fields.size());
        }
    }

    public static void addComparators(Configuration conf, String property, Map<String, Fields> map, Fields resolvedFields) {
        Iterator<Fields> fieldsIterator = map.values().iterator();
        if (!fieldsIterator.hasNext()) {
            return;
        }
        while (fieldsIterator.hasNext()) {
            Fields fields = fieldsIterator.next();
            if (!fields.hasComparators()) continue;
            conf.set(property, HadoopUtil.pack(fields, conf));
            return;
        }
        if (resolvedFields.size() != 0) {
            conf.setInt(property + ".size", resolvedFields.size());
        }
    }
}

