/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.hadoop.util;

import cascading.CascadingException;
import cascading.tuple.StreamComparator;
import cascading.tuple.hadoop.io.HadoopTupleInputStream;
import java.io.InputStream;
import java.util.Comparator;

public class TypedTupleElementStreamComparator
implements StreamComparator<HadoopTupleInputStream>,
Comparator<Object> {
    private final Class type;
    final StreamComparator comparator;

    public TypedTupleElementStreamComparator(Class type, StreamComparator comparator) {
        this.type = type;
        this.comparator = comparator;
    }

    @Override
    public int compare(Object lhs, Object rhs) {
        return ((Comparator)this.comparator).compare(lhs, rhs);
    }

    @Override
    public int compare(HadoopTupleInputStream lhsStream, HadoopTupleInputStream rhsStream) {
        try {
            InputStream lhs = lhsStream.getInputStream();
            InputStream rhs = rhsStream.getInputStream();
            if (!this.type.isPrimitive()) {
                int lhsToken = lhsStream.readToken();
                int rhsToken = rhsStream.readToken();
                lhs = lhsToken == 0 ? null : lhs;
                rhs = rhsToken == 0 ? null : rhs;
            }
            return this.comparator.compare(lhs, rhs);
        }
        catch (Exception exception) {
            throw new CascadingException("unable to compare Tuples, likely a CoGroup is being attempted on fields of different types or custom comparators are incorrectly set on Fields", (Throwable)exception);
        }
    }
}

