/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.hadoop.util;

import cascading.CascadingException;
import cascading.tuple.StreamComparator;
import cascading.tuple.io.TupleInputStream;
import java.io.IOException;
import java.util.Comparator;

public class TypedTupleElementComparator
implements StreamComparator<TupleInputStream>,
Comparator<Object> {
    private Class type;
    Comparator comparator = new Comparator<Comparable>(){

        @Override
        public int compare(Comparable lhs, Comparable rhs) {
            if (lhs == null && rhs == null) {
                return 0;
            }
            if (lhs == null) {
                return -1;
            }
            if (rhs == null) {
                return 1;
            }
            return lhs.compareTo(rhs);
        }
    };

    public TypedTupleElementComparator() {
    }

    public TypedTupleElementComparator(Class type, Comparator comparator) {
        this.type = type;
        if (comparator != null) {
            this.comparator = comparator;
        }
    }

    @Override
    public int compare(Object lhs, Object rhs) {
        return this.comparator.compare(lhs, rhs);
    }

    @Override
    public int compare(TupleInputStream lhsStream, TupleInputStream rhsStream) {
        Object rhs;
        Object lhs;
        try {
            lhs = lhsStream.readType(this.type);
            rhs = rhsStream.readType(this.type);
        }
        catch (IOException exception) {
            throw new CascadingException("unable to read element from underlying stream", (Throwable)exception);
        }
        try {
            return this.comparator.compare(lhs, rhs);
        }
        catch (Exception exception) {
            throw new CascadingException("unable to compare Tuples, likely a CoGroup is being attempted on fields of different types or custom comparators are incorrectly set on Fields, lhs: '" + lhs + "' rhs: '" + rhs + "'", (Throwable)exception);
        }
    }
}

