/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.hadoop.util;

import cascading.flow.hadoop.util.ResettableCollection;
import cascading.tuple.Tuple;
import java.util.Collection;
import java.util.Iterator;

public class LazyCollection
implements Collection<Tuple>,
ResettableCollection<Iterator<Tuple>> {
    Iterator<Tuple> iterator;
    Collection<Tuple> parent;

    public static Collection<Tuple> getParent(LazyCollection collection) {
        return collection.parent;
    }

    public LazyCollection(Collection<Tuple> parent) {
        this.parent = parent;
    }

    @Override
    public int size() {
        return this.parent.size();
    }

    @Override
    public boolean isEmpty() {
        return !this.iterator.hasNext() && this.parent.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.parent.contains(o);
    }

    @Override
    public Iterator<Tuple> iterator() {
        if (!this.iterator.hasNext()) {
            return this.parent.iterator();
        }
        return new Iterator<Tuple>(){

            @Override
            public boolean hasNext() {
                return LazyCollection.this.iterator.hasNext();
            }

            @Override
            public Tuple next() {
                Tuple next = LazyCollection.this.iterator.next();
                LazyCollection.this.parent.add(next);
                return next;
            }

            @Override
            public void remove() {
                LazyCollection.this.iterator.remove();
            }
        };
    }

    @Override
    public Object[] toArray() {
        return this.parent.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.parent.toArray(a);
    }

    @Override
    public boolean add(Tuple objects) {
        return this.parent.add(objects);
    }

    @Override
    public boolean remove(Object o) {
        return this.parent.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.parent.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends Tuple> c) {
        return this.parent.addAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.parent.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.parent.retainAll(c);
    }

    @Override
    public void clear() {
        this.parent.clear();
    }

    @Override
    public boolean equals(Object o) {
        return this.parent.equals(o);
    }

    @Override
    public int hashCode() {
        return this.parent.hashCode();
    }

    @Override
    public void reset(Iterator<Tuple> iterator) {
        this.iterator = iterator;
    }
}

