/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.hadoop.stream;

import cascading.CascadingException;
import cascading.flow.FlowProcess;
import cascading.flow.SliceCounters;
import cascading.flow.hadoop.HadoopGroupByClosure;
import cascading.flow.stream.duct.Duct;
import cascading.flow.stream.duct.DuctException;
import cascading.flow.stream.element.GroupingSpliceGate;
import cascading.flow.stream.graph.IORole;
import cascading.flow.stream.graph.StreamGraph;
import cascading.pipe.Splice;
import cascading.pipe.joiner.BufferJoin;
import cascading.pipe.joiner.JoinerClosure;
import cascading.tap.hadoop.util.MeasuredOutputCollector;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.mapred.OutputCollector;

public abstract class HadoopGroupGate
extends GroupingSpliceGate {
    protected HadoopGroupByClosure closure;
    protected OutputCollector collector;
    private final boolean isBufferJoin;

    public HadoopGroupGate(FlowProcess flowProcess, Splice splice, IORole role) {
        super(flowProcess, splice, role);
        this.isBufferJoin = splice.getJoiner() instanceof BufferJoin;
    }

    public void bind(StreamGraph streamGraph) {
        if (this.role != IORole.sink) {
            this.next = this.getNextFor(streamGraph);
        }
    }

    public void prepare() {
        if (this.role != IORole.source) {
            this.collector = new MeasuredOutputCollector(this.flowProcess, (Enum)SliceCounters.Write_Duration, this.createOutputCollector());
        }
        if (this.role != IORole.sink) {
            this.closure = this.createClosure();
        }
        if (this.grouping != null && this.splice.getJoinDeclaredFields() != null && this.splice.getJoinDeclaredFields().isNone()) {
            this.grouping.joinerClosure = this.closure;
        }
    }

    protected abstract OutputCollector createOutputCollector();

    public void start(Duct previous) {
        if (this.next != null) {
            super.start(previous);
        }
    }

    public void receive(Duct previous, int ordinal, TupleEntry incomingEntry) {
        Tuple groupTupleView = this.keyBuilder[ordinal].makeResult(incomingEntry.getTuple(), null);
        if (this.sortFields == null) {
            this.groupTuple.reset((Object)groupTupleView);
        } else {
            this.groupSortTuple.reset((Object)groupTupleView, (Object)this.sortBuilder[ordinal].makeResult(incomingEntry.getTuple(), null));
        }
        this.valueTuple.reset((Object)this.valuesBuilder[ordinal].makeResult(incomingEntry.getTuple(), null));
        try {
            this.wrapGroupingAndCollect(previous, ordinal, (Tuple)this.valueTuple, this.keyTuple);
            this.flowProcess.increment((Enum)SliceCounters.Tuples_Written, 1L);
        }
        catch (OutOfMemoryError error) {
            this.handleReThrowableException("out of memory, try increasing task memory allocation", error);
        }
        catch (CascadingException exception) {
            this.handleException(exception, incomingEntry);
        }
        catch (Throwable throwable) {
            this.handleException((Throwable)new DuctException("internal error: " + incomingEntry.getTuple().print(), throwable), incomingEntry);
        }
    }

    public void complete(Duct previous) {
        if (this.next != null) {
            super.complete(previous);
        }
    }

    public void accept(Tuple key, Iterator<Tuple>[] values) {
        key = this.unwrapGrouping(key);
        this.closure.reset(key, values);
        if (!this.isBufferJoin) {
            this.tupleEntryIterator.reset(this.splice.getJoiner().getIterator((JoinerClosure)this.closure));
        } else {
            this.tupleEntryIterator.reset((Iterator[])values);
        }
        this.keyEntry.setTuple(this.closure.getGroupTuple(key));
        this.next.receive((Duct)this, 0, (Object)this.grouping);
    }

    protected abstract HadoopGroupByClosure createClosure();

    protected abstract void wrapGroupingAndCollect(Duct var1, int var2, Tuple var3, Tuple var4) throws IOException;

    protected abstract Tuple unwrapGrouping(Tuple var1);
}

