/*
 * Decompiled with CFR 0.152.
 */
package cascading.platform.hadoop;

import cascading.flow.FlowProcess;
import cascading.flow.FlowProcessWrapper;
import cascading.scheme.SinkCall;
import cascading.scheme.SourceCall;
import cascading.scheme.hadoop.TextLine;
import cascading.tap.Tap;
import cascading.tuple.Fields;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;

public class HadoopConfigDefScheme
extends TextLine {
    private final boolean supportsNodeConfig;

    public HadoopConfigDefScheme(Fields sourceFields, boolean supportsNodeConfig) {
        super(sourceFields);
        this.supportsNodeConfig = supportsNodeConfig;
    }

    public void sourceConfInit(FlowProcess<? extends Configuration> flowProcess, Tap<Configuration, RecordReader, OutputCollector> tap, Configuration conf) {
        if (flowProcess.getProperty("default") != null) {
            throw new RuntimeException("default should be null");
        }
        super.sourceConfInit(flowProcess, tap, conf);
    }

    public void sinkConfInit(FlowProcess<? extends Configuration> flowProcess, Tap<Configuration, RecordReader, OutputCollector> tap, Configuration conf) {
        if (flowProcess.getProperty("default") != null) {
            throw new RuntimeException("default should be null");
        }
        super.sinkConfInit(flowProcess, tap, conf);
    }

    public void sourcePrepare(FlowProcess<? extends Configuration> flowProcess, SourceCall<Object[], RecordReader> sourceCall) {
        if (!(flowProcess instanceof FlowProcessWrapper)) {
            throw new RuntimeException("not a flow process wrapper");
        }
        if (!"process-default".equals(flowProcess.getProperty("default"))) {
            throw new RuntimeException("not default value");
        }
        if (!"source-replace".equals(flowProcess.getProperty("replace"))) {
            throw new RuntimeException("not replaced value");
        }
        if (this.supportsNodeConfig && !"node-replace".equals(flowProcess.getProperty("default-node"))) {
            throw new RuntimeException("not replaced value");
        }
        if (!"process-default".equals((flowProcess = ((FlowProcessWrapper)flowProcess).getDelegate()).getProperty("default"))) {
            throw new RuntimeException("not default value");
        }
        if (!"process-replace".equals(flowProcess.getProperty("replace"))) {
            throw new RuntimeException("not replaced value");
        }
        super.sourcePrepare(flowProcess, sourceCall);
    }

    public void sinkPrepare(FlowProcess<? extends Configuration> flowProcess, SinkCall<Object[], OutputCollector> sinkCall) throws IOException {
        if (!(flowProcess instanceof FlowProcessWrapper)) {
            throw new RuntimeException("not a flow process wrapper");
        }
        if (!"process-default".equals(flowProcess.getProperty("default"))) {
            throw new RuntimeException("not default value");
        }
        if (!"sink-replace".equals(flowProcess.getProperty("replace"))) {
            throw new RuntimeException("not replaced value");
        }
        if (!"process-default".equals((flowProcess = ((FlowProcessWrapper)flowProcess).getDelegate()).getProperty("default"))) {
            throw new RuntimeException("not default value");
        }
        if (!"process-replace".equals(flowProcess.getProperty("replace"))) {
            throw new RuntimeException("not replaced value");
        }
        super.sinkPrepare(flowProcess, sinkCall);
    }
}

