/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.hadoop.util;

import cascading.CascadingException;
import cascading.tuple.Tuple;
import cascading.tuple.hadoop.util.DeserializerComparator;
import java.io.IOException;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTupleComparator
extends DeserializerComparator<Tuple>
implements Configurable {
    private static final Logger LOG = LoggerFactory.getLogger(BaseTupleComparator.class);
    RawComparison actual;

    @Override
    protected boolean canPerformRawComparisons() {
        return !this.getConf().getBoolean("cascading.serialization.comparison.bitwise.prevent", false);
    }

    @Override
    public void setConf(Configuration conf) {
        super.setConf(conf);
        if (conf == null) {
            return;
        }
        if (this.performRawComparison()) {
            LOG.info("enabling raw byte comparison and ordering");
        }
        this.actual = this.performRawComparison() ? this.getByteComparison() : this.getStreamComparison();
    }

    protected RawComparison getStreamComparison() {
        return new StreamComparison();
    }

    protected abstract RawComparison getByteComparison();

    public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
        return this.actual.compare(b1, s1, l1, b2, s2, l2);
    }

    public int compare(Tuple lhs, Tuple rhs) {
        return this.compareTuples(this.groupComparators, lhs, rhs);
    }

    class StreamComparison
    implements RawComparison {
        StreamComparison() {
        }

        @Override
        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            try {
                BaseTupleComparator.this.lhsBuffer.reset(b1, s1, l1);
                BaseTupleComparator.this.rhsBuffer.reset(b2, s2, l2);
                int n = BaseTupleComparator.this.compareTuples(BaseTupleComparator.this.keyTypes, BaseTupleComparator.this.groupComparators);
                return n;
            }
            catch (IOException exception) {
                throw new CascadingException((Throwable)exception);
            }
            finally {
                BaseTupleComparator.this.lhsBuffer.clear();
                BaseTupleComparator.this.rhsBuffer.clear();
            }
        }
    }

    protected static interface RawComparison {
        public int compare(byte[] var1, int var2, int var3, byte[] var4, int var5, int var6);
    }
}

