/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.hadoop;

import cascading.property.ConfigDef;
import org.apache.hadoop.conf.Configuration;

public class ConfigurationSetter
implements ConfigDef.Setter {
    private final Configuration conf;

    public ConfigurationSetter(Configuration conf) {
        this.conf = conf;
    }

    public String set(String key, String value) {
        String oldValue = this.get(key);
        this.conf.set(key, value);
        return oldValue;
    }

    public String update(String key, String value) {
        String oldValue = this.get(key);
        if (oldValue == null) {
            this.conf.set(key, value);
        } else if (!oldValue.contains(value)) {
            this.conf.set(key, oldValue + "," + value);
        }
        return oldValue;
    }

    public String get(String key) {
        String value = this.conf.get(key);
        if (value == null || value.isEmpty()) {
            return null;
        }
        return value;
    }
}

